/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogAbgangsgrundEintrag;
import jakarta.validation.constraints.NotNull;

public enum LehrerAbgangsgrund {
    RUHEST(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(1L, "RUHEST", "Eintritt in den Ruhestand", "11", null, null)}),
    UNFAEHIGK(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(2L, "UNF\u00c4HIGK", "Dienst-, Erwerbs-, Berufsunf\u00e4higkeit", "12", null, null)}),
    TOD(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(3L, "TOD", "Tod", "13", null, null)}),
    AndBuLand(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(4L, "AndBuLand", "\u00dcbertritt in den Schuldienst eines anderen Bundeslandes", "14", null, null)}),
    WECHSEL(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(5L, "WECHSEL", "Wechsel innerhalb des Landes von der berichtenden Schule an eine andere Schule", "15", null, null)}),
    BEFRIST(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(6L, "BEFRIST", "Befristete Abg\u00e4nge", "16", null, null)}),
    SONSTIG(new LehrerKatalogAbgangsgrundEintrag[]{new LehrerKatalogAbgangsgrundEintrag(7L, "SONSTIG", "Sonstige Abg\u00e4nge", "17", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogAbgangsgrundEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogAbgangsgrundEintrag @NotNull [] historie;

    private LehrerAbgangsgrund(LehrerKatalogAbgangsgrundEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    public static LehrerAbgangsgrund getByID(int id) {
        for (LehrerAbgangsgrund grund : LehrerAbgangsgrund.values()) {
            if (grund.daten.id != (long)id) continue;
            return grund;
        }
        return null;
    }

    public static LehrerAbgangsgrund getByKuerzel(String kuerzel) {
        for (LehrerAbgangsgrund grund : LehrerAbgangsgrund.values()) {
            if (!grund.daten.kuerzel.equals(kuerzel)) continue;
            return grund;
        }
        return null;
    }

    public static LehrerAbgangsgrund getByASDSchluessel(String schluessel) {
        for (LehrerAbgangsgrund grund : LehrerAbgangsgrund.values()) {
            if (!grund.daten.schluessel.equals(schluessel)) continue;
            return grund;
        }
        return null;
    }
}

