/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogBeschaeftigungsartEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerBeschaeftigungsart {
    V(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(1L, "V", "Vollzeit", null, null)}),
    T(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(2L, "T", "Teilzeit", null, null)}),
    AT(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(3L, "AT", "Altersteilzeit (Besch\u00e4ftigungsphase)", null, null)}),
    TA(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(4L, "TA", "Altersteilzeit, vorm. teilzeitbesch\u00e4ftigt (Verzichtsphase Alterserm\u00e4\u00dfigung)", null, null)}),
    VA(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(5L, "VA", "Altersteilzeit, vorm. vollzeitbesch\u00e4ftigt (Verzichtsphase Alterserm\u00e4\u00dfigung)", null, null)}),
    TS(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(6L, "TS", "Sabbatjahr", null, null)}),
    SB(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(8L, "SB", "Nebenberufliche Besch\u00e4ftigung", null, null)}),
    GB(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(9L, "GB", "Geringf\u00fcgige Besch\u00e4ftigung", null, null)}),
    ST(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(11L, "ST", "Studierende", null, null)}),
    NA(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(12L, "NA", "Beamter, nebenamtlich (nicht hauptamtlich im Schuldienst)", null, null)}),
    G(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(13L, "G", "Gestellungsvertrag", null, null)}),
    X(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(15L, "X", "Unentgeltlich Besch\u00e4ftigte", null, null)}),
    WT(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(16L, "WT", "Beamte auf Widerruf (LAA) in Teilzeit", null, null)}),
    WV(new LehrerKatalogBeschaeftigungsartEintrag[]{new LehrerKatalogBeschaeftigungsartEintrag(17L, "WV", "Beamte auf Widerruf (LAA) in Vollzeit", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogBeschaeftigungsartEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogBeschaeftigungsartEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerBeschaeftigungsart> _artenByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerBeschaeftigungsart> _artenByKuerzel;

    private LehrerBeschaeftigungsart(LehrerKatalogBeschaeftigungsartEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerBeschaeftigungsart> getMapArtenByID() {
        if (_artenByID.size() == 0) {
            for (LehrerBeschaeftigungsart l : LehrerBeschaeftigungsart.values()) {
                _artenByID.put(l.daten.id, l);
            }
        }
        return _artenByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerBeschaeftigungsart> getMapArtenByKuerzel() {
        if (_artenByKuerzel.size() == 0) {
            for (LehrerBeschaeftigungsart l : LehrerBeschaeftigungsart.values()) {
                _artenByKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _artenByKuerzel;
    }

    public static LehrerBeschaeftigungsart getByID(long id) {
        return LehrerBeschaeftigungsart.getMapArtenByID().get(id);
    }

    public static LehrerBeschaeftigungsart getByKuerzel(String kuerzel) {
        return LehrerBeschaeftigungsart.getMapArtenByKuerzel().get(kuerzel);
    }

    static {
        _artenByID = new HashMap();
        _artenByKuerzel = new HashMap();
    }
}

