/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogEinsatzstatusEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerEinsatzstatus {
    A(new LehrerKatalogEinsatzstatusEintrag[]{new LehrerKatalogEinsatzstatusEintrag(1L, "A", "Stammschule, ganz oder teilweise auch an anderen Schulen t\u00e4tig", null, null)}),
    B(new LehrerKatalogEinsatzstatusEintrag[]{new LehrerKatalogEinsatzstatusEintrag(2L, "B", "nicht Stammschule, aber auch hier t\u00e4tig", null, null)}),
    DEFAULT(new LehrerKatalogEinsatzstatusEintrag[]{new LehrerKatalogEinsatzstatusEintrag(3L, "*", "Stammschule, nur hier t\u00e4tig", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogEinsatzstatusEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogEinsatzstatusEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerEinsatzstatus> _statusByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerEinsatzstatus> _statusByKuerzel;

    private LehrerEinsatzstatus(LehrerKatalogEinsatzstatusEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerEinsatzstatus> getMapStatusByID() {
        if (_statusByID.size() == 0) {
            for (LehrerEinsatzstatus g : LehrerEinsatzstatus.values()) {
                _statusByID.put(g.daten.id, g);
            }
        }
        return _statusByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerEinsatzstatus> getMapStatusByKuerzel() {
        if (_statusByKuerzel.size() == 0) {
            for (LehrerEinsatzstatus g : LehrerEinsatzstatus.values()) {
                _statusByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _statusByKuerzel;
    }

    public static LehrerEinsatzstatus getByID(long id) {
        return LehrerEinsatzstatus.getMapStatusByID().get(id);
    }

    public static LehrerEinsatzstatus getByKuerzel(String kuerzel) {
        return LehrerEinsatzstatus.getMapStatusByKuerzel().get(kuerzel);
    }

    static {
        _statusByID = new HashMap();
        _statusByKuerzel = new HashMap();
    }
}

