/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogFachrichtungAnerkennungEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerFachrichtungAnerkennung {
    ID4(new LehrerKatalogFachrichtungAnerkennungEintrag[]{new LehrerKatalogFachrichtungAnerkennungEintrag(4L, "1", "erworben durch LABG/OVP bzw. Laufbahnverordnung", null, null)}),
    ID5(new LehrerKatalogFachrichtungAnerkennungEintrag[]{new LehrerKatalogFachrichtungAnerkennungEintrag(5L, "2", "Unterrichtserlaubnis (z. B. Zertifikatskurs)", null, null)}),
    ID6(new LehrerKatalogFachrichtungAnerkennungEintrag[]{new LehrerKatalogFachrichtungAnerkennungEintrag(6L, "3", "mehrj\u00e4hriger Unterricht ohne Lehramtspr\u00fcfung oder Unterrichtserlaubnis", null, null)}),
    ID7(new LehrerKatalogFachrichtungAnerkennungEintrag[]{new LehrerKatalogFachrichtungAnerkennungEintrag(7L, "9", "sonstige", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogFachrichtungAnerkennungEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogFachrichtungAnerkennungEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerFachrichtungAnerkennung> _anerkennungenByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerFachrichtungAnerkennung> _anerkennungenByKuerzel;

    private LehrerFachrichtungAnerkennung(LehrerKatalogFachrichtungAnerkennungEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerFachrichtungAnerkennung> getMapAnerkennungenByID() {
        if (_anerkennungenByID.size() == 0) {
            for (LehrerFachrichtungAnerkennung l : LehrerFachrichtungAnerkennung.values()) {
                _anerkennungenByID.put(l.daten.id, l);
            }
        }
        return _anerkennungenByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerFachrichtungAnerkennung> getMapAnerkennungenByKuerzel() {
        if (_anerkennungenByKuerzel.size() == 0) {
            for (LehrerFachrichtungAnerkennung l : LehrerFachrichtungAnerkennung.values()) {
                _anerkennungenByKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _anerkennungenByKuerzel;
    }

    public static LehrerFachrichtungAnerkennung getByID(long id) {
        return LehrerFachrichtungAnerkennung.getMapAnerkennungenByID().get(id);
    }

    public static LehrerFachrichtungAnerkennung getByKuerzel(String kuerzel) {
        return LehrerFachrichtungAnerkennung.getMapAnerkennungenByKuerzel().get(kuerzel);
    }

    static {
        _anerkennungenByID = new HashMap();
        _anerkennungenByKuerzel = new HashMap();
    }
}

