/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogLehramtEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerLehramt {
    ID_00(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(82L, "00", "f\u00fcr die Primarstufe", null, null)}),
    ID_01(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(83L, "01", "an der Grund- und Hauptschule (Stufenschwerpunkt I)", null, null)}),
    ID_02(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(84L, "02", "an der Grund- und Hauptschule (Stufenschwerpunkt II)", null, null)}),
    ID_03(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(85L, "03", "an der Volksschule", null, null)}),
    ID_09(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(86L, "09", "f\u00fcr Sonderp\u00e4dagogik", null, null)}),
    ID_10(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(87L, "10", "an Sonderschulen", null, null)}),
    ID_11(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(88L, "11", "f\u00fcr Sonderp\u00e4dagogik und die Primarstufe", null, null)}),
    ID_12(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(89L, "12", "f\u00fcr Sonderp\u00e4dagogik und die Sekundarstufe I", null, null)}),
    ID_14(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(90L, "14", "Sonderp\u00e4dagogik LPO 03", null, null)}),
    ID_15(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(91L, "15", "Grund-, Haupt- u. Realschule u. entspr. Jahrg.stufen d. Gesamtschule -Schwerp.- Grundschule", null, null)}),
    ID_16(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(92L, "16", "Grund-, Haupt- u. Realschule u. entspr. Jahrg.stufen d. Gesamtsch. -Schwerp.- H/R/Gesamtsch.", null, null)}),
    ID_19(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(93L, "19", "f\u00fcr die Sekundarstufe I und die Primarstufe", null, null)}),
    ID_20(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(94L, "20", "f\u00fcr die Sekundarstufe I", null, null)}),
    ID_21(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(95L, "21", "an der Realschule", null, null)}),
    ID_24(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(96L, "24", "f\u00fcr die Sekundarstufe II und die Sekundarstufe I", null, null)}),
    ID_25(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(97L, "25", "am Gymnasium", null, null)}),
    ID_27(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(98L, "27", "Gymnasium und Gesamtschule", null, null)}),
    ID_29(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(99L, "29", "f\u00fcr die Sekundarstufe II (ohne berufliche Fachrichtung)", null, null)}),
    ID_30(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(100L, "30", "an berufsbildenden Schulen (alle Lehrer mit 2. Staatspr\u00fcfung oder erworbener Anstellungsf\u00e4higkeit)", null, null)}),
    ID_31(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(101L, "31", "f\u00fcr die Sekundarstufe II und Sonderp\u00e4dagogik", null, null)}),
    ID_32(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(102L, "32", "f\u00fcr die Sekundarstufe II (mit beruflicher Fachrichtung)", null, null)}),
    ID_35(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(103L, "35", "Berufskolleg", null, null)}),
    ID_40(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(104L, "40", "Fachhochschullehrer", null, null)}),
    ID_50(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(105L, "50", "Fachlehrer an Sonderschulen", null, null)}),
    ID_51(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(106L, "51", "Religionslehrer/Geistlicher/Katechet", null, null)}),
    ID_52(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(107L, "52", "Fachlehrer mit der Bef\u00e4higung f\u00fcr die Laufbahn des Werkstattlehrers", null, null)}),
    ID_53(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(108L, "53", "Fachlehrer", null, null)}),
    ID_54(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(109L, "54", "Fachlehrer f\u00fcr Kurzschrift und Maschinenschreiben", null, null)}),
    ID_55(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(110L, "55", "Fachlehrer mit der Bef\u00e4higung f\u00fcr die Laufbahn des technischen Lehrers an beruflichen Schulen", null, null)}),
    ID_56(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(111L, "56", "Schulkinderg\u00e4rtnerin", null, null)}),
    ID_57(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(112L, "57", "ohne sonderp\u00e4d. Zusatzausbildung:Sozialarbeiter, Sozialp\u00e4dagoge, Jugendleiter", null, null)}),
    ID_58(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(113L, "58", "ohne sonderp\u00e4d. Zusatzausbildung:Erzieher, Kinderg\u00e4rtnerin u.a.", null, null)}),
    ID_59(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(114L, "59", "ohne sonderp\u00e4d. Zusatzausbildung:Sonstige p\u00e4dagogische Unterrichtshilfe", null, null)}),
    ID_60(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(115L, "60", "mit sonderp\u00e4d. Zusatzausbildung:Sozialarbeiter, Sozialp\u00e4dagoge, Jugendleiter", null, null)}),
    ID_61(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(116L, "61", "mit sonderp\u00e4d. Zusatzausbildung:Erzieher, Kinderg\u00e4rtnerin u.a.", null, null)}),
    ID_62(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(117L, "62", "mit sonderp\u00e4d. Zusatzausbildung:Sonstige p\u00e4dagogische Unterrichtshilfe", null, null)}),
    ID_96(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(118L, "96", "Lehrer, der eine Qualifikation erworben hat, die der 1. Staatspr\u00fcfung entspricht (z.B. Diplom, sofern nicht Schl\u00fcssel 98)", null, null)}),
    ID_97(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(119L, "97", "Lehrer, der au\u00dferhalb des Geltungsbereichs des Grundgesetzes seine Qualifikation erworben hat", null, null)}),
    ID_98(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(120L, "98", "Lehramtsanw\u00e4rter/Studienreferendar", null, null)}),
    ID_99(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(121L, "99", "Sonstiger Lehrer (Gymnastik-, Werk-, Hauswirtschaftslehrer, \u00dcbungsleiter)", null, null)}),
    ID_70(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(122L, "70", "Schulverwaltungsassistent", null, null)}),
    ID_04(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(123L, "04", "Grundschule", null, null)}),
    ID_17(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(124L, "17", "Haupt-, Real- und  Gesamtschule", null, null)}),
    ID_08(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(125L, "08", "Sonderp\u00e4dagogische F\u00f6rderung", null, null)}),
    ID_18(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(126L, "18", "Haupt-, Real-, Sekundar- und Gesamtschule", null, null)}),
    ID_49(new LehrerKatalogLehramtEintrag[]{new LehrerKatalogLehramtEintrag(127L, "49", "Berufskolleg mit einer beruflichen Fachrichtung (\u00a7 59 LVO)", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogLehramtEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogLehramtEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerLehramt> _aemterByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerLehramt> _aemterByKuerzel;

    private LehrerLehramt(LehrerKatalogLehramtEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerLehramt> getMapLehraemterByID() {
        if (_aemterByID.size() == 0) {
            for (LehrerLehramt l : LehrerLehramt.values()) {
                _aemterByID.put(l.daten.id, l);
            }
        }
        return _aemterByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerLehramt> getMapLehraemterByKuerzel() {
        if (_aemterByKuerzel.size() == 0) {
            for (LehrerLehramt l : LehrerLehramt.values()) {
                _aemterByKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _aemterByKuerzel;
    }

    public static LehrerLehramt getByID(long id) {
        return LehrerLehramt.getMapLehraemterByID().get(id);
    }

    public static LehrerLehramt getByKuerzel(String kuerzel) {
        return LehrerLehramt.getMapLehraemterByKuerzel().get(kuerzel);
    }

    static {
        _aemterByID = new HashMap();
        _aemterByKuerzel = new HashMap();
    }
}

