/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogLehramtAnerkennungEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerLehramtAnerkennung {
    ST(new LehrerKatalogLehramtAnerkennungEintrag[]{new LehrerKatalogLehramtAnerkennungEintrag(1L, "ST", "Zweite Staatspr\u00fcfung f\u00fcr ein Lehramt", null, null)}),
    AL(new LehrerKatalogLehramtAnerkennungEintrag[]{new LehrerKatalogLehramtAnerkennungEintrag(2L, "AL", "Anerkennung Lehramt", null, null)}),
    AP(new LehrerKatalogLehramtAnerkennungEintrag[]{new LehrerKatalogLehramtAnerkennungEintrag(3L, "AP", "Anerkennung geeignete Pr\u00fcfung", null, null)}),
    BT(new LehrerKatalogLehramtAnerkennungEintrag[]{new LehrerKatalogLehramtAnerkennungEintrag(4L, "BT", "F\u00f6rderliche Berufst\u00e4tigkeit", null, null)}),
    OH(new LehrerKatalogLehramtAnerkennungEintrag[]{new LehrerKatalogLehramtAnerkennungEintrag(5L, "OH", "ohne", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogLehramtAnerkennungEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogLehramtAnerkennungEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerLehramtAnerkennung> _anerkennungenByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerLehramtAnerkennung> _anerkennungenByKuerzel;

    private LehrerLehramtAnerkennung(LehrerKatalogLehramtAnerkennungEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerLehramtAnerkennung> getMapAnerkennungenByID() {
        if (_anerkennungenByID.size() == 0) {
            for (LehrerLehramtAnerkennung l : LehrerLehramtAnerkennung.values()) {
                _anerkennungenByID.put(l.daten.id, l);
            }
        }
        return _anerkennungenByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerLehramtAnerkennung> getMapAnerkennungenByKuerzel() {
        if (_anerkennungenByKuerzel.size() == 0) {
            for (LehrerLehramtAnerkennung l : LehrerLehramtAnerkennung.values()) {
                _anerkennungenByKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _anerkennungenByKuerzel;
    }

    public static LehrerLehramtAnerkennung getByID(long id) {
        return LehrerLehramtAnerkennung.getMapAnerkennungenByID().get(id);
    }

    public static LehrerLehramtAnerkennung getByKuerzel(String kuerzel) {
        return LehrerLehramtAnerkennung.getMapAnerkennungenByKuerzel().get(kuerzel);
    }

    static {
        _anerkennungenByID = new HashMap();
        _anerkennungenByKuerzel = new HashMap();
    }
}

