/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogLeitungsfunktionenEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerLeitungsfunktion {
    SL(new LehrerKatalogLeitungsfunktionenEintrag[]{new LehrerKatalogLeitungsfunktionenEintrag(1L, "SL", "Schulleitung", null, null)}),
    SL_STV(new LehrerKatalogLeitungsfunktionenEintrag[]{new LehrerKatalogLeitungsfunktionenEintrag(2L, "Stv. SL", "Stellvertretende Schulleitung", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogLeitungsfunktionenEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogLeitungsfunktionenEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerLeitungsfunktion> _mapByKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerLeitungsfunktion> _mapByID;

    private LehrerLeitungsfunktion(LehrerKatalogLeitungsfunktionenEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerLeitungsfunktion> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (LehrerLeitungsfunktion s : LehrerLeitungsfunktion.values()) {
                if (s.daten == null) continue;
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerLeitungsfunktion> getMapByID() {
        if (_mapByID.size() == 0) {
            for (LehrerLeitungsfunktion s : LehrerLeitungsfunktion.values()) {
                if (s.daten == null) continue;
                _mapByID.put(s.daten.id, s);
            }
        }
        return _mapByID;
    }

    public static LehrerLeitungsfunktion getByKuerzel(String kuerzel) {
        return LehrerLeitungsfunktion.getMapByKuerzel().get(kuerzel);
    }

    public static LehrerLeitungsfunktion getByID(long id) {
        return LehrerLeitungsfunktion.getMapByID().get(id);
    }

    static {
        _mapByKuerzel = new HashMap();
        _mapByID = new HashMap();
    }
}

