/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogMehrleistungsartEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerMehrleistungArt {
    ID_100(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(1L, "100", "Besch\u00e4ftigungsphase Sabbatjahr", null, null)}),
    ID_110(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(2L, "110", "Mehrarbeit (angeordnet und regelm\u00e4\u00dfig)", null, null)}),
    ID_150(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(3L, "150", "Aufrundung der Pflichtstundenzahl wegen Abrundung im folgenden Schuljahr ", null, null)}),
    ID_160(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(4L, "160", "\u00dcberschreitung der Pflichtstundenzahl aus organisatorischen Gr\u00fcnden (z. B. Epochenunterricht)", null, null)}),
    ID_165(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(6L, "165", "\u00dcberschreitung der Pflichtstundenzahl wegen COVID-19", null, null)}),
    ID_170(new LehrerKatalogMehrleistungsartEintrag[]{new LehrerKatalogMehrleistungsartEintrag(5L, "170", "\u00dcberschreitung der Pflichtstundenzahl wegen Pflichstunden-Bandbreite", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogMehrleistungsartEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogMehrleistungsartEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerMehrleistungArt> _artenByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerMehrleistungArt> _artenByKuerzel;

    private LehrerMehrleistungArt(LehrerKatalogMehrleistungsartEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerMehrleistungArt> getMapArtenByID() {
        if (_artenByID.size() == 0) {
            for (LehrerMehrleistungArt g : LehrerMehrleistungArt.values()) {
                _artenByID.put(g.daten.id, g);
            }
        }
        return _artenByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerMehrleistungArt> getMapArtenByKuerzel() {
        if (_artenByKuerzel.size() == 0) {
            for (LehrerMehrleistungArt g : LehrerMehrleistungArt.values()) {
                _artenByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _artenByKuerzel;
    }

    public static LehrerMehrleistungArt getByID(long id) {
        return LehrerMehrleistungArt.getMapArtenByID().get(id);
    }

    public static LehrerMehrleistungArt getByKuerzel(String kuerzel) {
        return LehrerMehrleistungArt.getMapArtenByKuerzel().get(kuerzel);
    }

    static {
        _artenByID = new HashMap();
        _artenByKuerzel = new HashMap();
    }
}

