/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogRechtsverhaeltnisEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum LehrerRechtsverhaeltnis {
    L(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(3L, "L", "Beamter auf Lebenszeit", null, null)}),
    P(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(2L, "P", "Beamter auf Probe", null, null)}),
    A(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(1L, "A", "Beamter auf Probe zur Anstellung", null, null)}),
    N(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(7L, "N", "Beamter, nebenamtlich (nicht hauptamtlich im Schuldienst)", null, null)}),
    W(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(9L, "W", "Beamter auf Widerruf (LAA)", null, null)}),
    U(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(4L, "U", "Angestellte, unbefristet (BAT-Vertrag)", null, null)}),
    B(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(5L, "B", "Angestellte, befristet (BAT-Vertrag)", null, null)}),
    J(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(6L, "J", "Angestellte, nicht BAT-Vertrag", null, null)}),
    S(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(8L, "S", "Gestellungsvertrag", null, null)}),
    X(new LehrerKatalogRechtsverhaeltnisEintrag[]{new LehrerKatalogRechtsverhaeltnisEintrag(10L, "X", "Unentgeltlich Besch\u00e4ftigte", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogRechtsverhaeltnisEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogRechtsverhaeltnisEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, LehrerRechtsverhaeltnis> _rechtsverhaeltnisByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, LehrerRechtsverhaeltnis> _rechtsverhaeltnisByKuerzel;

    private LehrerRechtsverhaeltnis(LehrerKatalogRechtsverhaeltnisEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, LehrerRechtsverhaeltnis> getMapRechtsverhaeltnisByID() {
        if (_rechtsverhaeltnisByID.size() == 0) {
            for (LehrerRechtsverhaeltnis l : LehrerRechtsverhaeltnis.values()) {
                _rechtsverhaeltnisByID.put(l.daten.id, l);
            }
        }
        return _rechtsverhaeltnisByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, LehrerRechtsverhaeltnis> getMapRechtsverhaeltnisByKuerzel() {
        if (_rechtsverhaeltnisByKuerzel.size() == 0) {
            for (LehrerRechtsverhaeltnis l : LehrerRechtsverhaeltnis.values()) {
                _rechtsverhaeltnisByKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _rechtsverhaeltnisByKuerzel;
    }

    public static LehrerRechtsverhaeltnis getByID(long id) {
        return LehrerRechtsverhaeltnis.getMapRechtsverhaeltnisByID().get(id);
    }

    public static LehrerRechtsverhaeltnis getByKuerzel(String kuerzel) {
        return LehrerRechtsverhaeltnis.getMapRechtsverhaeltnisByKuerzel().get(kuerzel);
    }

    static {
        _rechtsverhaeltnisByID = new HashMap();
        _rechtsverhaeltnisByKuerzel = new HashMap();
    }
}

