/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.lehrer;

import de.svws_nrw.core.data.lehrer.LehrerKatalogZugangsgrundEintrag;
import jakarta.validation.constraints.NotNull;

public enum LehrerZugangsgrund {
    NEU(new LehrerKatalogZugangsgrundEintrag[]{new LehrerKatalogZugangsgrundEintrag(1L, "NEU", "Neueintritt in den Schuldienst mit abgelegter 2. Staatspr\u00fcfung oder anderweitig erf\u00fcllter Eingangsvoraussetzung", "1", null, null)}),
    AndBuLand(new LehrerKatalogZugangsgrundEintrag[]{new LehrerKatalogZugangsgrundEintrag(2L, "AndBuLand", "\u00dcbertritt aus dem Schuldienst eines anderen Bundeslandes", "2", null, null)}),
    WECHSEL(new LehrerKatalogZugangsgrundEintrag[]{new LehrerKatalogZugangsgrundEintrag(3L, "WECHSEL", "Wechsel innerhalb des Landes von einer anderen Schule an die berichtende Schule", "3", null, null)}),
    WIEDER(new LehrerKatalogZugangsgrundEintrag[]{new LehrerKatalogZugangsgrundEintrag(4L, "WIEDER", "Wiedereintritt in den Schuldienst", "4", null, null)}),
    SONSTIG(new LehrerKatalogZugangsgrundEintrag[]{new LehrerKatalogZugangsgrundEintrag(5L, "SONSTIG", "Sonstige Zug\u00e4nge", "5", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final LehrerKatalogZugangsgrundEintrag daten;
    @NotNull
    public final @NotNull LehrerKatalogZugangsgrundEintrag @NotNull [] historie;

    private LehrerZugangsgrund(LehrerKatalogZugangsgrundEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    public static LehrerZugangsgrund getByID(long id) {
        for (LehrerZugangsgrund grund : LehrerZugangsgrund.values()) {
            if (grund.daten.id != id) continue;
            return grund;
        }
        return null;
    }

    public static LehrerZugangsgrund getByKuerzel(String kuerzel) {
        for (LehrerZugangsgrund grund : LehrerZugangsgrund.values()) {
            if (!grund.daten.kuerzel.equals(kuerzel)) continue;
            return grund;
        }
        return null;
    }

    public static LehrerZugangsgrund getByASDSchluessel(String schluessel) {
        for (LehrerZugangsgrund grund : LehrerZugangsgrund.values()) {
            if (!grund.daten.schluessel.equals(schluessel)) continue;
            return grund;
        }
        return null;
    }
}

