/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schueler;

import de.svws_nrw.core.data.schule.EinschulungsartKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Einschulungsart {
    E51(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(1000L, "51", "\u00e4lter als 6. Jahre", "Kinder, die bis zum g\u00fcltigen Einschulungsstichtag das 6. Lebensjahr vollendet haben", null, null)}),
    E52(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(2000L, "52", "j\u00fcnger als 6 Jahre", "Kinder, die nach dem g\u00fcltigen Einschulungsstichtag das 6. Lebensjahr vollenden", null, null)}),
    E53(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(3000L, "53", "zur\u00fcckgestellt (\u00a735 Abs. 3 SchulG)", "Kinder, die in diesem Schuljahr erstmals gem\u00e4\u00df \u00a735 Abs. 3 SchulG eine Schule besuchen", null, null)}),
    E54(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(4000L, "54", "Fr\u00fcherziehung", "Kinder, die erstmals eine Fr\u00fcherziehung besuchen", null, null)}),
    E18(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(7000L, "18", "vorher: Fr\u00fcherziehung", "Im abgelaufenen Schuljahr: Teilnahme an einer Fr\u00fcherziehung", null, null)}),
    E19(new EinschulungsartKatalogEintrag[]{new EinschulungsartKatalogEintrag(8000L, "19", "vorher: F\u00f6rderschulkindergarten", "Im abgelaufenen Schuljahr: Besuch eines F\u00f6rderschul-(nicht Sonder)kindergarten", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final EinschulungsartKatalogEintrag daten;
    @NotNull
    public final @NotNull EinschulungsartKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Einschulungsart> _ebenen;

    private Einschulungsart(EinschulungsartKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Einschulungsart> getMapByKuerzel() {
        if (_ebenen.size() == 0) {
            for (Einschulungsart s : Einschulungsart.values()) {
                if (s.daten == null) continue;
                _ebenen.put(s.daten.kuerzel, s);
            }
        }
        return _ebenen;
    }

    public static Einschulungsart getByKuerzel(String kuerzel) {
        return Einschulungsart.getMapByKuerzel().get(kuerzel);
    }

    static {
        _ebenen = new HashMap();
    }
}

