/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schueler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.svws_nrw.core.data.schule.FoerderschwerpunktKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum Foerderschwerpunkt {
    KEINER(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(0L, "**", "kein F\u00f6rderschwerpunkt", Arrays.asList(Schulform.BK, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.V, Schulform.WB), null, null)}),
    BL(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(1000L, "BL", "Sehen (Blinde)", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    EZ(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(2000L, "EZ", "Emotionale und soziale Entwicklung", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    GB(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(3000L, "GB", "Geistige Entwicklung", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    GH(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(4000L, "GH", "H\u00f6ren und Kommunikation (Geh\u00f6rlose)", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.SR, Schulform.V), 2011, null)}),
    KB(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(5000L, "KB", "K\u00f6rperliche und motorische Entwicklung", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.SG, Schulform.V), 2011, null)}),
    KR(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(6000L, "KR", "Schule f\u00fcr Kranke", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.S, Schulform.KS), 2011, null)}),
    LB(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(7000L, "LB", "Lernen", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    PE(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(8000L, "PE", "Pr\u00e4ventive F\u00f6rderung im Bereich Emotionale und soziale Entwicklung", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), null, 2010)}),
    PF(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(9000L, "PF", "Pr\u00e4ventive F\u00f6rderung", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), null, 2010)}),
    PL(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(10000L, "PL", "Pr\u00e4ventive F\u00f6rderung im Bereich Lernen", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), null, 2010)}),
    PS(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(11000L, "PS", "Pr\u00e4ventive F\u00f6rderung im Bereich Sprache", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), null, 2010)}),
    SB(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(12000L, "SB", "Sprache", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    SG(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(13000L, "SG", "H\u00f6ren und Kommunikation (Schwerh\u00f6rige)", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.SR, Schulform.V), 2011, null)}),
    SH(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(14000L, "SH", "Sehen (Sehbehinderte)", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), 2011, null)}),
    XX(new FoerderschwerpunktKatalogEintrag[]{new FoerderschwerpunktKatalogEintrag(15000L, "XX", "Kein F\u00f6rderschwerpunkt", Arrays.asList(Schulform.SB, Schulform.SG), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final FoerderschwerpunktKatalogEintrag daten;
    @NotNull
    public final @NotNull FoerderschwerpunktKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Foerderschwerpunkt> _foerderschwerpunkteKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull Foerderschwerpunkt> _foerderschwerpunkteID;
    @NotNull
    private @NotNull ArrayList<@NotNull Schulform> @NotNull [] schulformen;

    private Foerderschwerpunkt(FoerderschwerpunktKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.schulformen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.schulformen[i] = new ArrayList();
            for (String kuerzel : historie[i].schulformen) {
                Schulform sf = Schulform.getByKuerzel(kuerzel);
                if (sf == null) continue;
                this.schulformen[i].add(sf);
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Foerderschwerpunkt> getMapFoerderschwerpunktByKuerzel() {
        if (_foerderschwerpunkteKuerzel.size() == 0) {
            for (Foerderschwerpunkt s : Foerderschwerpunkt.values()) {
                _foerderschwerpunkteKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _foerderschwerpunkteKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull Foerderschwerpunkt> getMapFoerderschwerpunktByID() {
        if (_foerderschwerpunkteID.size() == 0) {
            for (Foerderschwerpunkt s : Foerderschwerpunkt.values()) {
                for (FoerderschwerpunktKatalogEintrag k : s.historie) {
                    _foerderschwerpunkteID.put(k.id, s);
                }
            }
        }
        return _foerderschwerpunkteID;
    }

    public static Foerderschwerpunkt getByKuerzel(String kuerzel) {
        return Foerderschwerpunkt.getMapFoerderschwerpunktByKuerzel().get(kuerzel);
    }

    public static Foerderschwerpunkt getByID(Long id) {
        return Foerderschwerpunkt.getMapFoerderschwerpunktByID().get(id);
    }

    @JsonIgnore
    @NotNull
    public @NotNull List<@NotNull Schulform> getSchulformen() {
        return this.schulformen[this.historie.length - 1];
    }

    @NotNull
    public static @NotNull List<@NotNull Foerderschwerpunkt> get(Schulform schulform) {
        @NotNull ArrayList<@NotNull Foerderschwerpunkt> result = new ArrayList<Foerderschwerpunkt>();
        if (schulform == null) {
            return result;
        }
        @NotNull Foerderschwerpunkt @NotNull [] fs = Foerderschwerpunkt.values();
        for (int i = 0; i < fs.length; ++i) {
            Foerderschwerpunkt gliederung = fs[i];
            if (!gliederung.hasSchulform(schulform)) continue;
            result.add(gliederung);
        }
        return result;
    }

    @JsonIgnore
    public boolean hasSchulformByKuerzel(String kuerzel) {
        if (kuerzel == null || "".equals(kuerzel)) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    public static Foerderschwerpunkt getBySchulformAndKuerzel(Schulform sf, String kuerzel) {
        if (sf == null) {
            return null;
        }
        if (kuerzel == null || "".equals(kuerzel)) {
            return KEINER;
        }
        @NotNull List<@NotNull Foerderschwerpunkt> schwerpunkte = Foerderschwerpunkt.get(sf);
        for (int i = 0; i < schwerpunkte.size(); ++i) {
            Foerderschwerpunkt fs = schwerpunkte.get(i);
            if (!fs.daten.kuerzel.equalsIgnoreCase(kuerzel)) continue;
            return fs;
        }
        return null;
    }

    static {
        _foerderschwerpunkteKuerzel = new HashMap();
        _foerderschwerpunkteID = new HashMap();
    }
}

