/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schueler;

import de.svws_nrw.core.data.schule.HerkunftKatalogEintrag;
import de.svws_nrw.core.types.schueler.HerkunftBildungsgang;
import de.svws_nrw.core.types.schueler.HerkunftBildungsgangsTyp;
import de.svws_nrw.core.types.schueler.HerkunftSchulform;
import de.svws_nrw.core.types.schueler.HerkunftSonstige;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Herkunft {
    BK(HerkunftSchulform.BK),
    FW(HerkunftSchulform.FW),
    G(HerkunftSchulform.G),
    GE(HerkunftSchulform.GE),
    GM(HerkunftSchulform.GM),
    GY(HerkunftSchulform.GY),
    H(HerkunftSchulform.H),
    PS(HerkunftSchulform.PS),
    R(HerkunftSchulform.R),
    S(HerkunftSchulform.S),
    SE(HerkunftSchulform.SK),
    WB(HerkunftSchulform.WB),
    A01(HerkunftBildungsgang.A01),
    A02(HerkunftBildungsgang.A02),
    A03(HerkunftBildungsgang.A03),
    A04(HerkunftBildungsgang.A04),
    A10(HerkunftBildungsgang.A10),
    A11(HerkunftBildungsgang.A11),
    A12(HerkunftBildungsgang.A12),
    A13(HerkunftBildungsgang.A13),
    A14(HerkunftBildungsgang.A14),
    A15(HerkunftBildungsgang.A15),
    A16(HerkunftBildungsgang.A16),
    B01(HerkunftBildungsgang.B01),
    B02(HerkunftBildungsgang.B02),
    B04(HerkunftBildungsgang.B04),
    B05(HerkunftBildungsgang.B05),
    B06(HerkunftBildungsgang.B06),
    B07(HerkunftBildungsgang.B07),
    B08(HerkunftBildungsgang.B08),
    B09(HerkunftBildungsgang.B09),
    B10(HerkunftBildungsgang.B10),
    C01(HerkunftBildungsgang.C01),
    C02(HerkunftBildungsgang.C02),
    C03(HerkunftBildungsgang.C03),
    C05(HerkunftBildungsgang.C05),
    C06(HerkunftBildungsgang.C06),
    C07(HerkunftBildungsgang.C07),
    C08(HerkunftBildungsgang.C08),
    C11(HerkunftBildungsgang.C11),
    C12(HerkunftBildungsgang.C12),
    C13(HerkunftBildungsgang.C13),
    D01(HerkunftBildungsgang.D01),
    D02(HerkunftBildungsgang.D02),
    D05(HerkunftBildungsgang.D05),
    D06(HerkunftBildungsgang.D06),
    E01(HerkunftBildungsgang.E01),
    E02(HerkunftBildungsgang.E02),
    E03(HerkunftBildungsgang.E03),
    E04(HerkunftBildungsgang.E04),
    E05(HerkunftBildungsgang.E05),
    E07(HerkunftBildungsgang.E07),
    E13(HerkunftBildungsgang.E13),
    AG(HerkunftBildungsgangsTyp.AG),
    AR(HerkunftBildungsgangsTyp.AR),
    KL(HerkunftBildungsgangsTyp.KL),
    BF(HerkunftBildungsgangsTyp.BF),
    BS(HerkunftBildungsgangsTyp.BS),
    BY(HerkunftBildungsgangsTyp.BY),
    FO(HerkunftBildungsgangsTyp.FO),
    FS(HerkunftBildungsgangsTyp.FS),
    AS(HerkunftSonstige.AS),
    ES(HerkunftSonstige.ES),
    FE(HerkunftSonstige.FE),
    HU(HerkunftSonstige.HU),
    SK(HerkunftSonstige.SK),
    UN(HerkunftSonstige.UN),
    WZ(HerkunftSonstige.WZ),
    XB(HerkunftSonstige.XB),
    XS(HerkunftSonstige.XS);

    public static final long VERSION = 2L;
    @NotNull
    public final HerkunftKatalogEintrag daten;
    @NotNull
    public final @NotNull HerkunftKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Herkunft> _kuerzel;

    private Herkunft(HerkunftSonstige h) {
        this.historie = new HerkunftKatalogEintrag[h.historie.length];
        for (int i = 0; i < h.historie.length; ++i) {
            this.historie[i] = new HerkunftKatalogEintrag(h.historie[i].id + 1000000000L, h.historie[i].kuerzel, h.historie[i].schulformen, h.historie[i].beschreibung, h.historie[i].gueltigVon, h.historie[i].gueltigBis);
        }
        this.daten = this.historie[this.historie.length - 1];
    }

    private Herkunft(HerkunftBildungsgang h) {
        this.historie = new HerkunftKatalogEintrag[h.historie.length];
        for (int i = 0; i < h.historie.length; ++i) {
            this.historie[i] = new HerkunftKatalogEintrag(h.historie[i].id + 2000000000L, h.historie[i].kuerzel, h.historie[i].schulformen, h.historie[i].beschreibung, h.historie[i].gueltigVon, h.historie[i].gueltigBis);
        }
        this.daten = this.historie[this.historie.length - 1];
    }

    private Herkunft(HerkunftBildungsgangsTyp h) {
        this.historie = new HerkunftKatalogEintrag[h.historie.length];
        for (int i = 0; i < h.historie.length; ++i) {
            this.historie[i] = new HerkunftKatalogEintrag(h.historie[i].id + 3000000000L, h.historie[i].kuerzel, h.historie[i].schulformen, h.historie[i].beschreibung, h.historie[i].gueltigVon, h.historie[i].gueltigBis);
        }
        this.daten = this.historie[this.historie.length - 1];
    }

    private Herkunft(HerkunftSchulform h) {
        this.historie = new HerkunftKatalogEintrag[h.historie.length];
        for (int i = 0; i < h.historie.length; ++i) {
            this.historie[i] = new HerkunftKatalogEintrag(h.historie[i].id + 4000000000L, h.historie[i].kuerzelStatistik, h.historie[i].schulformen, h.historie[i].beschreibung, h.historie[i].gueltigVon, h.historie[i].gueltigBis);
        }
        this.daten = this.historie[this.historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Herkunft> getMapByKuerzel() {
        if (_kuerzel.size() == 0) {
            for (Herkunft h : Herkunft.values()) {
                if (h.daten == null) continue;
                _kuerzel.put(h.daten.kuerzel, h);
            }
        }
        return _kuerzel;
    }

    public static Herkunft getByKuerzel(String kuerzel) {
        return Herkunft.getMapByKuerzel().get(kuerzel);
    }

    static {
        _kuerzel = new HashMap();
    }
}

