/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schueler;

import de.svws_nrw.core.data.schule.HerkunftSonstigeKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum HerkunftSonstige {
    AS(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(1000L, "AS", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), "Ausl\u00e4ndische Sch\u00fcler, die seit den letzten amtlichen Schuldaten aus dem Ausland zugezogen sind", null, 2022), new HerkunftSonstigeKatalogEintrag(1001L, "AS", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), "Ausl\u00e4ndische Sch\u00fcler, die seit den letzten amtlichen Schuldaten aus dem Ausland zugezogen sind", 2023, null)}),
    ES(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(2000L, "ES", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.PS, Schulform.KS, Schulform.S, Schulform.V), "Keine Schule bzw. kein F\u00f6rderschulkindergarten (Einschulung)", null, null)}),
    FE(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(3000L, "FE", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.KS, Schulform.S), "Hausfr\u00fcherziehung f\u00fcr H\u00f6r- bzw. Sehgesch\u00e4digte", null, null)}),
    HU(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(4000L, "HU", Arrays.asList(Schulform.BK, Schulform.SB), "Hochschule, Universit\u00e4t", null, null)}),
    SK(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(5000L, "SK", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.PS, Schulform.KS, Schulform.S, Schulform.V), "F\u00f6rderschulkindergarten (einschlie\u00dflich fr\u00fchkindliche F\u00f6rderung)", null, null)}),
    UN(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(6000L, "UN", Arrays.asList(Schulform.BK, Schulform.SB), "Herkunft noch unbekannt (nur Gliederung A12, A13)", null, null)}),
    WZ(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(8000L, "WZ", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB), "Wehr-, Zivil- oder Bundesfreiwilligendienst", null, null)}),
    XB(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(9000L, "XB", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB), "Berufst\u00e4tigkeit (z. B. vor Besuch einer Fachschule)", null, null)}),
    XS(new HerkunftSonstigeKatalogEintrag[]{new HerkunftSonstigeKatalogEintrag(10000L, "XS", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), "Sonstige Schule bzw. keine Schule, auch seit den letzten amtlichen Schuldaten aus dem Ausland zugezogene deutsche Sch\u00fcler", null, 2022), new HerkunftSonstigeKatalogEintrag(10001L, "XS", Arrays.asList(Schulform.BK, Schulform.SB, Schulform.WB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), "Sonstige Schule bzw. keine Schule, auch seit den letzten amtlichen Schuldaten aus dem Ausland zugezogene deutsche Sch\u00fcler", 2023, null)});

    public static final long VERSION = 2L;
    @NotNull
    public final HerkunftSonstigeKatalogEintrag daten;
    @NotNull
    public final @NotNull HerkunftSonstigeKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, HerkunftSonstige> _ebenen;

    private HerkunftSonstige(HerkunftSonstigeKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, HerkunftSonstige> getMapByKuerzel() {
        if (_ebenen.size() == 0) {
            for (HerkunftSonstige s : HerkunftSonstige.values()) {
                if (s.daten == null) continue;
                _ebenen.put(s.daten.kuerzel, s);
            }
        }
        return _ebenen;
    }

    public static HerkunftSonstige getByKuerzel(String kuerzel) {
        return HerkunftSonstige.getMapByKuerzel().get(kuerzel);
    }

    static {
        _ebenen = new HashMap();
    }
}

