/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schueler;

import de.svws_nrw.core.data.schueler.UebergangsempfehlungKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Uebergangsempfehlung {
    HAUPTSCHULE(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(1L, "H", "Hauptschule", Schulform.H, null, null, null)}),
    HAUPTSCHULE_REALSCHULE(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(5L, "H/R", "Hauptschule / Realschule (eingeschr\u00e4nkt)", Schulform.H, Schulform.R, null, null)}),
    REALSCHULE(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(2L, "R", "Realschule", Schulform.R, null, null, null)}),
    REALSCHULE_GYMNASIUM(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(6L, "R/GY", "Realschule / Gymnasium (eingeschr\u00e4nkt)", Schulform.R, Schulform.GY, null, null)}),
    GYMNASIUM(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(3L, "GY", "Gymnasium", Schulform.GY, null, null, null)}),
    KEINE(new UebergangsempfehlungKatalogEintrag[]{new UebergangsempfehlungKatalogEintrag(4L, "OHNE", "Keine Empfehlung", null, null, null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final UebergangsempfehlungKatalogEintrag daten;
    @NotNull
    public final @NotNull UebergangsempfehlungKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Uebergangsempfehlung> _mapKuerzel;

    private Uebergangsempfehlung(UebergangsempfehlungKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Uebergangsempfehlung> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (Uebergangsempfehlung s : Uebergangsempfehlung.values()) {
                if (s.daten == null) continue;
                _mapKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapKuerzel;
    }

    public static Uebergangsempfehlung getByKuerzel(String kuerzel) {
        return Uebergangsempfehlung.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapKuerzel = new HashMap();
    }
}

