/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.AllgemeineMerkmaleKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum AllgemeineMerkmale {
    GANZTAG(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(100000L, "GANZTAG", "Ganztagsschule", true, true, null, Arrays.asList(Schulform.H, Schulform.V, Schulform.R, Schulform.GY, Schulform.GE, Schulform.KS, Schulform.S, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G), null, null)}),
    GANZTAG_OFFEN(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(200000L, "OFFGANZ", "Offene Ganztagsschule", true, true, null, Arrays.asList(Schulform.KS, Schulform.S, Schulform.G, Schulform.V, Schulform.FW, Schulform.HI, Schulform.WF), null, null)}),
    UEBERMITTAGSBETREUUNG(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(250000L, "\u00dcMI", "\u00dcbermittagsbetreuung", true, true, null, Arrays.asList(Schulform.G, Schulform.KS, Schulform.S), 2012, 2017), new AllgemeineMerkmaleKatalogEintrag(250001L, "\u00dcMI", "\u00dcbermittagsbetreuung", true, true, null, Arrays.asList(Schulform.G, Schulform.KS, Schulform.S, Schulform.H, Schulform.R), 2018, null)}),
    SELBSTAENDIGE_SCHULE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(300000L, "SELBST", "Selbstst\u00e4ndige Schule", true, false, null, Arrays.asList(Schulform.H, Schulform.R, Schulform.KS, Schulform.S, Schulform.GE, Schulform.GY, Schulform.WB, Schulform.BK, Schulform.SB, Schulform.G, Schulform.V), null, null)}),
    VERBUNDSCHULE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(350000L, "VERBUND", "Verbundschule", true, false, null, Arrays.asList(Schulform.GY, Schulform.GE, Schulform.R, Schulform.H, Schulform.G), null, null)}),
    BUS(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(400000L, "BUS", "BUS-Projekt", true, true, null, Arrays.asList(Schulform.GE, Schulform.KS, Schulform.S, Schulform.H, Schulform.V), null, null)}),
    VON_8_BIS_1(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(500000L, "8BIS1", "Schule von 8 bis 1", true, true, null, Arrays.asList(Schulform.KS, Schulform.S, Schulform.G), null, null)}),
    VON_8_BIS_1_ANDERE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(550000L, "8BIS1AS", "Schule von 8 bis 1 an anderer Schule", true, true, null, Arrays.asList(Schulform.KS, Schulform.S, Schulform.G, Schulform.V), null, null)}),
    DREIZEHN_PLUS(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(600000L, "13+", "13+", true, true, null, Arrays.asList(Schulform.H, Schulform.KS, Schulform.S, Schulform.GY, Schulform.R, Schulform.G, Schulform.GE, Schulform.V), null, null)}),
    DREIZEHN_PLUS_ANDERE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(650000L, "13+AS", "13+ an anderer Schule", true, true, null, Arrays.asList(Schulform.H, Schulform.KS, Schulform.S, Schulform.GY, Schulform.R, Schulform.G, Schulform.GE, Schulform.V), null, null)}),
    JVA(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(700000L, "JVA", "JVA-Sch\u00fcler", true, true, null, Arrays.asList(Schulform.BK), null, null)}),
    REFORMPAEDAGOGIK(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(800000L, "RefP\u00e4d", "Reformp\u00e4dagogik", true, false, null, Arrays.asList(Schulform.KS, Schulform.S, Schulform.H, Schulform.R, Schulform.GE, Schulform.GY, Schulform.G, Schulform.V), null, null)}),
    BEGEGNUNG_MIT_SPRACHEN_F(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1410000L, "BegSprF", "Begegnung mit Sprachen -Franz\u00f6sisch-", true, true, "F", Arrays.asList(Schulform.KS, Schulform.S, Schulform.G), null, null)}),
    BEGEGNUNG_MIT_SPRACHEN_I(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1420000L, "BegSprI", "Begegnung mit Sprachen -Italienisch-", true, true, "I", Arrays.asList(Schulform.KS, Schulform.S, Schulform.G, Schulform.V), null, null)}),
    BEGEGNUNG_MIT_SPRACHEN_T(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1430000L, "BegSprT", "Begegnung mit Sprachen -T\u00fcrkisch-", true, true, "T", Arrays.asList(Schulform.KS, Schulform.S, Schulform.G, Schulform.V), null, null)}),
    BEGEGNUNG_MIT_SPRACHEN_N(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1440000L, "BegSprN", "Begegnung mit Sprachen -Niederl\u00e4ndisch-", true, true, "N", Arrays.asList(Schulform.KS, Schulform.S, Schulform.G, Schulform.V), null, null)}),
    BEGEGNUNG_MIT_SPRACHEN_SONSTIGE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1450000L, "BegSprSon", "Begegnung mit Sprachen -Sonstige Fremdsprache-", true, true, "X", Arrays.asList(Schulform.KS, Schulform.S, Schulform.G), null, null)}),
    ARBEITSSPRACHE_GOST_E(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1700000L, "ArbSprE", "Arbeitssprache in der gym. Oberstufe -Englisch-", true, true, null, Arrays.asList(Schulform.GE, Schulform.GY), null, null)}),
    ARBEITSSPRACHE_GOST_F(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1710000L, "ArbSprF", "Arbeitssprache in der gym. Oberstufe -Franz\u00f6sisch-", true, true, null, Arrays.asList(Schulform.GE, Schulform.GY), null, null)}),
    ARBEITSSPRACHE_GOST_SONSTIGE(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(1720000L, "ArbSprSon", "Arbeitssprache in der gym. Oberstufe -Sonstige Sprache-", true, true, null, Arrays.asList(Schulform.GE, Schulform.GY, Schulform.V), null, null)}),
    INTERNAT(new AllgemeineMerkmaleKatalogEintrag[]{new AllgemeineMerkmaleKatalogEintrag(2000000L, "INTERNAT", "Internat", true, true, null, Arrays.asList(Schulform.H, Schulform.V, Schulform.R, Schulform.GY, Schulform.GE, Schulform.KS, Schulform.S, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.BK, Schulform.SB, Schulform.SR, Schulform.SG), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final AllgemeineMerkmaleKatalogEintrag daten;
    @NotNull
    public final @NotNull AllgemeineMerkmaleKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, AllgemeineMerkmale> _mapByKuerzel;

    private AllgemeineMerkmale(AllgemeineMerkmaleKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, AllgemeineMerkmale> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (AllgemeineMerkmale s : AllgemeineMerkmale.values()) {
                if (s.daten == null) continue;
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    public static AllgemeineMerkmale getByKuerzel(String kuerzel) {
        return AllgemeineMerkmale.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapByKuerzel = new HashMap();
    }
}

