/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.BerufskollegAnlageKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum BerufskollegAnlage {
    A(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(1000L, "A", "Fachklassen duales System und Ausbildungsvorbereitung", null, null)}),
    B(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(2000L, "B", "Berufsfachschule", null, null)}),
    C(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(3000L, "C", "Berufsfachschule und Fachoberschule", null, null)}),
    D(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(4000L, "D", "Berufliches Gymnasium und Fachoberschule", null, null)}),
    E(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(5000L, "E", "Fachschule", null, null)}),
    H(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(6000L, "H", "Bildungsg\u00e4nge an freien Waldorfschulen / Hiberniakolleg", null, null)}),
    X(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(24000L, "X", "Ehemalige Kollegschule", null, null)}),
    Z(new BerufskollegAnlageKatalogEintrag[]{new BerufskollegAnlageKatalogEintrag(26000L, "Z", "Kooperationsklasse Hauptschule", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final BerufskollegAnlageKatalogEintrag daten;
    @NotNull
    public final @NotNull BerufskollegAnlageKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull BerufskollegAnlage> _anlagen;

    private BerufskollegAnlage(BerufskollegAnlageKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull BerufskollegAnlage> getMapAnlageByKuerzel() {
        if (_anlagen.size() == 0) {
            for (BerufskollegAnlage s : BerufskollegAnlage.values()) {
                if (s.daten == null) continue;
                _anlagen.put(s.daten.kuerzel, s);
            }
        }
        return _anlagen;
    }

    public static BerufskollegAnlage getByKuerzel(String kuerzel) {
        return BerufskollegAnlage.getMapAnlageByKuerzel().get(kuerzel);
    }

    static {
        _anlagen = new HashMap();
    }
}

