/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.OrganisationsformKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum BerufskollegOrganisationsformen {
    TEILZEIT(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1001000L, "T", "Teilzeitunterricht (au\u00dferhalb der TZ-Berufsschule)", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    TEILZEIT_NORMALKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1002000L, "A", "Teilzeitunterricht ohne Blockunterricht (Normalklasse) TZ-Berufsschule", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    TEILZEIT_BEZIRKSFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1003000L, "C", "Teilzeitunterricht ohne Blockunterricht (Bezirksfachklasse) TZ-Berufsschule", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    TEILZEIT_LANDESFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1004000L, "I", "Teilzeitunterricht ohne Blockunterricht (Landesfachklasse) TZ-Berufsschule", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    VOLLZEIT(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1005000L, "V", "Vollzeitunterricht", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_IM_UNTERRICHT(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1006000L, "B", "Blockunterricht z.Zt. im Unterricht (Normalklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_NICHT_IM_UNTERRICHT(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1007000L, "E", "Blockunterricht z.Zt. nicht im Unterricht (Normalklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_TEILZEIT_IM_UNTERRICHT(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1008000L, "G", "Block- und Teilzeitunterr. z.Zt. im Block- oder TZ-Unterricht (Normalklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_GANZTAG(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1000L, "K", "Ganztagsunterricht (Normalklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_IM_UNTERRICHT_BEZIRKSFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1009000L, "D", "Blockunterricht z.Zt. im Unterricht (Bezirksfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_NICHT_IM_UNTERRICHT_BEZIRKSFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1010000L, "F", "Blockunterricht z.Zt. nicht im Unterricht (Bezirksfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_TEILZEIT_IM_UNTERRICHT_BEZIRKSFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1011000L, "H", "Block- und Teilzeitunterr. z.Zt. im Block- oder TZ-Unterricht (Bezirksfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_GANZTAG_BEZIRKSFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1012000L, "L", "Ganztagsunterricht (Bezirksfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_IM_UNTERRICHT_LANDESFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1013000L, "O", "Blockunterricht z.Zt. im Unterricht (Landesfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_NICHT_IM_UNTERRICHT_LANDESFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1014000L, "P", "Blockunterricht z.Zt. nicht im Unterricht (Landesfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_BLOCK_TEILZEIT_IM_UNTERRICHT_LANDESFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1015000L, "U", "Block- und Teilzeitunterr. z.Zt. im Block- oder TZ-Unterricht (Landesfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)}),
    DUAL_GANZTAG_LANDESFACHKLASSE(new OrganisationsformKatalogEintrag[]{new OrganisationsformKatalogEintrag(1016000L, "M", "Ganztagsunterricht (Landesfachklasse) im dualen System", Arrays.asList(Schulform.BK, Schulform.SB), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final OrganisationsformKatalogEintrag daten;
    @NotNull
    public final @NotNull OrganisationsformKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull BerufskollegOrganisationsformen> _mapKuerzel;

    private BerufskollegOrganisationsformen(OrganisationsformKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull BerufskollegOrganisationsformen> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (BerufskollegOrganisationsformen s : BerufskollegOrganisationsformen.values()) {
                if (s.daten == null) continue;
                _mapKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapKuerzel;
    }

    public static BerufskollegOrganisationsformen getByKuerzel(String kuerzel) {
        return BerufskollegOrganisationsformen.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapKuerzel = new HashMap();
    }
}

