/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.data.schule.HerkunftsschulnummerKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum Herkunftsschulnummern {
    SONSTIGES_AUSLAND(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999000000L, 999000, "Schule aus dem sonstigen Ausland", null, null, null)}),
    SCHLESWIG_HOLSTEIN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999001000L, 999001, "Schule aus Schleswig-Holstein", null, null, null)}),
    HAMBURG(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999002000L, 999002, "Schule aus Hamburg", null, null, null)}),
    NIEDERSACHSEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999003000L, 999003, "Schule aus Niedersachsen", null, null, null)}),
    BREMEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999004000L, 999004, "Schule aus Bremen", null, null, null)}),
    HESSEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999006000L, 999006, "Schule aus Hessen", null, null, null)}),
    RHEINLANDPFALZ(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999007000L, 999007, "Schule aus Rheinland-Pfalz", null, null, null)}),
    BADEN_WUERTTEMBERG(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999008000L, 999008, "Schule aus Baden-W\u00fcrttemberg", null, null, null)}),
    BAYERN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999009000L, 999009, "Schule aus Bayern", null, null, null)}),
    SAARLAND(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999010000L, 999010, "Schule aus dem Saarland", null, null, null)}),
    BERLIN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999011000L, 999011, "Schule aus Berlin", null, null, null)}),
    BRANDENBURG(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999012000L, 999012, "Schule aus Brandenburg", null, null, null)}),
    MECKLENBURG_VORPOMMERN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999013000L, 999013, "Schule aus Mecklenburg-Vorpommern", null, null, null)}),
    SACHSEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999014000L, 999014, "Schule aus Sachsen", null, null, null)}),
    SACHSEN_ANHALT(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999015000L, 999015, "Schule aus Sachsen-Anhalt", null, null, null)}),
    THUERINGEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999016000L, 999016, "Schule aus Th\u00fcringen", null, null, null)}),
    BELGIEN(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(991000000L, 991000, "Schule aus Belgien", null, null, null)}),
    LUXEMBURG(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(992000000L, 992000, "Schule aus Luxemburg", null, null, null)}),
    NIEDERLANDE(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(993000000L, 993000, "Schule aus den Niederlanden", null, null, null)}),
    SONSTIGE(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(980500000L, 980500, "Sonstige/keine Schule", null, null, null)}),
    UNBEKANNT(new HerkunftsschulnummerKatalogEintrag[]{new HerkunftsschulnummerKatalogEintrag(999500000L, 999500, "Herkunft noch unbekannt (nur A12, A13)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.BK, Schulgliederung.A12), new Pair<Schulform, Schulgliederung>(Schulform.BK, Schulgliederung.A13), new Pair<Schulform, Schulgliederung>(Schulform.SB, Schulgliederung.A12), new Pair<Schulform, Schulgliederung>(Schulform.SB, Schulgliederung.A13)), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final HerkunftsschulnummerKatalogEintrag daten;
    @NotNull
    public final @NotNull HerkunftsschulnummerKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, Herkunftsschulnummern> _mapBySchulnummer;

    private Herkunftsschulnummern(HerkunftsschulnummerKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, Herkunftsschulnummern> getMapBySchulnummer() {
        if (_mapBySchulnummer.size() == 0) {
            for (Herkunftsschulnummern s : Herkunftsschulnummern.values()) {
                if (s.daten == null) continue;
                _mapBySchulnummer.put(s.daten.schulnummer, s);
            }
        }
        return _mapBySchulnummer;
    }

    public static Herkunftsschulnummern getByKuerzel(Integer nummer) {
        return Herkunftsschulnummern.getMapBySchulnummer().get(nummer);
    }

    static {
        _mapBySchulnummer = new HashMap();
    }
}

