/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.KindergartenbesuchKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Kindergartenbesuch {
    KEINER(new KindergartenbesuchKatalogEintrag[]{new KindergartenbesuchKatalogEintrag(1L, 0L, "kein Kindergarten", null, null)}),
    MAX_1_JAHR(new KindergartenbesuchKatalogEintrag[]{new KindergartenbesuchKatalogEintrag(2L, 1L, "unter 1 Jahr", null, null)}),
    MAX_2_JAHRE(new KindergartenbesuchKatalogEintrag[]{new KindergartenbesuchKatalogEintrag(3L, 2L, "1 bis unter 2 Jahre", null, null)}),
    MAX_3_JAHRE(new KindergartenbesuchKatalogEintrag[]{new KindergartenbesuchKatalogEintrag(4L, 3L, "2 bis unter 3 Jahre", null, null)}),
    MIN_3_JAHRE(new KindergartenbesuchKatalogEintrag[]{new KindergartenbesuchKatalogEintrag(5L, 4L, "3 Jahre und mehr Jahre", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final KindergartenbesuchKatalogEintrag daten;
    @NotNull
    public final @NotNull KindergartenbesuchKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, Kindergartenbesuch> _mapKuerzel;

    private Kindergartenbesuch(KindergartenbesuchKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, Kindergartenbesuch> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (Kindergartenbesuch s : Kindergartenbesuch.values()) {
                if (s.daten == null) continue;
                _mapKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapKuerzel;
    }

    public static Kindergartenbesuch getByKuerzel(long kuerzel) {
        return Kindergartenbesuch.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapKuerzel = new HashMap();
    }
}

