/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.PruefungsordnungKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Pruefungsordnung {
    APO_BK(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(1000L, "APO-BK", "APO-BK-99", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Berufskollegs (Ausbildungs- und Pr\u00fcfungsordnung Berufskolleg - APO-BK)", 1999, "26", "239-384", "https://recht.nrw.de/lmi/owa/br_gv_show_pdf?p_jahr=1999&p_nr=26", 1999, 2002), new PruefungsordnungKatalogEintrag(1001L, "APO-BK", "APO-BK-03", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Berufskollegs (Ausbildungs- und Pr\u00fcfungsordnung Berufskolleg - APO-BK)", 2003, "32", "357-368", "https://recht.nrw.de/lmi/owa/br_vbl_detail_text?anw_nr=6&vd_id=10290&ver=8&val=10290&sg=0&menu=0&vd_back=N", 2003, 2010), new PruefungsordnungKatalogEintrag(1002L, "APO-BK", "APO-BK-11", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Berufskollegs (Ausbildungs- und Pr\u00fcfungsordnung Berufskolleg - APO-BK)", 2011, "17", "361-376", "https://recht.nrw.de/lmi/owa/br_show_historie?p_id=20405", 2011, 2011), new PruefungsordnungKatalogEintrag(1003L, "APO-BK", "APO-BK-13", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Berufskollegs (Ausbildungs- und Pr\u00fcfungsordnung Berufskolleg - APO-BK)", 2012, "23", "421-438", "https://recht.nrw.de/lmi/owa/br_vbl_detail_text?anw_nr=6&vd_id=13493&ver=8&val=13493&sg=0&menu=0&vd_back=N", 2012, 2014), new PruefungsordnungKatalogEintrag(1004L, "APO-BK", "APO-BK-15", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Berufskollegs (Ausbildungs- und Pr\u00fcfungsordnung Berufskolleg - APO-BK)", 2015, "2", "13-38", "https://bass.schul-welt.de/3129.htm", 2015, null)}),
    APO_GOST(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(2000L, "APO-GOSt", null, "Verordnung \u00fcber den Bildungsgang und die Abiturpr\u00fcfung in der Oberstufe des Gymnasiums (Ausbildungs- und Pr\u00fcfungsordnung gem\u00e4\u00df \u00a726b SchVG \u2013 APO \u2013 OStG)", 1979, "20", "248-259", "https://recht.nrw.de/lmi/owa/br_gv_show_pdf?p_jahr=1979&p_nr=20", 1979, 1998), new PruefungsordnungKatalogEintrag(2001L, "APO-GOSt", "APO-GOSt01", "Verordnung \u00fcber den Bildungsgang und die Abiturpr\u00fcfung in der gymnasialen Oberstufe (APO-GOSt)", 1998, "43", "593-608", "https://bass.schul-welt.de/9607.htm", 1999, 2011), new PruefungsordnungKatalogEintrag(2002L, "APO-GOSt", "APO-GOSt02", "Verordnung \u00fcber den Bildungsgang und die Abiturpr\u00fcfung in der gymnasialen Oberstufe (APO-GOSt)", 1998, "43", "593-608", "https://bass.schul-welt.de/9607.htm", 1999, 2011), new PruefungsordnungKatalogEintrag(2003L, "APO-GOSt", "APO-GOSt(C)10", "Verordnung \u00fcber den Bildungsgang und die Abiturpr\u00fcfung in der gymnasialen Oberstufe (APO-GOSt)", 2009, "8", "177-184", "https://recht.nrw.de/lmi/owa/br_vbl_detail_text?anw_nr=6&vd_id=11319&ver=8&val=11319&sg=0&menu=0&vd_back=N", 2010, 2012), new PruefungsordnungKatalogEintrag(2004L, "APO-GOSt", "APO-GOSt(B)10", "Verordnung \u00fcber den Bildungsgang und die Abiturpr\u00fcfung in der gymnasialen Oberstufe (APO-GOSt)", 2009, "26", "529-538", "https://bass.schul-welt.de/9607.htm", 2010, null)}),
    APO_WBK(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(3000L, "APO-WbK", "APO-WbK-00", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Weiterbildungskollegs (Ausbildungs- und Pr\u00fcfungsordnung Weiterbildungskolleg - APO-WbK)", 2000, "19", "289-308", "https://recht.nrw.de/lmi/owa/br_show_historie?p_id=2661", 2000, 2009), new PruefungsordnungKatalogEintrag(3001L, "APO-WbK", "APO-WBK10", "Verordnung \u00fcber die Ausbildung und Pr\u00fcfung in den Bildungsg\u00e4ngen des Weiterbildungskollegs (Ausbildungs- und Pr\u00fcfungsordnung Weiterbildungskolleg - APO-WbK)", 2010, "8", "143-154", "https://bass.schul-welt.de/3693.htm", 2010, null)}),
    AO_GS(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(4000L, "AO-GS", "AO-GS00", "Verordnung \u00fcber den Bildungsgang in der Grundschule (Ausbildungsordnung gem\u00e4\u00df \u00a726b SchVG - AO-GS)", 1979, "34", "465-467", "https://recht.nrw.de/lmi/owa/br_gv_show_pdf?p_jahr=1979&p_nr=34", 1979, null), new PruefungsordnungKatalogEintrag(4001L, "AO-GS", "AO-GS05", "Verordnung \u00fcber den Bildungsgang in der Grundschule (Ausbildungsordnung Grundschule - AO-GS)", 2005, "16", "251-272", "https://bass.schul-welt.de/6181.htm", 2005, null)}),
    AO_SI(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(5000L, "AO-SI", "AO-SI99", "Verordnung \u00fcber die Ausbildung in der Sekundarstufe I (Ausbildungsordnung Sekundarstufe I - AO-S I)", 1998, "45", "631-648", "https://recht.nrw.de/lmi/owa/br_vbl_detail_text?anw_nr=6&vd_id=2148&ver=8&val=2148&sg=0&menu=1&vd_back=N", 1999, 2004)}),
    APO_SI(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(6000L, "APO-SI", "APO-SI05", "Verordnung \u00fcber die Ausbildung und die Abschlusspr\u00fcfungen in der Sekundarstufe I (Ausbildungs- und Pr\u00fcfungsordnung Sekundarstufe I \u2013 APO-S I)", 2005, "24", "535-566", "https://recht.nrw.de/lmi/owa/br_vbl_detail_text?anw_nr=6&vd_id=3779&vd_back=N546&sg=0&menu=1", 2005, 2012), new PruefungsordnungKatalogEintrag(6001L, "APO-SI", "APO-SI05", "Verordnung \u00fcber die Ausbildung und die Abschlusspr\u00fcfungen in der Sekundarstufe I (Ausbildungs- und Pr\u00fcfungsordnung Sekundarstufe I \u2013 APO-S I)", 2012, "27", "487-506", "https://bass.schul-welt.de/12691.htm", 2013, null)}),
    AOSF(new PruefungsordnungKatalogEintrag[]{new PruefungsordnungKatalogEintrag(8000L, "AOSF", "AOSF-SI05", "Verordnung \u00fcber die sonderp\u00e4dagogische F\u00f6rderung, den Hausunterricht und die Schule f\u00fcr Kranke (Ausbildungsordnung gem\u00e4\u00df \u00a7 52 SchulG - AO-SF)", 2005, "24", "535-566", "https://bass.schul-welt.de/6225.htm", 2005, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final PruefungsordnungKatalogEintrag daten;
    @NotNull
    public final @NotNull PruefungsordnungKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Pruefungsordnung> _verordnungen;

    private Pruefungsordnung(PruefungsordnungKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Pruefungsordnung> getMapPruefungsordnungByKuerzel() {
        if (_verordnungen.size() == 0) {
            for (Pruefungsordnung s : Pruefungsordnung.values()) {
                if (s.daten == null) continue;
                _verordnungen.put(s.daten.kuerzel, s);
            }
        }
        return _verordnungen;
    }

    public static Pruefungsordnung getByKuerzel(String kuerzel) {
        return Pruefungsordnung.getMapPruefungsordnungByKuerzel().get(kuerzel);
    }

    static {
        _verordnungen = new HashMap();
    }
}

