/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.svws_nrw.core.data.schule.ReformpaedagogikKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum Reformpaedagogik {
    KEIN_EINTRAG(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(0L, "*", "ohne Eintrag", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), null, null)}),
    FREINET(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(1000L, "C", "Celestin Freinet", Arrays.asList(Schulform.G, Schulform.GY), null, null)}),
    KORCZAK(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(2000L, "J", "Janusz Korczak (P\u00e4dagogik der Achtung)", Arrays.asList(Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.S, Schulform.KS, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), null, null)}),
    MONTESSORI(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(3000L, "M", "Montessori", Arrays.asList(Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.S, Schulform.KS, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), null, null)}),
    PETERSEN(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(4000L, "P", "Peter Petersen/Jena-Plan", Arrays.asList(Schulform.G, Schulform.GY, Schulform.S, Schulform.KS, Schulform.SG, Schulform.SR), null, null)}),
    SONSTIGE(new ReformpaedagogikKatalogEintrag[]{new ReformpaedagogikKatalogEintrag(5000L, "S", "sonstige", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final ReformpaedagogikKatalogEintrag daten;
    @NotNull
    public final @NotNull ReformpaedagogikKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Reformpaedagogik> _schulgliederungenKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull Reformpaedagogik> _schulgliederungenID;
    @NotNull
    private @NotNull ArrayList<@NotNull Schulform> @NotNull [] schulformen;

    private Reformpaedagogik(ReformpaedagogikKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.schulformen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.schulformen[i] = new ArrayList();
            for (String kuerzel : historie[i].schulformen) {
                Schulform sf = Schulform.getByKuerzel(kuerzel);
                if (sf == null) continue;
                this.schulformen[i].add(sf);
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Reformpaedagogik> getMapSchulgliederungByKuerzel() {
        if (_schulgliederungenKuerzel.size() == 0) {
            for (Reformpaedagogik r : Reformpaedagogik.values()) {
                _schulgliederungenKuerzel.put(r.daten.kuerzel, r);
            }
        }
        return _schulgliederungenKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull Reformpaedagogik> getMapSchulgliederungByID() {
        if (_schulgliederungenID.size() == 0) {
            for (Reformpaedagogik r : Reformpaedagogik.values()) {
                for (ReformpaedagogikKatalogEintrag k : r.historie) {
                    _schulgliederungenID.put(k.id, r);
                }
            }
        }
        return _schulgliederungenID;
    }

    public static Reformpaedagogik getByKuerzel(String kuerzel) {
        if (kuerzel == null || "".equals(kuerzel)) {
            return KEIN_EINTRAG;
        }
        return Reformpaedagogik.getMapSchulgliederungByKuerzel().get(kuerzel);
    }

    public static Reformpaedagogik getByID(Long id) {
        return Reformpaedagogik.getMapSchulgliederungByID().get(id);
    }

    @JsonIgnore
    @NotNull
    public @NotNull List<@NotNull Schulform> getSchulformen() {
        return this.schulformen[this.historie.length - 1];
    }

    @NotNull
    public static @NotNull List<@NotNull Reformpaedagogik> get(Schulform schulform) {
        @NotNull ArrayList<@NotNull Reformpaedagogik> result = new ArrayList<Reformpaedagogik>();
        if (schulform == null) {
            return result;
        }
        @NotNull Reformpaedagogik @NotNull [] gliederungen = Reformpaedagogik.values();
        for (int i = 0; i < gliederungen.length; ++i) {
            Reformpaedagogik gliederung = gliederungen[i];
            if (!gliederung.hasSchulform(schulform)) continue;
            result.add(gliederung);
        }
        return result;
    }

    @JsonIgnore
    public boolean hasSchulformByKuerzel(String kuerzel) {
        if (kuerzel == null || "".equals(kuerzel)) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        _schulgliederungenKuerzel = new HashMap();
        _schulgliederungenID = new HashMap();
    }
}

