/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.ReligionKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Religion {
    AR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(1000L, "AR", "alevitisch", null, null)}),
    ER(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(2000L, "ER", "evangelisch", null, null)}),
    HR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(3000L, "HR", "j\u00fcdisch", null, null)}),
    IR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(4000L, "IR", "islamisch", null, null)}),
    KR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(5000L, "KR", "katholisch", null, null)}),
    ME(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(6000L, "ME", "mennonitische BG NRW", null, null)}),
    OH(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(7000L, "OH", "ohne Bekenntnis", null, null)}),
    OR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(8000L, "OR", "griechisch-orthodox", null, null)}),
    SO(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(9000L, "SO", "syrisch-orthodox", null, null)}),
    XO(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(10000L, "XO", "sonstige orthodoxe", null, null)}),
    XR(new ReligionKatalogEintrag[]{new ReligionKatalogEintrag(11000L, "XR", "andere Religionen", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final ReligionKatalogEintrag daten;
    @NotNull
    public final @NotNull ReligionKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Religion> _mapByKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull ReligionKatalogEintrag> _mapEintragById;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull Religion> _mapById;

    private Religion(ReligionKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Religion> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (Religion s : Religion.values()) {
                if (s.daten == null) continue;
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull Religion> getMapById() {
        if (_mapById.size() == 0) {
            for (Religion s : Religion.values()) {
                for (ReligionKatalogEintrag e : s.historie) {
                    _mapById.put(e.id, s);
                }
            }
        }
        return _mapById;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull ReligionKatalogEintrag> getMapEintragById() {
        if (_mapEintragById.size() == 0) {
            for (Religion s : Religion.values()) {
                for (ReligionKatalogEintrag e : s.historie) {
                    _mapEintragById.put(e.id, e);
                }
            }
        }
        return _mapEintragById;
    }

    public static Religion getByKuerzel(String kuerzel) {
        return Religion.getMapByKuerzel().get(kuerzel);
    }

    public static Religion getByID(long id) {
        return Religion.getMapById().get(id);
    }

    public static ReligionKatalogEintrag getEintragByID(long id) {
        return Religion.getMapEintragById().get(id);
    }

    static {
        _mapByKuerzel = new HashMap();
        _mapEintragById = new HashMap();
        _mapById = new HashMap();
    }
}

