/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.SchulabschlussBerufsbildendKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum SchulabschlussBerufsbildend {
    OA(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(0L, "OA", "Ohne Abschluss", "0", null, null)}),
    VORB(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(100000L, "VORB", "Abschluss der Ausbildungsvorbereitung", "1", null, null)}),
    VERS(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(110000L, "VERS", "Versetzungszeugnis", "1", null, null)}),
    AUFB(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(120000L, "AUFB", "Abschlusszeugnis in Aufbaubildungsg\u00e4ngen", "1", null, null)}),
    BV(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(130000L, "BV", "Abschluss der Berufschulvorbereitung", "1", null, null)}),
    VP(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(140000L, "VP", "Vorpraktikum", "1", null, null)}),
    BP(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(150000L, "BP", "Berufspraktikum", "1", null, null)}),
    BG(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(200000L, "BG", "Abschluss der Berufschulgrundjahres", "2", null, null)}),
    BS(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(300000L, "BS", "Berufschulabschluss", "3", null, null)}),
    BK(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(400000L, "BK", "Berufliche Kenntnisse, F\u00e4higkeiten und Fertigkeiten", "4", null, null)}),
    BAB(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(500000L, "BAB", "Berufsabschluss", "5", null, null)}),
    BW(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(600000L, "BW", "Fachschulabschluss (berufliche Weiterbildung)", "6", null, null)}),
    VBK(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(800000L, "VBK", "Vertiefte berufliche Kenntnisse, F\u00e4higkeiten und Fertigkeiten", "8", null, null)}),
    WECHSEL(new SchulabschlussBerufsbildendKatalogEintrag[]{new SchulabschlussBerufsbildendKatalogEintrag(900000L, "WECHSEL", "Schulwechsler, die im selben Bildungsgang verbleiben", "9", null, null)});

    public static final long VERSION = 2L;
    @NotNull
    public final SchulabschlussBerufsbildendKatalogEintrag daten;
    @NotNull
    public final @NotNull SchulabschlussBerufsbildendKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull SchulabschlussBerufsbildend> _mapByKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull SchulabschlussBerufsbildend> _mapByKuerzelStatistik;

    private SchulabschlussBerufsbildend(SchulabschlussBerufsbildendKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull SchulabschlussBerufsbildend> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (SchulabschlussBerufsbildend s : SchulabschlussBerufsbildend.values()) {
                if (s.daten == null) continue;
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    public static SchulabschlussBerufsbildend getByKuerzel(String kuerzel) {
        return SchulabschlussBerufsbildend.getMapByKuerzel().get(kuerzel);
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull SchulabschlussBerufsbildend> getMapByKuerzelStatistik() {
        if (_mapByKuerzelStatistik.size() == 0) {
            for (SchulabschlussBerufsbildend s : SchulabschlussBerufsbildend.values()) {
                if (s.daten == null) continue;
                _mapByKuerzelStatistik.put(s.daten.kuerzelStatistik, s);
            }
        }
        return _mapByKuerzelStatistik;
    }

    public static SchulabschlussBerufsbildend getByKuerzelStatistik(String kuerzel) {
        return SchulabschlussBerufsbildend.getMapByKuerzelStatistik().get(kuerzel);
    }

    static {
        _mapByKuerzel = new HashMap();
        _mapByKuerzelStatistik = new HashMap();
    }
}

