/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.SchulformKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum Schulform {
    BK(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(1000L, "BK", "30", "Berufskolleg", false, null, null)}),
    FW(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(2000L, "FW", "17", "Freie Waldorfschule", true, null, null)}),
    G(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(3000L, "G", "02", "Grundschule", false, null, null)}),
    GE(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(4000L, "GE", "15", "Gesamtschule", true, null, null)}),
    GM(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(5000L, "GM", "16", "Gemeinschaftsschule", false, null, 2022)}),
    GY(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(6000L, "GY", "20", "Gymnasium", true, null, null)}),
    H(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(7000L, "H", "04", "Hauptschule", false, null, null)}),
    HI(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(8000L, "HI", "18", "Hibernia", false, null, null)}),
    PS(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(9000L, "PS", "13", "Schulversuch PRIMUS", false, null, null)}),
    R(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(10000L, "R", "10", "Realschule", false, null, null)}),
    S(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(11000L, "S", "08", "F\u00f6rderschule im Bereich G/H", false, null, null)}),
    KS(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(12000L, "KS", "83", "Klinikschule", false, null, null)}),
    SB(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(13000L, "SB", "88", "F\u00f6rderschule im Bereich Berufskolleg", false, null, null)}),
    SG(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(14000L, "SG", "87", "F\u00f6rderschule im Bereich Gymnasium", true, null, null)}),
    SK(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(15000L, "SK", "14", "Sekundarschule", false, null, null)}),
    SR(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(16000L, "SR", "85", "F\u00f6rderschule im Bereich Realschule", false, null, null)}),
    V(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(17000L, "V", "06", "nicht umorganisierte Volksschule", false, null, null)}),
    WB(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(18000L, "WB", "25", "Weiterbildungskolleg", false, null, null)}),
    WF(new SchulformKatalogEintrag[]{new SchulformKatalogEintrag(19000L, "WF", "19", "Freie Waldorfschule (F\u00f6rderschule)", true, null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final SchulformKatalogEintrag daten;
    @NotNull
    public final @NotNull SchulformKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Schulform> _schulformen;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Schulform> _schulformenNummer;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, SchulformKatalogEintrag> _mapEintragById;

    private Schulform(SchulformKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Schulform> getMapSchulformenByKuerzel() {
        if (_schulformen.size() == 0) {
            for (Schulform s : Schulform.values()) {
                if (s.daten == null) continue;
                _schulformen.put(s.daten.kuerzel, s);
            }
        }
        return _schulformen;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Schulform> getMapSchulformenByNummer() {
        if (_schulformenNummer.size() == 0) {
            for (Schulform s : Schulform.values()) {
                if (s.daten == null || s.daten.nummer == null) continue;
                _schulformenNummer.put(s.daten.nummer, s);
            }
        }
        return _schulformenNummer;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, SchulformKatalogEintrag> getMapEintragById() {
        if (_mapEintragById.size() == 0) {
            for (Schulform s : Schulform.values()) {
                for (SchulformKatalogEintrag e : s.historie) {
                    _mapEintragById.put(e.id, e);
                }
            }
        }
        return _mapEintragById;
    }

    public static Schulform getByKuerzel(String kuerzel) {
        return Schulform.getMapSchulformenByKuerzel().get(kuerzel);
    }

    public static Schulform getByNummer(String nummer) {
        return Schulform.getMapSchulformenByNummer().get(nummer);
    }

    public static SchulformKatalogEintrag getEintragByID(long id) {
        return Schulform.getMapEintragById().get(id);
    }

    @NotNull
    public static @NotNull List<@NotNull Schulform> get() {
        @NotNull ArrayList<@NotNull Schulform> result = new ArrayList<Schulform>();
        for (Schulform sf : Schulform.values()) {
            if (sf.daten == null || sf.daten.nummer == null) continue;
            result.add(sf);
        }
        return result;
    }

    @NotNull
    public static @NotNull List<@NotNull Schulform> getMitGymOb() {
        @NotNull ArrayList<@NotNull Schulform> result = new ArrayList<Schulform>();
        for (Schulform sf : Schulform.values()) {
            if (!sf.daten.hatGymOb) continue;
            result.add(sf);
        }
        return result;
    }

    static {
        _schulformen = new HashMap();
        _schulformenNummer = new HashMap();
        _mapEintragById = new HashMap();
    }
}

