/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.schule;

import de.svws_nrw.core.data.schule.SchulstufeKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum Schulstufe {
    VORSCHULSTUFE(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(0L, "V", "Vorschulstufe", Arrays.asList(Schulform.S, Schulform.KS), null, null)}),
    PRIMARSTUFE(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(1000L, "P", "Primarstufe", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.PS, Schulform.R, Schulform.S, Schulform.KS, Schulform.V), null, null)}),
    SEKUNDARSTUFE_I(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(2000L, "SI", "Sekundarstufe I", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.PS, Schulform.S, Schulform.KS, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.H, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V), null, null)}),
    SEKUNDARSTUFE_II(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(3000L, "SII", "Sekundarstufe II", Arrays.asList(Schulform.FW, Schulform.HI, Schulform.WF, Schulform.GE, Schulform.GM, Schulform.GY, Schulform.PS, Schulform.SG), null, null)}),
    TERTIAERSTUFE(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(4000L, "T", "Terti\u00e4rstufe", Arrays.asList(new Schulform[0]), null, null)}),
    QUARTAERSTUFE(new SchulstufeKatalogEintrag[]{new SchulstufeKatalogEintrag(4000L, "Q", "Quart\u00e4rstufe", Arrays.asList(Schulform.WB), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final SchulstufeKatalogEintrag daten;
    @NotNull
    public final @NotNull SchulstufeKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Schulstufe> _mapByKuerzel;

    private Schulstufe(SchulstufeKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Schulstufe> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (Schulstufe s : Schulstufe.values()) {
                if (s.daten == null) continue;
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    public static Schulstufe getByKuerzel(String kuerzel) {
        return Schulstufe.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapByKuerzel = new HashMap();
    }
}

