/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class AttributMitAuswahl<@NotNull K, @NotNull V> {
    @NotNull
    private final @NotNull List<@NotNull V> _values = new ArrayList<V>();
    @NotNull
    private final @NotNull Map<@NotNull K, @NotNull V> _mapValuesByKey = new HashMap();
    @NotNull
    private final @NotNull Map<@NotNull K, @NotNull V> _mapAuswahlValuesByKey = new HashMap();
    @NotNull
    private final @NotNull Function<@NotNull V, @NotNull K> _toID;
    @NotNull
    private final @NotNull Comparator<@NotNull V> _comparator;
    private final Runnable _eventHandlerAuswahlGeandert;

    public AttributMitAuswahl(@NotNull @NotNull Collection<@NotNull V> values, @NotNull @NotNull Function<@NotNull V, @NotNull K> toId, @NotNull @NotNull Comparator<@NotNull V> comparator, Runnable eventHandler) {
        this._toID = toId;
        this._comparator = comparator;
        this._values.clear();
        this._values.addAll(values);
        this._values.sort(this._comparator);
        this._mapValuesByKey.clear();
        for (V v : this._values) {
            this._mapValuesByKey.put(toId.apply(v), v);
        }
        this._eventHandlerAuswahlGeandert = eventHandler;
    }

    @NotNull
    public @NotNull List<@NotNull V> list() {
        return this._values;
    }

    public int size() {
        return this._values.size();
    }

    public V get(@NotNull K key) {
        return this._mapValuesByKey.get(key);
    }

    @NotNull
    public V getOrException(@NotNull K key) throws DeveloperNotificationException {
        V value = this.get(key);
        if (value == null) {
            throw new DeveloperNotificationException("Kein g\u00fcltiger Schl\u00fcsselwert.");
        }
        return value;
    }

    public boolean has(@NotNull K key) {
        return this._mapValuesByKey.containsKey(key);
    }

    public boolean hasValue(@NotNull V value) {
        return this._mapValuesByKey.containsKey(this._toID.apply(value));
    }

    @NotNull
    public @NotNull List<@NotNull V> auswahl() {
        return new ArrayList<V>(this._mapAuswahlValuesByKey.values());
    }

    @NotNull
    public @NotNull List<@NotNull K> auswahlKeyList() {
        return new ArrayList<K>(this._mapAuswahlValuesByKey.keySet());
    }

    public boolean auswahlExists() {
        return !this._mapAuswahlValuesByKey.isEmpty();
    }

    public int auswahlSize() {
        return this._mapAuswahlValuesByKey.size();
    }

    public boolean auswahlHas(@NotNull V value) {
        if (!this.hasValue(value)) {
            throw new DeveloperNotificationException("Der Wert existiert nicht f\u00fcr dieses Attribut und kann daher nicht f\u00fcr die Auswahl verwendet werden.");
        }
        @NotNull K key = this._toID.apply(value);
        return this._mapAuswahlValuesByKey.containsKey(key);
    }

    public boolean auswahlHasKey(@NotNull K key) {
        if (!this.has(key)) {
            throw new DeveloperNotificationException("Der Schl\u00fcssel existiert nicht f\u00fcr dieses Attribut und kann daher nicht f\u00fcr die Auswahl verwendet werden.");
        }
        return this._mapAuswahlValuesByKey.containsKey(key);
    }

    public void auswahlClear() {
        this._mapAuswahlValuesByKey.clear();
        if (this._eventHandlerAuswahlGeandert != null) {
            this._eventHandlerAuswahlGeandert.run();
        }
    }

    public void auswahlAdd(@NotNull V value) {
        if (!this.hasValue(value)) {
            throw new DeveloperNotificationException("Der Wert existiert nicht f\u00fcr dieses Attribut und kann daher nicht f\u00fcr die Auswahl verwendet werden.");
        }
        this._mapAuswahlValuesByKey.put(this._toID.apply(value), value);
        if (this._eventHandlerAuswahlGeandert != null) {
            this._eventHandlerAuswahlGeandert.run();
        }
    }

    public void auswahlRemove(@NotNull V value) {
        this._mapAuswahlValuesByKey.remove(this._toID.apply(value));
        if (this._eventHandlerAuswahlGeandert != null) {
            this._eventHandlerAuswahlGeandert.run();
        }
    }

    public boolean auswahlToggle(@NotNull V value) {
        @NotNull K key = this._toID.apply(value);
        if (this._mapAuswahlValuesByKey.containsKey(key)) {
            this.auswahlRemove(value);
            return false;
        }
        this.auswahlAdd(value);
        return true;
    }

    public void auswahlAddByKey(@NotNull K key) {
        if (!this.has(key)) {
            throw new DeveloperNotificationException("Der Schl\u00fcssel existiert nicht f\u00fcr dieses Attribut und kann daher nicht f\u00fcr die Auswahl verwendet werden.");
        }
        this._mapAuswahlValuesByKey.put(key, this.getOrException(key));
        if (this._eventHandlerAuswahlGeandert != null) {
            this._eventHandlerAuswahlGeandert.run();
        }
    }

    public void auswahlRemoveByKey(@NotNull K key) {
        this._mapAuswahlValuesByKey.remove(key);
        if (this._eventHandlerAuswahlGeandert != null) {
            this._eventHandlerAuswahlGeandert.run();
        }
    }

    public boolean auswahlToggleByKey(@NotNull K key) {
        if (this._mapAuswahlValuesByKey.containsKey(key)) {
            this.auswahlRemoveByKey(key);
            return false;
        }
        this.auswahlAddByKey(key);
        return true;
    }
}

