/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.utils.AttributMitAuswahl;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public abstract class AuswahlManager<@NotNull TID, @NotNull TAuswahl, @NotNull TDaten> {
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull TID, @NotNull TAuswahl> liste;
    @NotNull
    private final @NotNull Function<@NotNull TAuswahl, @NotNull TID> _listeToId;
    @NotNull
    private final @NotNull Function<@NotNull TDaten, @NotNull TID> _datenToId;
    protected final Schulform _schulform;
    protected List<@NotNull TAuswahl> _filtered = null;
    protected TDaten _daten = null;
    @NotNull
    protected final Runnable _eventHandlerFilterChanged = () -> {
        this.onFilterChanged();
        this._filtered = null;
    };
    @NotNull
    private final Runnable _eventHandlerMehrfachauswahlChanged = () -> this.onMehrfachauswahlChanged();
    @NotNull
    protected @NotNull List<@NotNull Pair<@NotNull String, @NotNull Boolean>> _order;

    protected AuswahlManager(Schulform schulform, @NotNull @NotNull Collection<@NotNull TAuswahl> values, @NotNull @NotNull Comparator<@NotNull TAuswahl> listComparator, @NotNull @NotNull Function<@NotNull TAuswahl, @NotNull TID> listeToId, @NotNull @NotNull Function<@NotNull TDaten, @NotNull TID> datenToId, @NotNull @NotNull List<@NotNull Pair<@NotNull String, @NotNull Boolean>> order) {
        this._schulform = schulform;
        this._order = order;
        this._listeToId = listeToId;
        this._datenToId = datenToId;
        this.liste = new AttributMitAuswahl<TID, TAuswahl>(values, this._listeToId, listComparator, this._eventHandlerMehrfachauswahlChanged);
    }

    @NotNull
    public @NotNull List<@NotNull TAuswahl> filtered() {
        if (this._filtered != null) {
            return this._filtered;
        }
        this._filtered = this.onFilter();
        return this._filtered;
    }

    @NotNull
    protected abstract @NotNull List<@NotNull TAuswahl> onFilter();

    protected void onFilterChanged() {
    }

    protected void onMehrfachauswahlChanged() {
    }

    public void orderSet(@NotNull @NotNull List<@NotNull Pair<@NotNull String, @NotNull Boolean>> order) {
        this._order = order;
        this._filtered = null;
    }

    @NotNull
    public final @NotNull List<@NotNull Pair<@NotNull String, @NotNull Boolean>> orderGet() {
        return new ArrayList<Pair<String, Boolean>>(this._order);
    }

    public void orderUpdate(@NotNull String field, Boolean order) {
        if (order == null) {
            for (int i = 0; i < this._order.size(); ++i) {
                @NotNull Pair<@NotNull String, @NotNull Boolean> eintrag = this._order.get(i);
                if (!((String)eintrag.a).equals(field)) continue;
                this._order.remove(eintrag);
                this._filtered = null;
                return;
            }
            return;
        }
        for (int i = 0; i < this._order.size(); ++i) {
            @NotNull Pair<@NotNull String, @NotNull Boolean> eintrag = this._order.get(i);
            if (!((String)eintrag.a).equals(field)) continue;
            if (eintrag.b == order) {
                return;
            }
            this._order.remove(eintrag);
            eintrag.b = order;
            this._order.add(0, eintrag);
            this._filtered = null;
            return;
        }
        @NotNull Pair<@NotNull String, @NotNull Boolean> eintrag = new Pair<String, Boolean>(field, order);
        this._order.add(0, eintrag);
        this._filtered = null;
    }

    @NotNull
    public Schulform schulform() {
        if (this._schulform == null) {
            throw new DeveloperNotificationException("Der Auswahl-Manager sollte nur mit einer korrekt gesetzten Schulform verwendet werden.");
        }
        return this._schulform;
    }

    public boolean hasDaten() {
        return this._daten != null;
    }

    @NotNull
    public TDaten daten() {
        if (this._daten == null) {
            throw new DeveloperNotificationException("Es exitsiert derzeit keine Auswahl und damit auch keine Daten");
        }
        return this._daten;
    }

    public void setDaten(TDaten daten) throws DeveloperNotificationException {
        if (daten == null) {
            this._daten = null;
            return;
        }
        @NotNull TAuswahl eintrag = this.liste.getOrException(this._datenToId.apply(daten));
        boolean updateEintrag = this.onSetDaten(eintrag, daten);
        this._daten = daten;
        if (updateEintrag) {
            this.orderSet(this.orderGet());
        }
    }

    protected boolean onSetDaten(@NotNull TAuswahl eintrag, @NotNull TDaten daten) {
        return false;
    }

    public TID auswahlID() {
        return this._daten == null ? null : (TID)this._datenToId.apply(this._daten);
    }

    @NotNull
    public TAuswahl auswahl() {
        if (this._daten == null) {
            throw new DeveloperNotificationException("F\u00fcr den Aufruf dieser Methode muss zuvor eine Auswahl vorliegen.");
        }
        return this.liste.getOrException(this._datenToId.apply(this._daten));
    }
}

