/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.data.gost.GostBlockungListeneintrag;
import de.svws_nrw.core.utils.StringUtils;
import jakarta.validation.constraints.NotNull;
import java.util.Comparator;
import java.util.List;

public final class BlockungsUtils {
    @NotNull
    private static final @NotNull Comparator<@NotNull GostBlockungListeneintrag> _compGostBlockungListeneintrag = (a, b) -> {
        String suffixB;
        int sizeB;
        String praefixB;
        @NotNull String @NotNull [] splitA = BlockungsUtils.extractTrailingNumber(a.name.trim());
        @NotNull String @NotNull [] splitB = BlockungsUtils.extractTrailingNumber(b.name.trim());
        @NotNull String praefixA = splitA[0].trim();
        int cmpPrefix = praefixA.compareTo(praefixB = splitB[0].trim());
        if (cmpPrefix != 0) {
            return cmpPrefix;
        }
        int sizeA = splitA[1].length();
        @NotNull String suffixA = sizeA >= (sizeB = splitB[1].length()) ? splitA[1] : StringUtils.fillWithLeadingZeros(splitA[1], sizeB);
        int cmpSuffix = suffixA.compareTo(suffixB = sizeB >= sizeA ? splitB[1] : StringUtils.fillWithLeadingZeros(splitB[1], sizeA));
        if (cmpSuffix != 0) {
            return cmpSuffix;
        }
        return Long.compare(a.id, b.id);
    };

    private BlockungsUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static void sortGostBlockungListeneintrag(@NotNull @NotNull List<@NotNull GostBlockungListeneintrag> list) {
        list.sort(_compGostBlockungListeneintrag);
    }

    @NotNull
    private static @NotNull String @NotNull [] extractTrailingNumber(@NotNull String s) {
        String prefix = s.replaceAll("\\d*$", "");
        String suffix = s.substring(prefix.length());
        return new String[]{prefix, suffix};
    }

    public static int minVI(int value1, Integer value2orNull) {
        if (value2orNull == null) {
            return value1;
        }
        int value2 = value2orNull;
        return value1 <= value2 ? value1 : value2;
    }

    public static int maxVI(int value1, Integer value2orNull) {
        if (value2orNull == null) {
            return value1;
        }
        int value2 = value2orNull;
        return value1 >= value2 ? value1 : value2;
    }

    public static Integer minII(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a <= b ? a : b;
    }

    public static Integer maxII(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a >= b ? a : b;
    }
}

