/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    @NotNull
    public static <K, V> @NotNull Set<@NotNull V> getOrCreateHashSet(@NotNull @NotNull Map<@NotNull K, @NotNull Set<@NotNull V>> map, @NotNull K key) {
        Set<@NotNull V> set = map.get(key);
        if (set != null) {
            return set;
        }
        @NotNull HashSet<@NotNull E> setNeu = new HashSet();
        map.put(key, setNeu);
        return setNeu;
    }

    @NotNull
    public static <E> @NotNull Set<@NotNull E> toFilteredHashSet(@NotNull @NotNull Collection<@NotNull E> values, @NotNull @NotNull Predicate<@NotNull E> predicate) {
        @NotNull HashSet<@NotNull E> set = new HashSet<E>();
        for (E e : values) {
            if (!predicate.test(e)) continue;
            set.add(e);
        }
        return set;
    }

    @NotNull
    public static <E> @NotNull List<@NotNull E> toFilteredArrayList(@NotNull @NotNull Collection<@NotNull E> values, @NotNull @NotNull Predicate<@NotNull E> predicate) {
        @NotNull ArrayList<@NotNull E> set = new ArrayList<E>();
        for (E e : values) {
            if (!predicate.test(e)) continue;
            set.add(e);
        }
        return set;
    }
}

