/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.utils.StringUtils;
import jakarta.validation.constraints.NotNull;

public final class DateUtils {
    public static final int MIN_GUELTIGES_JAHR = 1900;
    public static final int MAX_GUELTIGES_JAHR = 2900;
    @NotNull
    private static final @NotNull int @NotNull [][] monat_zu_vergangene_tage = new int[][]{{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334}, {0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335}};

    private DateUtils() {
    }

    @NotNull
    public static int[] extractFromDateISO8601(@NotNull String datumISO8601) {
        @NotNull String[] split = datumISO8601.split("-");
        DeveloperNotificationException.ifTrue("Datumsformat von " + datumISO8601 + " ist nicht ISO8601 konform!", split.length != 3);
        int jahr = DeveloperNotificationException.ifNotInt(split[0]);
        DeveloperNotificationException.ifTrue("Das Jahr von " + datumISO8601 + " ist ung\u00fcltig!", DateUtils.gibIstJahrUngueltig(jahr));
        int monat = DeveloperNotificationException.ifNotInt(split[1]);
        DeveloperNotificationException.ifTrue("Der Monat von " + datumISO8601 + " ist ung\u00fcltig!", monat < 1 || monat > 12);
        int tagImMonat = DeveloperNotificationException.ifNotInt(split[2]);
        DeveloperNotificationException.ifTrue("Der Tag von " + datumISO8601 + " ist ung\u00fcltig!", tagImMonat < 1 || tagImMonat > 31);
        int schalttage1 = (jahr - 1) / 4 - (jahr - 1) / 100 + (jahr - 1) / 400;
        int schalttage2 = jahr / 4 - jahr / 100 + jahr / 400;
        int schaltjahr = schalttage2 - schalttage1;
        int tagImJahr = monat_zu_vergangene_tage[schaltjahr][monat] + tagImMonat;
        int tagInWoche = (jahr + schalttage1 + tagImJahr + 5) % 7 + 1;
        int tagImJahrAmJanuar4 = 4;
        int wochentagAmJanuar4 = (jahr + schalttage1 + 4 + 5) % 7 + 1;
        int tagImJahrAmMontagDerKW1 = 4 - wochentagAmJanuar4 + 1;
        int kalenderwochen = DateUtils.gibKalenderwochenOfJahr(jahr);
        int kalenderwochenjahr = jahr;
        int kalenderwoche = 1 + (tagImJahr - tagImJahrAmMontagDerKW1) / 7;
        if (kalenderwoche > kalenderwochen) {
            kalenderwoche = 1;
            ++kalenderwochenjahr;
        }
        if (tagImJahr < tagImJahrAmMontagDerKW1) {
            kalenderwoche = DateUtils.gibKalenderwochenOfJahr(jahr - 1);
        }
        return new int[]{jahr, monat, tagImMonat, tagInWoche, tagImJahr, kalenderwoche, --kalenderwochenjahr};
    }

    public static int gibKalenderwochenOfJahr(int jahr) {
        int schalttage1 = (jahr - 1) / 4 - (jahr - 1) / 100 + (jahr - 1) / 400;
        int schalttage2 = jahr / 4 - jahr / 100 + jahr / 400;
        int schaltjahr = schalttage2 - schalttage1;
        int wochentagAmJanuar1 = (jahr + schalttage1 + 1 + 5) % 7 + 1;
        return wochentagAmJanuar1 == 4 || schaltjahr == 1 && wochentagAmJanuar1 == 3 ? 53 : 52;
    }

    public static int gibTageOfJahr(int jahr) {
        int schalttage1 = (jahr - 1) / 4 - (jahr - 1) / 100 + (jahr - 1) / 400;
        int schalttage2 = jahr / 4 - jahr / 100 + jahr / 400;
        int schaltjahr = schalttage2 - schalttage1;
        return 365 + schaltjahr;
    }

    @NotNull
    public static String gibDatumDesWochentagsOfJahrAndKalenderwoche(int kalenderwochenjahr, int kalenderwoche, int wochentag) {
        DeveloperNotificationException.ifTrue("kalenderwoche < 1", kalenderwoche < 1);
        DeveloperNotificationException.ifTrue("kalenderwoche > gibKalenderwochenOfJahr(jahr)", kalenderwoche > DateUtils.gibKalenderwochenOfJahr(kalenderwochenjahr));
        DeveloperNotificationException.ifTrue("(wochentag < 1) || (wochentag > 7)", wochentag < 1 || wochentag > 7);
        int schalttage1 = (kalenderwochenjahr - 1) / 4 - (kalenderwochenjahr - 1) / 100 + (kalenderwochenjahr - 1) / 400;
        int tagImJahrAmJanuar4 = 4;
        int wochentagAmJanuar4 = (kalenderwochenjahr + schalttage1 + 4 + 5) % 7 + 1;
        int tagImJahr = 7 * kalenderwoche - wochentagAmJanuar4 + wochentag - 3;
        return DateUtils.gibDatumDesTagesOfJahr(kalenderwochenjahr, tagImJahr);
    }

    @NotNull
    public static String gibDatumDesMontagsOfJahrAndKalenderwoche(int kalenderwochenjahr, int kalenderwoche) {
        return DateUtils.gibDatumDesWochentagsOfJahrAndKalenderwoche(kalenderwochenjahr, kalenderwoche, 1);
    }

    @NotNull
    public static String gibDatumDesSonntagsOfJahrAndKalenderwoche(int kalenderwochenjahr, int kalenderwoche) {
        return DateUtils.gibDatumDesWochentagsOfJahrAndKalenderwoche(kalenderwochenjahr, kalenderwoche, 7);
    }

    @NotNull
    public static String gibDatumDesTagesOfJahr(int jahr, int tagImJahr) {
        int tageDesJahres;
        int j = jahr;
        int t = tagImJahr;
        if (t <= 0) {
            t += DateUtils.gibTageOfJahr(--j);
        }
        DeveloperNotificationException.ifTrue("Man kann maximal ins Vorjahr springen!", t <= 0);
        if (t > DateUtils.gibTageOfJahr(j)) {
            t -= DateUtils.gibTageOfJahr(j);
            ++j;
        }
        DeveloperNotificationException.ifTrue("Man kann maximal ins Folgejahr springen!", t > (tageDesJahres = DateUtils.gibTageOfJahr(j)));
        int[] vergangeneTage = tageDesJahres == 365 ? monat_zu_vergangene_tage[0] : monat_zu_vergangene_tage[1];
        int monat = 12;
        for (int i = 2; i <= 12; ++i) {
            if (vergangeneTage[i] < t) continue;
            monat = i - 1;
            break;
        }
        int tagDesMonats = t - vergangeneTage[monat];
        return StringUtils.padZahl(j, 4) + "-" + StringUtils.padZahl(monat, 2) + "-" + StringUtils.padZahl(tagDesMonats, 2);
    }

    public static boolean gibIstJahrUngueltig(int jahr) {
        return jahr < 1900 || jahr > 2900;
    }

    @NotNull
    public static String gibDatumGermanFormat(@NotNull String datumISO8601) {
        @NotNull int[] info = DateUtils.extractFromDateISO8601(datumISO8601);
        int jahr = info[0];
        int monat = info[1];
        int tagImMonat = info[2];
        return StringUtils.padZahl(tagImMonat, 2) + "." + StringUtils.padZahl(monat, 2) + "." + StringUtils.padZahl(jahr, 4);
    }

    public static int gibMinutenOfZeitAsString(@NotNull String zeit) {
        @NotNull String @NotNull [] sSplit = zeit.split(":");
        DeveloperNotificationException.ifTrue("Zeit muss im Format hh:mm sein!", sSplit.length != 2);
        @NotNull String sStunden = sSplit[0].trim();
        @NotNull String sMinuten = sSplit[1].trim();
        DeveloperNotificationException.ifTrue("Zeit muss im Format hh:mm sein!", sStunden.length() < 1 || sStunden.length() > 2);
        DeveloperNotificationException.ifTrue("Zeit muss im Format hh:mm sein!", sMinuten.length() < 1 || sMinuten.length() > 2);
        int stunden = Integer.parseInt(sStunden);
        int minuten = Integer.parseInt(sMinuten);
        DeveloperNotificationException.ifTrue("(stunden < 0) || (stunden > 23)", stunden < 0 || stunden > 23);
        DeveloperNotificationException.ifTrue("(minuten < 0) || (minuten > 59)", minuten < 0 || minuten > 59);
        return stunden * 60 + minuten;
    }

    @NotNull
    public static String gibZeitStringOfMinuten(int minuten) {
        DeveloperNotificationException.ifTrue("(minuten < 0) || (minuten >= 1440)", minuten < 0 || minuten >= 1440);
        int std = minuten / 60;
        int min = minuten - std * 60;
        @NotNull String sStd = (std < 10 ? "0" : "") + std;
        @NotNull String sMin = (min < 10 ? "0" : "") + min;
        return sStd + ":" + sMin;
    }

    @NotNull
    public static String getStringOfUhrzeitFromMinuten(int minuten) {
        return DateUtils.gibZeitStringOfMinuten(minuten);
    }

    public static int gibKwDesDatumsISO8601(@NotNull String datumISO8601) {
        return DateUtils.extractFromDateISO8601(datumISO8601)[5];
    }

    public static int gibKwJahrDesDatumsISO8601(@NotNull String datumISO8601) {
        return DateUtils.extractFromDateISO8601(datumISO8601)[6];
    }

    public static int gibWochentagDesDatumsISO8601(@NotNull String datumISO8601) {
        return DateUtils.extractFromDateISO8601(datumISO8601)[3];
    }

    public static int getSchuljahrFromDateISO8601(@NotNull String datumISO8601) {
        int[] iso8601 = DateUtils.extractFromDateISO8601(datumISO8601);
        return iso8601[1] > 7 ? iso8601[0] : iso8601[0] - 1;
    }

    public static int getHalbjahrFromDateISO8601(@NotNull String datumISO8601) {
        int[] iso8601 = DateUtils.extractFromDateISO8601(datumISO8601);
        return iso8601[1] > 1 && iso8601[1] < 8 ? 2 : 1;
    }

    public static int[] getSchuljahrUndHalbjahrFromDateISO8601(@NotNull String datumISO8601) {
        int[] iso8601 = DateUtils.extractFromDateISO8601(datumISO8601);
        int[] result = new int[]{iso8601[1] > 7 ? iso8601[0] : iso8601[0] - 1, iso8601[1] > 1 && iso8601[1] < 8 ? 2 : 1};
        return result;
    }
}

