/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.data.kurse.KursListeEintrag;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class KursManager {
    @NotNull
    private final @NotNull List<@NotNull KursListeEintrag> _kurse = new ArrayList<KursListeEintrag>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull KursListeEintrag> _map = new HashMap();

    public KursManager() {
    }

    public KursManager(@NotNull @NotNull List<@NotNull KursListeEintrag> kurse) {
        this.addAll(kurse);
    }

    private boolean addInternal(@NotNull KursListeEintrag kurs) throws DeveloperNotificationException {
        if (kurs.id < 0L) {
            throw new DeveloperNotificationException("Die Kurs-ID darf nicht negativ sein!");
        }
        KursListeEintrag old = this._map.put(kurs.id, kurs);
        if (old != null) {
            return false;
        }
        return this._kurse.add(kurs);
    }

    private void sort() {
    }

    public boolean add(@NotNull KursListeEintrag kurs) {
        boolean result = this.addInternal(kurs);
        this.sort();
        return result;
    }

    public boolean addAll(@NotNull @NotNull Collection<@NotNull KursListeEintrag> kurse) {
        boolean result = true;
        for (KursListeEintrag kurs : kurse) {
            if (this.addInternal(kurs)) continue;
            result = false;
        }
        this.sort();
        return result;
    }

    public KursListeEintrag get(long id) {
        return this._map.get(id);
    }

    @NotNull
    public KursListeEintrag getOrException(long pKursID) throws DeveloperNotificationException {
        KursListeEintrag kurs = this._map.get(pKursID);
        if (kurs == null) {
            throw new DeveloperNotificationException("KursListeEintrag mit id=" + pKursID + " gibt es nicht.");
        }
        return kurs;
    }

    public boolean isEmpty() {
        return this._kurse.isEmpty();
    }

    @NotNull
    public @NotNull List<@NotNull KursListeEintrag> kurse() {
        return this._kurse;
    }

    @NotNull
    public @NotNull KursListeEintrag @NotNull [] values() {
        return this._kurse.toArray(new KursListeEintrag[0]);
    }

    @NotNull
    public @NotNull List<@NotNull KursListeEintrag> toList() {
        @NotNull ArrayList<@NotNull KursListeEintrag> result = new ArrayList<KursListeEintrag>();
        for (KursListeEintrag kurs : this._kurse) {
            result.add(kurs);
        }
        return result;
    }
}

