/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;

public final class ListUtils {
    private ListUtils() {
    }

    @NotNull
    public static <E> @NotNull List<@NotNull E> getCopyFiltered(@NotNull @NotNull List<@NotNull E> list, @NotNull @NotNull Predicate<@NotNull E> filter) {
        @NotNull ArrayList<@NotNull E> listFiltered = new ArrayList<E>();
        for (E t : list) {
            if (!filter.test(t)) continue;
            listFiltered.add(t);
        }
        return listFiltered;
    }

    public static <E> int getCountFiltered(@NotNull @NotNull List<@NotNull E> list, @NotNull @NotNull Predicate<@NotNull E> filter) {
        int summe = 0;
        for (E t : list) {
            if (!filter.test(t)) continue;
            ++summe;
        }
        return summe;
    }

    @NotNull
    public static <T> @NotNull List<@NotNull T> getCopyAsArrayListPermuted(@NotNull @NotNull T @NotNull [] arrayOfT, @NotNull Random random) {
        int i;
        @NotNull ArrayList<@NotNull T> list = new ArrayList<T>();
        int[] perm = new int[arrayOfT.length];
        for (i = 0; i < perm.length; ++i) {
            perm[i] = i;
        }
        for (int i1 = 0; i1 < perm.length; ++i1) {
            int save2;
            int i2 = random.nextInt(perm.length);
            int save1 = perm[i1];
            perm[i1] = save2 = perm[i2];
            perm[i2] = save1;
        }
        for (i = 0; i < arrayOfT.length; ++i) {
            list.add(arrayOfT[perm[i]]);
        }
        return list;
    }

    public static <E> void addIfNotExists(@NotNull @NotNull List<@NotNull E> list, @NotNull E e) {
        if (!list.contains(e)) {
            list.add(e);
        }
    }

    public static <E> void addAllIfNotExists(@NotNull @NotNull List<@NotNull E> list, @NotNull @NotNull List<@NotNull E> listToAdd) {
        for (E e : listToAdd) {
            if (list.contains(e)) continue;
            list.add(e);
        }
    }

    @NotNull
    public static <E> E getNonNullElementAtOrException(@NotNull @NotNull List<@NotNull E> list, int i) {
        E element = list.get(i);
        if (element == null) {
            throw new DeveloperNotificationException("Kein Element bei Index " + i + "!");
        }
        return element;
    }

    @NotNull
    public static <E> @NotNull List<@NotNull E> create1(@NotNull E element) {
        @NotNull ArrayList<@NotNull E> list = new ArrayList<E>();
        list.add(element);
        return list;
    }
}

