/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public final class Map2DUtils {
    private Map2DUtils() {
    }

    @NotNull
    public static <K1, K2, V> @NotNull List<@NotNull V> getOrCreateArrayList(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull List<@NotNull V>> map2D, @NotNull K1 key1, @NotNull K2 key2) {
        List<@NotNull V> list = map2D.getOrNull(key1, key2);
        if (list != null) {
            return list;
        }
        @NotNull ArrayList<@NotNull E> listNeu = new ArrayList();
        map2D.put(key1, key2, listNeu);
        return listNeu;
    }

    public static <K1, K2, V> void addToList(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull List<@NotNull V>> map2D, @NotNull K1 key1, @NotNull K2 key2, @NotNull V value) {
        List<@NotNull V> list = map2D.getOrNull(key1, key2);
        if (list != null) {
            list.add(value);
        } else {
            @NotNull ArrayList<@NotNull V> listNeu = new ArrayList<V>();
            listNeu.add(value);
            map2D.put(key1, key2, listNeu);
        }
    }

    public static <K1, K2, V> void addToListIfNotExists(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull List<@NotNull V>> map2D, @NotNull K1 key1, @NotNull K2 key2, @NotNull V value) {
        List<@NotNull V> list = map2D.getOrNull(key1, key2);
        if (list != null) {
            if (!list.contains(value)) {
                list.add(value);
            }
        } else {
            @NotNull ArrayList<@NotNull V> listNeu = new ArrayList<V>();
            listNeu.add(value);
            map2D.put(key1, key2, listNeu);
        }
    }

    public static <K1, K2, V> void removeFromListAndTrimOrException(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull List<@NotNull V>> map2D, @NotNull K1 key1, @NotNull K2 key2, @NotNull V value) {
        List<@NotNull V> list = map2D.getNonNullOrException(key1, key2);
        DeveloperNotificationException.ifListRemoveFailes("list", list, value);
        if (list.isEmpty()) {
            map2D.removeOrException(key1, key2);
        }
    }
}

