/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MapUtils {
    private MapUtils() {
    }

    @NotNull
    public static <K, V> @NotNull Set<@NotNull V> getOrCreateHashSet(@NotNull @NotNull Map<@NotNull K, @NotNull Set<@NotNull V>> map, @NotNull K key) {
        Set<@NotNull V> set = map.get(key);
        if (set != null) {
            return set;
        }
        @NotNull HashSet<@NotNull E> setNeu = new HashSet();
        map.put(key, setNeu);
        return setNeu;
    }

    @NotNull
    public static <K, V> @NotNull List<@NotNull V> getOrCreateArrayList(@NotNull @NotNull Map<@NotNull K, @NotNull List<@NotNull V>> map, @NotNull K key) {
        List<@NotNull V> list = map.get(key);
        if (list != null) {
            return list;
        }
        @NotNull ArrayList<@NotNull E> listNeu = new ArrayList();
        map.put(key, listNeu);
        return listNeu;
    }

    public static <K, V> void addToListIfNotExists(@NotNull @NotNull Map<@NotNull K, @NotNull List<@NotNull V>> map, @NotNull K key, @NotNull V value) {
        List<@NotNull V> list = map.get(key);
        if (list != null) {
            if (!list.contains(value)) {
                list.add(value);
            }
        } else {
            ArrayList<@NotNull V> listNeu = new ArrayList<V>();
            listNeu.add(value);
            map.put(key, listNeu);
        }
    }

    public static <K, V> void addToList(@NotNull @NotNull Map<@NotNull K, @NotNull List<@NotNull V>> map, @NotNull K key, @NotNull V value) {
        List<@NotNull V> list = map.get(key);
        if (list != null) {
            list.add(value);
        } else {
            ArrayList<@NotNull V> listNeu = new ArrayList<V>();
            listNeu.add(value);
            map.put(key, listNeu);
        }
    }

    public static <K, V> void removeFromListAndTrimOrException(@NotNull @NotNull Map<@NotNull K, @NotNull List<@NotNull V>> map, @NotNull K key, @NotNull V value) {
        List<@NotNull V> list = DeveloperNotificationException.ifMapGetIsNull(map, key);
        DeveloperNotificationException.ifListRemoveFailes("list", list, value);
        if (list.isEmpty()) {
            DeveloperNotificationException.ifMapRemoveFailes(map, key);
        }
    }

    @NotNull
    public static <K, V> V getOrDefault(@NotNull @NotNull Map<@NotNull K, @NotNull V> map, @NotNull K key, @NotNull V defaultValue) {
        V value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

