/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;

public final class StringUtils {
    @NotNull
    private static final @NotNull String @NotNull [] buchstaben = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    private StringUtils() {
    }

    @NotNull
    public static String collectionToCommaSeparatedString(@NotNull @NotNull Collection<@NotNull String> collection) {
        @NotNull StringBuilder sb = new StringBuilder();
        for (String s : collection) {
            if (sb.isEmpty()) {
                sb.append(s);
                continue;
            }
            sb.append(", " + s);
        }
        return sb.toString();
    }

    @NotNull
    public static String numberToLetterIndex0(int number) {
        return number < 0 || number > 25 ? "" : buchstaben[number];
    }

    @NotNull
    public static String numberToLetterIndex1(int number) {
        return number < 1 || number > 26 ? "" : buchstaben[number - 1];
    }

    @NotNull
    public static String padZahl(int zahl, int minGroesse) {
        String sNumber = "" + zahl;
        StringBuilder sb = new StringBuilder();
        while (sb.length() + sNumber.length() < minGroesse) {
            sb.append('0');
        }
        sb.append(sNumber);
        return sb.toString();
    }

    @NotNull
    public static String fillWithLeadingZeros(@NotNull String s, int size) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() + s.length() < size) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }
}

