/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.benutzer;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.benutzer.BenutzerDaten;
import de.svws_nrw.core.data.benutzer.BenutzergruppeDaten;
import de.svws_nrw.core.types.benutzer.BenutzerKompetenz;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BenutzerManager {
    @NotNull
    private final BenutzerDaten _daten;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull BenutzergruppeDaten> _mapGruppen = new HashMap();
    @NotNull
    private final @NotNull HashSet<@NotNull Long> _setGruppenIDs = new HashSet();
    @NotNull
    private final @NotNull Map<@NotNull BenutzerKompetenz, @NotNull ArrayList<@NotNull BenutzergruppeDaten>> _mapKompetenzenVonGruppe = new ArrayMap<BenutzerKompetenz, ArrayList<BenutzergruppeDaten>>(BenutzerKompetenz.values());
    @NotNull
    private final @NotNull HashSet<@NotNull BenutzerKompetenz> _setKompetenzen = new HashSet();
    @NotNull
    private final @NotNull HashSet<@NotNull BenutzerKompetenz> _setKompetenzenAlle = new HashSet();

    public BenutzerManager(long id) {
        this.init();
        this._daten = new BenutzerDaten();
        this._daten.id = id;
        this._daten.istAdmin = false;
    }

    public BenutzerManager(@NotNull BenutzerDaten pDaten) {
        this.init();
        this._daten = pDaten;
        for (Long kID : pDaten.kompetenzen) {
            if (kID == null) {
                throw new NullPointerException("Fehlerhafte Daten: Die Liste der Kompetenzen darf keine Null-Werte enthalten.");
            }
            BenutzerKompetenz komp = BenutzerKompetenz.getByID(kID);
            if (komp == null) {
                throw new NullPointerException("Fehlerhafte Daten: Die Kompetenz mit der ID " + kID + " existiert nicht.");
            }
            if (this._setKompetenzen.contains((Object)komp)) {
                throw new IllegalArgumentException("Die Kompetenz mit der ID " + kID + " wurde mehrfach bei der Gruppe eingetragen.");
            }
            this._setKompetenzen.add(komp);
            this._setKompetenzenAlle.add(komp);
        }
        for (BenutzergruppeDaten bgd : this._daten.gruppen) {
            this.addGruppe(bgd);
        }
    }

    private void addGruppe(BenutzergruppeDaten bgd) {
        if (bgd == null) {
            return;
        }
        this._mapGruppen.put(bgd.id, bgd);
        this._setGruppenIDs.add(bgd.id);
        for (Long kid : bgd.kompetenzen) {
            BenutzerKompetenz komp = BenutzerKompetenz.getByID(kid);
            if (komp == null) {
                throw new NullPointerException("Fehlerhafte Daten: Die Kompetenz mit der ID " + kid + " existiert nicht.");
            }
            this._setKompetenzenAlle.add(komp);
            ArrayList<@NotNull BenutzergruppeDaten> gruppen = this._mapKompetenzenVonGruppe.get((Object)komp);
            if (gruppen == null) {
                throw new NullPointerException("ArrayList existiert nicht, m\u00fcsste aber zuvor initialisiert worden sein.");
            }
            gruppen.add(bgd);
        }
    }

    private void removeGruppe(BenutzergruppeDaten bgd) {
        if (bgd == null) {
            return;
        }
        this._mapGruppen.remove(bgd.id);
        this._setGruppenIDs.remove(bgd.id);
        for (Long kid : bgd.kompetenzen) {
            BenutzerKompetenz komp = BenutzerKompetenz.getByID(kid);
            if (komp == null) continue;
            ArrayList<@NotNull BenutzergruppeDaten> gruppen = this._mapKompetenzenVonGruppe.get((Object)komp);
            if (gruppen == null) {
                throw new NullPointerException("ArrayList existiert nicht, m\u00fcsste aber zuvor initialisiert worden sein.");
            }
            for (int i = gruppen.size() - 1; i >= 0; --i) {
                if (gruppen.get((int)i).id != bgd.id) continue;
                gruppen.remove(gruppen.get(i));
            }
            if (!gruppen.isEmpty() || this._setKompetenzen.contains((Object)komp)) continue;
            this._setKompetenzenAlle.remove((Object)komp);
        }
    }

    public boolean istInAdminGruppe() {
        for (BenutzergruppeDaten bg : this._mapGruppen.values()) {
            if (!bg.istAdmin) continue;
            return true;
        }
        return false;
    }

    private void init() {
        for (BenutzerKompetenz p : BenutzerKompetenz.values()) {
            this._mapKompetenzenVonGruppe.put(p, new ArrayList());
        }
    }

    @NotNull
    public @NotNull List<@NotNull BenutzergruppeDaten> getGruppen(@NotNull BenutzerKompetenz kompetenz) {
        ArrayList<@NotNull BenutzergruppeDaten> gruppen = this._mapKompetenzenVonGruppe.get((Object)kompetenz);
        if (gruppen == null) {
            throw new NullPointerException("Die interne Datenstruktur _mapKompetenzenVonGruppe wurde nich korrekt initialisiert.");
        }
        return gruppen;
    }

    @NotNull
    public BenutzerDaten daten() {
        return this._daten;
    }

    public long getID() {
        return this._daten.id;
    }

    @NotNull
    public @NotNull List<@NotNull BenutzergruppeDaten> getBenutzerGruppen() {
        return this._daten.gruppen;
    }

    @NotNull
    public String getAnmeldename() {
        return this._daten.name;
    }

    public void setAnmeldename(@NotNull String name) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("Der Anmeldename eines Benutzers darf nicht leer sein.");
        }
        this._daten.name = name;
    }

    @NotNull
    public String getAnzeigename() {
        return this._daten.anzeigename;
    }

    public void setAnzeigename(@NotNull String name) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("Der Anmeldename eines Benutzers darf nicht leer sein.");
        }
        this._daten.anzeigename = name;
    }

    public void setAdmin(boolean istAdmin) {
        this._daten.istAdmin = istAdmin;
    }

    public boolean istAdmin() {
        return this._daten.istAdmin || this.istInAdminGruppe();
    }

    public boolean hatKompetenz(@NotNull BenutzerKompetenz kompetenz) {
        if (this._daten.istAdmin || this.istInAdminGruppe()) {
            return true;
        }
        return this._setKompetenzenAlle.contains((Object)kompetenz);
    }

    public boolean hatKompetenzen(@NotNull @NotNull List<@NotNull BenutzerKompetenz> kompetenzen) {
        if (this._daten.istAdmin) {
            return true;
        }
        for (BenutzerKompetenz kompetenz : kompetenzen) {
            if (this._setKompetenzenAlle.contains((Object)kompetenz)) continue;
            return false;
        }
        return true;
    }

    public boolean hatKompetenzenMindestensEine(@NotNull @NotNull List<@NotNull BenutzerKompetenz> kompetenzen) {
        if (this._daten.istAdmin) {
            return true;
        }
        for (BenutzerKompetenz kompetenz : kompetenzen) {
            if (!this._setKompetenzenAlle.contains((Object)kompetenz)) continue;
            return true;
        }
        return false;
    }

    public void addKompetenz(BenutzerKompetenz kompetenz) throws IllegalArgumentException {
        if (kompetenz == null) {
            throw new NullPointerException("Die \u00fcbergebene Kompetenz darf nicht null sein.");
        }
        if (this._setKompetenzen.contains((Object)kompetenz)) {
            throw new IllegalArgumentException("Die Kompetenz mit der ID " + kompetenz.daten.id + " wurde bereits zuvor zu dem Benutzer hinzugef\u00fcgt.");
        }
        this._daten.kompetenzen.add(kompetenz.daten.id);
        this._setKompetenzen.add(kompetenz);
        this._setKompetenzenAlle.add(kompetenz);
    }

    public void removeKompetenz(@NotNull BenutzerKompetenz kompetenz) throws IllegalArgumentException {
        if (!this._setKompetenzen.contains((Object)kompetenz)) {
            throw new IllegalArgumentException("Die Kompetenz mit der ID " + kompetenz.daten.id + " ist nicht direkt beim Benutzer vorhanden.");
        }
        this._daten.kompetenzen.remove(kompetenz.daten.id);
        this._setKompetenzen.remove((Object)kompetenz);
        @NotNull List<@NotNull BenutzergruppeDaten> gruppen = this.getGruppen(kompetenz);
        if (gruppen.isEmpty()) {
            this._setKompetenzenAlle.remove((Object)kompetenz);
        }
    }

    public boolean istInGruppe(@NotNull long id) {
        return this._setGruppenIDs.contains(id);
    }

    public long anzahlGruppen() {
        return this._setGruppenIDs.size();
    }

    public void addToGruppe(@NotNull BenutzergruppeDaten bgd) {
        if (bgd == null) {
            throw new IllegalArgumentException("Der Benutzer ist bereits in der Gruppe ");
        }
        this.addGruppe(bgd);
    }

    public void removeFromGruppe(@NotNull BenutzergruppeDaten bgd) {
        this.removeGruppe(bgd);
    }
}

