/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.benutzer;

import de.svws_nrw.core.data.benutzer.BenutzergruppeDaten;
import de.svws_nrw.core.types.benutzer.BenutzerKompetenz;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.List;

public class BenutzergruppenManager {
    @NotNull
    private final BenutzergruppeDaten _daten;
    @NotNull
    private final @NotNull HashSet<@NotNull Long> _setKompetenzen = new HashSet();

    public BenutzergruppenManager(long id, @NotNull String bezeichnung) {
        this._daten = new BenutzergruppeDaten();
        this._daten.id = id;
        this._daten.bezeichnung = bezeichnung;
        this._daten.istAdmin = false;
    }

    public BenutzergruppenManager(@NotNull BenutzergruppeDaten pDaten) {
        this._daten = pDaten;
        for (Long kID : pDaten.kompetenzen) {
            if (kID == null) {
                throw new NullPointerException("Fehlerhafte Daten: Die Liste der Kompetenzen darf keine Null-Werte enthalten.");
            }
            if (this._setKompetenzen.contains(kID)) {
                throw new IllegalArgumentException("Die Kompetenz mit der ID " + kID + " wurde mehrfach bei der Gruppe eingetragen.");
            }
            this._setKompetenzen.add(kID);
        }
    }

    @NotNull
    public BenutzergruppeDaten daten() {
        return this._daten;
    }

    public long getID() {
        return this._daten.id;
    }

    @NotNull
    public String getBezeichnung() {
        return this._daten.bezeichnung;
    }

    public void setBezeichnung(@NotNull String bezeichnung) {
        if ("".equals(bezeichnung)) {
            throw new IllegalArgumentException("Die Bezeichnung einer Benutzergruppe darf nicht leer sein.");
        }
        this._daten.bezeichnung = bezeichnung;
    }

    public void setAdmin(boolean istAdmin) {
        this._daten.istAdmin = istAdmin;
    }

    public boolean istAdmin() {
        return this._daten.istAdmin;
    }

    public boolean hatKompetenz(@NotNull BenutzerKompetenz kompetenz) {
        if (this._daten.istAdmin) {
            return true;
        }
        return this._setKompetenzen.contains(kompetenz.daten.id);
    }

    public boolean hatKompetenzen(@NotNull @NotNull List<@NotNull BenutzerKompetenz> kompetenzen) {
        if (this._daten.istAdmin) {
            return true;
        }
        for (BenutzerKompetenz kompetenz : kompetenzen) {
            if (this._setKompetenzen.contains(kompetenz.daten.id)) continue;
            return false;
        }
        return true;
    }

    public boolean hatKompetenzenMindestensEine(@NotNull @NotNull List<@NotNull BenutzerKompetenz> kompetenzen) {
        if (this._daten.istAdmin) {
            return true;
        }
        for (BenutzerKompetenz kompetenz : kompetenzen) {
            if (!this._setKompetenzen.contains(kompetenz.daten.id)) continue;
            return true;
        }
        return false;
    }

    public void addKompetenz(BenutzerKompetenz kompetenz) throws IllegalArgumentException {
        if (kompetenz == null) {
            throw new NullPointerException("Die \u00fcbergenene Kompetenz darf nicht null sein.");
        }
        if (this._setKompetenzen.contains(kompetenz.daten.id)) {
            throw new IllegalArgumentException("Die Kompetenz mit der ID " + kompetenz.daten.id + " wurde bereits zuvor zu der Gruppe hinzugef\u00fcgt.");
        }
        this._daten.kompetenzen.add(kompetenz.daten.id);
        this._setKompetenzen.add(kompetenz.daten.id);
    }

    public void removeKompetenz(@NotNull BenutzerKompetenz kompetenz) throws IllegalArgumentException {
        if (!this._setKompetenzen.contains(kompetenz.daten.id)) {
            throw new IllegalArgumentException("Die Kompetenz mit der ID " + kompetenz.daten.id + " ist in der Gruppe nicht vorhanden.");
        }
        this._daten.kompetenzen.remove(kompetenz.daten.id);
        this._setKompetenzen.remove(kompetenz.daten.id);
    }
}

