/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.enm;

import de.svws_nrw.core.data.enm.ENMDaten;
import de.svws_nrw.core.data.enm.ENMFach;
import de.svws_nrw.core.data.enm.ENMFoerderschwerpunkt;
import de.svws_nrw.core.data.enm.ENMJahrgang;
import de.svws_nrw.core.data.enm.ENMKlasse;
import de.svws_nrw.core.data.enm.ENMLehrer;
import de.svws_nrw.core.data.enm.ENMLeistung;
import de.svws_nrw.core.data.enm.ENMLerngruppe;
import de.svws_nrw.core.data.enm.ENMNote;
import de.svws_nrw.core.data.enm.ENMSchueler;
import de.svws_nrw.core.types.Geschlecht;
import de.svws_nrw.core.types.Note;
import de.svws_nrw.core.types.schueler.Foerderschwerpunkt;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;

public class ENMDatenManager {
    @NotNull
    public final ENMDaten daten;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ENMLehrer> mapLehrer = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ENMSchueler> mapSchueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ENMFach> mapFaecher = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull ENMFach> mapFaecherByKuerzel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ENMJahrgang> mapJahrgaenge = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ENMKlasse> mapKlassen = new HashMap();
    private long lerngruppenIDZaehler = 1L;
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull ENMLerngruppe> mapLerngruppen = new HashMap();

    public ENMDatenManager(Long lehrerID) {
        this.daten = new ENMDaten();
        this.daten.lehrerID = lehrerID;
    }

    public ENMDatenManager(@NotNull ENMDaten daten) {
        this.daten = daten;
    }

    public void setSchuldaten(int schulnummer, int schuljahr, int anzahlAbschnitte, int abschnitt, String publicKey, boolean fehlstundenEingabe, boolean fehlstundenSIFachbezogen, boolean fehlstundenSIIFachbezogen, @NotNull String schulform, String mailadresse) {
        this.daten.schulnummer = schulnummer;
        this.daten.schuljahr = schuljahr;
        this.daten.anzahlAbschnitte = anzahlAbschnitte;
        this.daten.aktuellerAbschnitt = abschnitt;
        this.daten.publicKey = publicKey;
        this.daten.fehlstundenEingabe = fehlstundenEingabe;
        this.daten.fehlstundenSIFachbezogen = fehlstundenSIFachbezogen;
        this.daten.fehlstundenSIIFachbezogen = fehlstundenSIIFachbezogen;
        this.daten.schulform = schulform;
        this.daten.mailadresse = mailadresse;
    }

    public void addNoten() {
        if (!this.daten.noten.isEmpty()) {
            return;
        }
        @NotNull Note @NotNull [] noten = Note.values();
        for (int i = 0; i < noten.length; ++i) {
            @NotNull Note note = noten[i];
            @NotNull ENMNote enmNote = new ENMNote();
            enmNote.id = note.id;
            enmNote.kuerzel = note.kuerzel;
            enmNote.notenpunkte = note.notenpunkte;
            enmNote.text = note.text;
            this.daten.noten.add(enmNote);
        }
    }

    public void addFoerderschwerpunkte(@NotNull Schulform schulform) {
        if (!this.daten.foerderschwerpunkte.isEmpty()) {
            return;
        }
        @NotNull List<@NotNull Foerderschwerpunkt> foerderschwerpunkte = Foerderschwerpunkt.get(schulform);
        for (int i = 0; i < foerderschwerpunkte.size(); ++i) {
            Foerderschwerpunkt foerderschwerpunkt = foerderschwerpunkte.get(i);
            ENMFoerderschwerpunkt enmFoerderschwerpunkt = new ENMFoerderschwerpunkt();
            enmFoerderschwerpunkt.id = foerderschwerpunkt.daten.id;
            enmFoerderschwerpunkt.kuerzel = foerderschwerpunkt.daten.kuerzel;
            enmFoerderschwerpunkt.beschreibung = foerderschwerpunkt.daten.beschreibung;
            this.daten.foerderschwerpunkte.add(enmFoerderschwerpunkt);
        }
    }

    public boolean addLehrer(long id, String kuerzel, String nachname, String vorname, @NotNull Geschlecht geschlecht, String eMailDienstlich) {
        if (this.mapLehrer.get(id) != null) {
            return false;
        }
        @NotNull ENMLehrer enmLehrer = new ENMLehrer();
        enmLehrer.id = id;
        enmLehrer.kuerzel = kuerzel;
        enmLehrer.nachname = nachname;
        enmLehrer.vorname = vorname;
        enmLehrer.geschlecht = geschlecht.kuerzel;
        enmLehrer.eMailDienstlich = eMailDienstlich;
        this.daten.lehrer.add(enmLehrer);
        this.mapLehrer.put(id, enmLehrer);
        return true;
    }

    public boolean addSchueler(long id, long jahrgangID, long klasseID, String nachname, String vorname, @NotNull Geschlecht geschlecht, String bilingualeSprache, boolean istZieldifferent, boolean istDaZFoerderung) {
        if (this.mapSchueler.get(id) != null) {
            return false;
        }
        @NotNull ENMSchueler enmSchueler = new ENMSchueler();
        enmSchueler.id = id;
        enmSchueler.jahrgangID = jahrgangID;
        enmSchueler.klasseID = klasseID;
        enmSchueler.nachname = nachname;
        enmSchueler.vorname = vorname;
        enmSchueler.geschlecht = geschlecht.kuerzel;
        enmSchueler.bilingualeSprache = bilingualeSprache;
        enmSchueler.istZieldifferent = istZieldifferent;
        enmSchueler.istDaZFoerderung = istDaZFoerderung;
        this.daten.schueler.add(enmSchueler);
        this.mapSchueler.put(id, enmSchueler);
        return true;
    }

    public boolean addFach(long id, @NotNull String kuerzel, @NotNull String kuerzelAnzeige, int sortierung, boolean istFremdsprache) {
        if (this.mapFaecher.get(id) != null) {
            return false;
        }
        @NotNull ENMFach enmFach = new ENMFach();
        enmFach.id = id;
        enmFach.kuerzel = kuerzel;
        enmFach.kuerzelAnzeige = kuerzelAnzeige;
        enmFach.sortierung = sortierung;
        enmFach.istFremdsprache = istFremdsprache;
        this.daten.faecher.add(enmFach);
        this.mapFaecher.put(id, enmFach);
        this.mapFaecherByKuerzel.put(kuerzelAnzeige, enmFach);
        return true;
    }

    public boolean addJahrgang(long id, String kuerzel, String kuerzelAnzeige, String beschreibung, String stufe, int sortierung) {
        if (this.mapJahrgaenge.get(id) != null) {
            return false;
        }
        @NotNull ENMJahrgang enmJahrgang = new ENMJahrgang();
        enmJahrgang.id = id;
        enmJahrgang.kuerzel = kuerzel;
        enmJahrgang.kuerzelAnzeige = kuerzelAnzeige;
        enmJahrgang.beschreibung = beschreibung;
        enmJahrgang.stufe = stufe;
        enmJahrgang.sortierung = sortierung;
        this.daten.jahrgaenge.add(enmJahrgang);
        this.mapJahrgaenge.put(id, enmJahrgang);
        return true;
    }

    public boolean addKlasse(long id, String kuerzel, String kuerzelAnzeige, Long idJahrgang, int sortierung) {
        if (this.mapKlassen.get(id) != null) {
            return false;
        }
        @NotNull ENMKlasse enmKlasse = new ENMKlasse();
        enmKlasse.id = id;
        enmKlasse.kuerzel = kuerzel;
        enmKlasse.kuerzelAnzeige = kuerzelAnzeige;
        enmKlasse.idJahrgang = idJahrgang;
        enmKlasse.sortierung = sortierung;
        this.daten.klassen.add(enmKlasse);
        this.mapKlassen.put(id, enmKlasse);
        return true;
    }

    public ENMLehrer getLehrer(long id) {
        return this.mapLehrer.get(id);
    }

    public ENMSchueler getSchueler(long id) {
        return this.mapSchueler.get(id);
    }

    public ENMFach getFach(long id) {
        return this.mapFaecher.get(id);
    }

    public ENMFach getFachByKuerzel(@NotNull String kuerzel) {
        return this.mapFaecherByKuerzel.get(kuerzel);
    }

    public ENMJahrgang getJahrgang(long id) {
        return this.mapJahrgaenge.get(id);
    }

    public ENMKlasse getKlasse(long id) {
        return this.mapKlassen.get(id);
    }

    public void addLerngruppe(@NotNull String strID, long kID, long fachID, Integer kursartID, String bezeichnung, String kursartKuerzel, String bilingualeSprache, int wochenstunden) {
        if (this.mapLerngruppen.get(strID) != null) {
            return;
        }
        @NotNull ENMLerngruppe lerngruppe = new ENMLerngruppe();
        lerngruppe.id = this.lerngruppenIDZaehler++;
        lerngruppe.kID = kID;
        lerngruppe.fachID = fachID;
        lerngruppe.kursartID = kursartID;
        lerngruppe.bezeichnung = bezeichnung;
        lerngruppe.kursartKuerzel = kursartKuerzel;
        lerngruppe.bilingualeSprache = bilingualeSprache;
        lerngruppe.wochenstunden = wochenstunden;
        this.mapLerngruppen.put(strID, lerngruppe);
        this.daten.lerngruppen.add(lerngruppe);
    }

    public ENMLerngruppe getLerngruppe(@NotNull String strID) {
        return this.mapLerngruppen.get(strID);
    }

    public void addSchuelerKlassenlehrer(@NotNull ENMSchueler schueler, long ... klassenlehrerIDs) {
    }

    public void addSchuelerSprachenfolge(@NotNull ENMSchueler schueler, String sprache, long fachID, String fachKuerzel, int reihenfolge, int belegungVonJahrgang, int belegungVonAbschnitt, Integer belegungBisJahrgang, Integer belegungBisAbschnitt, String referenzniveau, Integer belegungSekI) {
    }

    public void addSchuelerLeistungsdaten(@NotNull ENMSchueler schueler, long leistungID, long lerngruppenID, String note, String tsNoteQuartal, String noteQuartal, String tsNote, boolean istSchriftlich, Integer abiturfach, Integer fehlstundenFach, String tsFehlstundenFach, Integer fehlstundenUnentschuldigtFach, String tsFehlstundenUnentschuldigtFach, String fachbezogeneBemerkungen, String tsFachbezogeneBemerkungen, String neueZuweisungKursart, boolean istGemahnt, String tsIstGemahnt, String mahndatum) {
        @NotNull ENMLeistung enmLeistung = new ENMLeistung();
        enmLeistung.id = leistungID;
        enmLeistung.lerngruppenID = lerngruppenID;
        enmLeistung.note = note;
        enmLeistung.tsNote = tsNote;
        enmLeistung.noteQuartal = noteQuartal;
        enmLeistung.tsNoteQuartal = tsNoteQuartal;
        enmLeistung.istSchriftlich = istSchriftlich;
        enmLeistung.abiturfach = abiturfach;
        enmLeistung.fehlstundenFach = fehlstundenFach;
        enmLeistung.tsFehlstundenFach = tsFehlstundenFach;
        enmLeistung.fehlstundenUnentschuldigtFach = fehlstundenUnentschuldigtFach;
        enmLeistung.tsFehlstundenUnentschuldigtFach = tsFehlstundenUnentschuldigtFach;
        enmLeistung.fachbezogeneBemerkungen = fachbezogeneBemerkungen;
        enmLeistung.tsFachbezogeneBemerkungen = tsFachbezogeneBemerkungen;
        enmLeistung.neueZuweisungKursart = neueZuweisungKursart;
        enmLeistung.istGemahnt = istGemahnt;
        enmLeistung.tsIstGemahnt = tsIstGemahnt;
        enmLeistung.mahndatum = mahndatum;
        schueler.leistungsdaten.add(enmLeistung);
    }

    public void addSchuelerTeilleistung(@NotNull ENMLeistung leistung, long id, long artID, String datum, String bemerkung, String notenKuerzel) {
    }
}

