/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.data.gost.GostJahrgang;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import de.svws_nrw.core.utils.jahrgang.JahrgangsUtils;
import jakarta.validation.constraints.NotNull;
import java.util.Comparator;

public final class GostAbiturjahrUtils {
    @NotNull
    public static final @NotNull Comparator<@NotNull GostJahrgang> comparator = (a, b) -> {
        int cmp = a.abiturjahr - b.abiturjahr;
        if (cmp != 0) {
            return cmp;
        }
        if (a.jahrgang == null || b.jahrgang == null) {
            if (a.jahrgang == null && b.jahrgang == null) {
                return 0;
            }
            return a.jahrgang == null ? -1 : 1;
        }
        return a.jahrgang.compareTo(b.jahrgang);
    };

    private GostAbiturjahrUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Integer getGostAbiturjahr(@NotNull Schulform schulform, @NotNull Schulgliederung gliederung, int aktuellesSchuljahr, @NotNull String jahrgang) {
        if (schulform.daten == null || !schulform.daten.hatGymOb) {
            return null;
        }
        Integer restjahre = JahrgangsUtils.getRestlicheJahre(schulform, gliederung, jahrgang);
        return restjahre == null ? null : Integer.valueOf(aktuellesSchuljahr + restjahre);
    }

    public static String getGostAbiturjahrJahrgang(@NotNull Schulform schulform, @NotNull Schulgliederung gliederung, int schuljahr, int abiturjahr) {
        int sekIJahre;
        if (schulform.daten == null || !schulform.daten.hatGymOb) {
            return null;
        }
        int restlicheJahre = abiturjahr - schuljahr;
        if (restlicheJahre <= 1) {
            return "Q2";
        }
        if (restlicheJahre == 2) {
            return "Q1";
        }
        if (restlicheJahre == 3) {
            return "EF";
        }
        int n = sekIJahre = gliederung.istG8() || schulform == Schulform.GY && gliederung == Schulgliederung.DEFAULT ? 9 : 10;
        if (restlicheJahre >= sekIJahre) {
            return null;
        }
        String strJG = "" + (sekIJahre - (restlicheJahre - 4));
        if (strJG.length() == 1) {
            strJG = "0" + strJG;
        }
        return strJG;
    }
}

