/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.adt.LongArrayKey;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostBlockungKurs;
import de.svws_nrw.core.data.gost.GostBlockungKursLehrer;
import de.svws_nrw.core.data.gost.GostBlockungRegel;
import de.svws_nrw.core.data.gost.GostBlockungSchiene;
import de.svws_nrw.core.data.gost.GostBlockungsdaten;
import de.svws_nrw.core.data.gost.GostBlockungsergebnis;
import de.svws_nrw.core.data.gost.GostBlockungsergebnisListeneintrag;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.schueler.Schueler;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.exceptions.UserNotificationException;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.kursblockung.GostKursblockungRegelTyp;
import de.svws_nrw.core.utils.Map2DUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.gost.GostBlockungsergebnisComparator;
import de.svws_nrw.core.utils.gost.GostFaecherManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GostBlockungsdatenManager {
    @NotNull
    private final GostBlockungsdaten _daten;
    @NotNull
    private final GostFaecherManager _faecherManager;
    @NotNull
    private static final @NotNull Comparator<@NotNull GostBlockungKurs> _compKursnummer = (a, b) -> Integer.compare(a.nummer, b.nummer);
    @NotNull
    private static final @NotNull Comparator<@NotNull GostBlockungSchiene> _compSchiene = (a, b) -> Integer.compare(a.nummer, b.nummer);
    @NotNull
    private static final @NotNull Comparator<@NotNull GostBlockungRegel> _compRegel = (a, b) -> {
        int result = Integer.compare(a.typ, b.typ);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull GostBlockungKursLehrer> _compLehrkraefte = (a, b) -> {
        int result = Integer.compare(a.reihenfolge, b.reihenfolge);
        if (result != 0) {
            return result;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private static final @NotNull Comparator<@NotNull Schueler> _compSchueler = (a, b) -> {
        int cNachname = a.nachname.compareTo(b.nachname);
        if (cNachname != 0) {
            return cNachname;
        }
        int cVorname = a.vorname.compareTo(b.vorname);
        if (cVorname != 0) {
            return cVorname;
        }
        return Long.compare(a.id, b.id);
    };
    @NotNull
    private final @NotNull Comparator<@NotNull GostFachwahl> _compFachwahlen;
    @NotNull
    private final @NotNull Comparator<@NotNull GostBlockungsergebnisListeneintrag> _compErgebnisse = new GostBlockungsergebnisComparator();
    @NotNull
    private final @NotNull Comparator<@NotNull GostBlockungKurs> _compKurs_kursart_fach_kursnummer;
    @NotNull
    private final @NotNull Comparator<@NotNull GostBlockungKurs> _compKurs_fach_kursart_kursnummer;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull GostBlockungKurs> _map_idKurs_kurs = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull GostBlockungKurs>> _map2d_idFach_idKursart_kurse = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull GostFachwahl>> _map2d_idFach_idKursart_fachwahlen = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull GostBlockungSchiene> _map_idSchiene_schiene = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull GostBlockungRegel> _map_idRegel_regel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull GostKursblockungRegelTyp, @NotNull List<@NotNull GostBlockungRegel>> _map_regeltyp_regeln = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull LongArrayKey, @NotNull GostBlockungRegel> _map_multikey_regeln = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull Schueler> _map_idSchueler_schueler = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull GostFachwahl>> _map_idSchueler_fachwahlen = new HashMap();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull GostFachwahl> _map2d_idSchueler_idFach_fachwahl = new HashMap2D();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull List<@NotNull GostFachwahl>> _map_idFachart_fachwahlen = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull GostBlockungsergebnisListeneintrag> _map_idErgebnis_Ergebnis = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull GostBlockungKurs> _list_kurse_sortiert_fach_kursart_kursnummer = new ArrayList<GostBlockungKurs>();
    @NotNull
    private final @NotNull List<@NotNull GostBlockungKurs> _list_kurse_sortiert_kursart_fach_kursnummer = new ArrayList<GostBlockungKurs>();
    private long _maxTimeMillis = 1000L;

    public GostBlockungsdatenManager() {
        this._faecherManager = new GostFaecherManager();
        this._daten = new GostBlockungsdaten();
        this._daten.gostHalbjahr = GostHalbjahr.EF1.id;
        this._compKurs_fach_kursart_kursnummer = this.createComparatorKursFachKursartNummer();
        this._compKurs_kursart_fach_kursnummer = this.createComparatorKursKursartFachNummer();
        this._compFachwahlen = this.createComparatorFachwahlen();
    }

    public GostBlockungsdatenManager(@NotNull GostBlockungsdaten daten, @NotNull GostFaecherManager faecherManager) {
        this._faecherManager = faecherManager;
        this._compKurs_fach_kursart_kursnummer = this.createComparatorKursFachKursartNummer();
        this._compKurs_kursart_fach_kursnummer = this.createComparatorKursKursartFachNummer();
        this._compFachwahlen = this.createComparatorFachwahlen();
        this._daten = new GostBlockungsdaten();
        this._daten.id = daten.id;
        this._daten.name = daten.name;
        this._daten.abijahrgang = daten.abijahrgang;
        this._daten.gostHalbjahr = daten.gostHalbjahr;
        this._daten.istAktiv = daten.istAktiv;
        this.schieneAddListe(daten.schienen);
        this.regelAddListe(daten.regeln);
        this.kursAddListe(daten.kurse);
        this.schuelerAddListe(daten.schueler);
        this.fachwahlAddListe(daten.fachwahlen);
        this.ergebnisAddListe(daten.ergebnisse);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull GostBlockungKurs> createComparatorKursFachKursartNummer() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            GostFach bFach;
            @NotNull GostFach aFach = this._faecherManager.getOrException(a.fach_id);
            int cmpFach = GostFaecherManager.comp.compare(aFach, bFach = this._faecherManager.getOrException(b.fach_id));
            if (cmpFach != 0) {
                return cmpFach;
            }
            if (a.kursart < b.kursart) {
                return -1;
            }
            if (a.kursart > b.kursart) {
                return 1;
            }
            return Integer.compare(a.nummer, b.nummer);
        };
        return comp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull GostBlockungKurs> createComparatorKursKursartFachNummer() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            GostFach bFach;
            if (a.kursart < b.kursart) {
                return -1;
            }
            if (a.kursart > b.kursart) {
                return 1;
            }
            @NotNull GostFach aFach = this._faecherManager.getOrException(a.fach_id);
            int cmpFach = GostFaecherManager.comp.compare(aFach, bFach = this._faecherManager.getOrException(b.fach_id));
            if (cmpFach != 0) {
                return cmpFach;
            }
            return Integer.compare(a.nummer, b.nummer);
        };
        return comp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull GostFachwahl> createComparatorFachwahlen() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            if (a.schuelerID < b.schuelerID) {
                return -1;
            }
            if (a.schuelerID > b.schuelerID) {
                return 1;
            }
            if (a.kursartID < b.kursartID) {
                return -1;
            }
            if (a.kursartID > b.kursartID) {
                return 1;
            }
            @NotNull GostFach aFach = this._faecherManager.getOrException(a.fachID);
            @NotNull GostFach bFach = this._faecherManager.getOrException(b.fachID);
            return GostFaecherManager.comp.compare(aFach, bFach);
        };
        return comp;
    }

    private void ergebnisAddOhneSortierung(@NotNull GostBlockungsergebnisListeneintrag ergebnis) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("pErgebnis.id", ergebnis.id);
        DeveloperNotificationException.ifInvalidID("pErgebnis.blockungID", ergebnis.blockungID);
        DeveloperNotificationException.ifNull("GostHalbjahr.fromID(" + ergebnis.gostHalbjahr + ")", GostHalbjahr.fromID(ergebnis.gostHalbjahr));
        DeveloperNotificationException.ifMapPutOverwrites(this._map_idErgebnis_Ergebnis, ergebnis.id, ergebnis);
        this._daten.ergebnisse.add(ergebnis);
    }

    public void ergebnisAdd(@NotNull GostBlockungsergebnisListeneintrag ergebnis) throws DeveloperNotificationException {
        this.ergebnisAddOhneSortierung(ergebnis);
        this._daten.ergebnisse.sort(this._compErgebnisse);
    }

    public void ergebnisAddListe(@NotNull @NotNull List<@NotNull GostBlockungsergebnisListeneintrag> ergebnismenge) throws DeveloperNotificationException {
        for (GostBlockungsergebnisListeneintrag ergebnis : ergebnismenge) {
            this.ergebnisAddOhneSortierung(ergebnis);
        }
        this._daten.ergebnisse.sort(this._compErgebnisse);
    }

    @NotNull
    public GostBlockungsergebnisListeneintrag ergebnisGet(long idErgebnis) throws DeveloperNotificationException {
        GostBlockungsergebnisListeneintrag e = this._map_idErgebnis_Ergebnis.get(idErgebnis);
        return DeveloperNotificationException.ifNull("Es wurde kein Listeneintrag mit ID(" + idErgebnis + ") gefunden!", e);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisListeneintrag> ergebnisGetListeSortiertNachBewertung() {
        @NotNull ArrayList<@NotNull GostBlockungsergebnisListeneintrag> result = new ArrayList<GostBlockungsergebnisListeneintrag>(this._daten.ergebnisse);
        return result;
    }

    public void ergebnisRemoveByID(long idErgebnis) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisListeneintrag e = this.ergebnisGet(idErgebnis);
        this._daten.ergebnisse.remove(e);
        this._map_idErgebnis_Ergebnis.remove(idErgebnis);
    }

    public void ergebnisRemove(@NotNull GostBlockungsergebnisListeneintrag ergebnis) throws DeveloperNotificationException {
        this.ergebnisRemoveByID(ergebnis.id);
    }

    public void ergebnisUpdateBewertung(@NotNull GostBlockungsergebnis ergebnis) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("pErgebnis.id", ergebnis.id);
        DeveloperNotificationException.ifInvalidID("pErgebnis.blockungID", ergebnis.blockungID);
        for (GostBlockungsergebnisListeneintrag eintrag : this._daten.ergebnisse) {
            if (eintrag.id != ergebnis.id) continue;
            eintrag.bewertung = ergebnis.bewertung;
        }
        this._daten.ergebnisse.sort(this._compErgebnisse);
    }

    public int ergebnisGetBewertung1Wert(long idErgebnis) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisListeneintrag e = this.ergebnisGet(idErgebnis);
        int summe = 0;
        summe += e.bewertung.anzahlKurseNichtZugeordnet;
        return summe += e.bewertung.regelVerletzungen.size();
    }

    public double ergebnisGetBewertung1Intervall(long idErgebnis) throws DeveloperNotificationException {
        double summe = this.ergebnisGetBewertung1Wert(idErgebnis);
        return 1.0 - 1.0 / (0.25 * summe + 1.0);
    }

    public int ergebnisGetBewertung2Wert(long idErgebnis) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisListeneintrag e = this.ergebnisGet(idErgebnis);
        int summe = 0;
        summe += e.bewertung.anzahlSchuelerNichtZugeordnet;
        return summe += e.bewertung.anzahlSchuelerKollisionen;
    }

    public double ergebnisGetBewertung2Intervall(long idErgebnis) throws DeveloperNotificationException {
        double summe = this.ergebnisGetBewertung2Wert(idErgebnis);
        return 1.0 - 1.0 / (0.25 * summe + 1.0);
    }

    public int ergebnisGetBewertung3Wert(long idErgebnis) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisListeneintrag e = this.ergebnisGet(idErgebnis);
        return e.bewertung.kursdifferenzMax;
    }

    public double ergebnisGetBewertung3Intervall(long idErgebnis) throws DeveloperNotificationException {
        int wert = this.ergebnisGetBewertung3Wert(idErgebnis);
        if (wert > 0) {
            --wert;
        }
        return 1.0 - 1.0 / (0.25 * (double)wert + 1.0);
    }

    public int ergebnisGetBewertung4Wert(long idErgebnis) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisListeneintrag e = this.ergebnisGet(idErgebnis);
        return e.bewertung.anzahlKurseMitGleicherFachartProSchiene;
    }

    public double ergebnisGetBewertung4Intervall(long idErgebnis) throws DeveloperNotificationException {
        int wert = this.ergebnisGetBewertung4Wert(idErgebnis);
        return 1.0 - 1.0 / (0.25 * (double)wert + 1.0);
    }

    private void kursAddKursOhneSortierung(@NotNull GostBlockungKurs kurs) throws DeveloperNotificationException {
        int nSchienen = this.schieneGetAnzahl();
        DeveloperNotificationException.ifInvalidID("pKurs.id", kurs.id);
        DeveloperNotificationException.ifNull("_faecherManager.get(pKurs.fach_id)", this._faecherManager.get(kurs.fach_id));
        DeveloperNotificationException.ifNull("GostKursart.fromIDorNull(pKurs.kursart)", GostKursart.fromIDorNull(kurs.kursart));
        DeveloperNotificationException.ifSmaller("pKurs.wochenstunden", kurs.wochenstunden, 0L);
        DeveloperNotificationException.ifSmaller("pKurs.anzahlSchienen", kurs.anzahlSchienen, 1L);
        DeveloperNotificationException.ifGreater("pKurs.anzahlSchienen", kurs.anzahlSchienen, nSchienen);
        DeveloperNotificationException.ifSmaller("pKurs.nummer", kurs.nummer, 1L);
        DeveloperNotificationException.ifMapPutOverwrites(this._map_idKurs_kurs, kurs.id, kurs);
        DeveloperNotificationException.ifListAddsDuplicate("_kurse_sortiert_fach_kursart_kursnummer", this._list_kurse_sortiert_fach_kursart_kursnummer, kurs);
        DeveloperNotificationException.ifListAddsDuplicate("_kurse_sortiert_kursart_fach_kursnummer", this._list_kurse_sortiert_kursart_fach_kursnummer, kurs);
        List<@NotNull GostBlockungKurs> liste = Map2DUtils.getOrCreateArrayList(this._map2d_idFach_idKursart_kurse, kurs.fach_id, kurs.kursart);
        liste.add(kurs);
        liste.sort(_compKursnummer);
        this._daten.kurse.add(kurs);
    }

    public void kursAdd(@NotNull GostBlockungKurs kurs) throws DeveloperNotificationException {
        this.kursAddKursOhneSortierung(kurs);
        this._list_kurse_sortiert_fach_kursart_kursnummer.sort(this._compKurs_fach_kursart_kursnummer);
        this._list_kurse_sortiert_kursart_fach_kursnummer.sort(this._compKurs_kursart_fach_kursnummer);
    }

    public void kursAddListe(@NotNull @NotNull List<@NotNull GostBlockungKurs> kursmenge) throws DeveloperNotificationException {
        for (GostBlockungKurs gKurs : kursmenge) {
            this.kursAddKursOhneSortierung(gKurs);
        }
        this._list_kurse_sortiert_fach_kursart_kursnummer.sort(this._compKurs_fach_kursart_kursnummer);
        this._list_kurse_sortiert_kursart_fach_kursnummer.sort(this._compKurs_kursart_fach_kursnummer);
    }

    public boolean kursGetExistiert(long idKurs) {
        return this._map_idKurs_kurs.get(idKurs) != null;
    }

    public int kursGetAnzahl() {
        return this._map_idKurs_kurs.size();
    }

    @NotNull
    public String kursGetName(long idKurs) throws DeveloperNotificationException {
        @NotNull GostBlockungKurs kurs = this.kursGet(idKurs);
        @NotNull GostFach gFach = this._faecherManager.getOrException(kurs.fach_id);
        @NotNull String sSuffix = kurs.suffix.equals("") ? "" : "-" + kurs.suffix;
        return gFach.kuerzelAnzeige + "-" + GostKursart.fromID((int)kurs.kursart).kuerzel + kurs.nummer + sSuffix;
    }

    @NotNull
    public String kursGetNameOhneSuffix(long idKurs) throws DeveloperNotificationException {
        @NotNull GostBlockungKurs kurs = this.kursGet(idKurs);
        @NotNull GostFach gFach = this._faecherManager.getOrException(kurs.fach_id);
        return gFach.kuerzelAnzeige + "-" + GostKursart.fromID((int)kurs.kursart).kuerzel + kurs.nummer;
    }

    @NotNull
    public GostBlockungKurs kursGet(long idKurs) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_idKurs_kurs, idKurs);
    }

    public GostBlockungKursLehrer kursGetLehrkraftMitNummer(long idKurs, int reihenfolgeNr) throws DeveloperNotificationException {
        for (GostBlockungKursLehrer lehrkraft : this.kursGetLehrkraefteSortiert(idKurs)) {
            if (lehrkraft.reihenfolge != reihenfolgeNr) continue;
            return lehrkraft;
        }
        throw new DeveloperNotificationException("Es gibt im Kurs " + idKurs + " keine Lehrkraft mit ReihenfolgeNr. " + reihenfolgeNr + "!");
    }

    public GostBlockungKursLehrer kursGetLehrkraftMitID(long idKurs, int idLehrkraft) throws DeveloperNotificationException {
        for (GostBlockungKursLehrer lehrkraft : this.kursGetLehrkraefteSortiert(idKurs)) {
            if (lehrkraft.id != (long)idLehrkraft) continue;
            return lehrkraft;
        }
        throw new DeveloperNotificationException("Es gibt im Kurs " + idKurs + " keine Lehrkraft mit ID " + idLehrkraft + "!");
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungKurs> kursGetListeSortiertNachFachKursartNummer() {
        return this._list_kurse_sortiert_fach_kursart_kursnummer;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungKurs> kursGetListeSortiertNachKursartFachNummer() {
        return this._list_kurse_sortiert_kursart_fach_kursnummer;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungKurs> kursGetListeByFachUndKursart(long idFach, int idKursart) {
        List<@NotNull GostBlockungKurs> liste = this._map2d_idFach_idKursart_kurse.getOrNull(idFach, idKursart);
        if (liste == null) {
            return new ArrayList<GostBlockungKurs>();
        }
        liste.sort(_compKursnummer);
        return liste;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungKursLehrer> kursGetLehrkraefteSortiert(long idKurs) throws DeveloperNotificationException {
        return this.kursGet((long)idKurs).lehrer;
    }

    public boolean kursGetIsRemoveAllowed(long idKurs) throws DeveloperNotificationException {
        return this._map_idKurs_kurs.get(idKurs) != null && this.getIstBlockungsVorlage();
    }

    public boolean kursGetIstVerbotenInSchiene(long idKurs, long idSchiene) throws DeveloperNotificationException {
        if (this.kursGetHatSperrungInSchiene(idKurs, idSchiene)) {
            return true;
        }
        int nummer = this.schieneGet((long)idSchiene).nummer;
        int kursart = this.kursGet((long)idKurs).kursart;
        for (GostBlockungRegel regel : this.regelGetListeOfTyp(GostKursblockungRegelTyp.KURSART_ALLEIN_IN_SCHIENEN_VON_BIS)) {
            if (!((long)nummer >= regel.parameter.get(1) && (long)nummer <= regel.parameter.get(2) ? regel.parameter.get(0) != (long)kursart : regel.parameter.get(0) == (long)kursart)) continue;
            return true;
        }
        for (GostBlockungRegel regel : this.regelGetListeOfTyp(GostKursblockungRegelTyp.KURSART_SPERRE_SCHIENEN_VON_BIS)) {
            if ((long)nummer < regel.parameter.get(1) || (long)nummer > regel.parameter.get(2) || regel.parameter.get(0) != (long)kursart) continue;
            return true;
        }
        return false;
    }

    public boolean kursGetHatSperrungInSchiene(long idKurs, long idSchiene) throws DeveloperNotificationException {
        int nrSchiene = this.schieneGet((long)idSchiene).nummer;
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE.typ, idKurs, nrSchiene});
        return this._map_multikey_regeln.containsKey(key);
    }

    @NotNull
    public GostBlockungRegel kursGetRegelGesperrtInSchiene(long idKurs, long idSchiene) throws DeveloperNotificationException {
        int nrSchiene = this.schieneGet((long)idSchiene).nummer;
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE.typ, idKurs, nrSchiene});
        return DeveloperNotificationException.ifNull("Kurs " + idKurs + " ist nicht gesperrt in Schiene " + idSchiene + "!", this._map_multikey_regeln.get(key));
    }

    public GostBlockungRegel kursGetRegelDummySchuelerOrNull(long idKurs) {
        for (GostBlockungRegel regel : this.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_MIT_DUMMY_SUS_AUFFUELLEN)) {
            if (regel.parameter.get(0) != idKurs) continue;
            return regel;
        }
        return null;
    }

    public boolean kursGetHatFixierungInSchiene(long idKurs, long idSchiene) throws DeveloperNotificationException {
        int nrSchiene = this.schieneGet((long)idSchiene).nummer;
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ, idKurs, nrSchiene});
        return this._map_multikey_regeln.containsKey(key);
    }

    @NotNull
    public GostBlockungRegel kursGetRegelFixierungInSchiene(long idKurs, long idSchiene) throws DeveloperNotificationException {
        int nrSchiene = this.schieneGet((long)idSchiene).nummer;
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ, idKurs, nrSchiene});
        return DeveloperNotificationException.ifNull("Kurs " + idKurs + " ist nicht fixiert in Schiene " + idSchiene + "!", this._map_multikey_regeln.get(key));
    }

    public void kursRemoveByID(long idKurs) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Ein L\u00f6schen des Kurses ist nur bei einer Blockungsvorlage erlaubt!", !this.getIstBlockungsVorlage());
        @NotNull GostBlockungKurs kurs = this.kursGet(idKurs);
        this._list_kurse_sortiert_fach_kursart_kursnummer.remove(kurs);
        this._list_kurse_sortiert_kursart_fach_kursnummer.remove(kurs);
        Map2DUtils.removeFromListAndTrimOrException(this._map2d_idFach_idKursart_kurse, kurs.fach_id, kurs.kursart, kurs);
        DeveloperNotificationException.ifMapRemoveFailes(this._map_idKurs_kurs, idKurs);
        this._daten.kurse.remove(kurs);
    }

    public void kursRemove(@NotNull GostBlockungKurs kurs) throws DeveloperNotificationException {
        this.kursRemoveByID(kurs.id);
    }

    public void kursAddLehrkraft(long idKurs, @NotNull GostBlockungKursLehrer neueLehrkraft) throws DeveloperNotificationException {
        @NotNull GostBlockungKurs kurs = this.kursGet(idKurs);
        @NotNull List<@NotNull GostBlockungKursLehrer> listOfLehrer = kurs.lehrer;
        for (GostBlockungKursLehrer lehrkraft : listOfLehrer) {
            DeveloperNotificationException.ifTrue("patchOfKursAddLehrkraft: Der Kurs hat bereits eine Lehrkraft mit ID " + lehrkraft.id, lehrkraft.id == neueLehrkraft.id);
            DeveloperNotificationException.ifTrue("patchOfKursAddLehrkraft: Der Kurs hat bereits eine Lehrkraft mit Reihenfolge " + lehrkraft.reihenfolge, lehrkraft.reihenfolge == neueLehrkraft.reihenfolge);
        }
        listOfLehrer.add(neueLehrkraft);
        listOfLehrer.sort(_compLehrkraefte);
    }

    public void kursRemoveLehrkraft(long idKurs, long idAlteLehrkraft) throws DeveloperNotificationException {
        @NotNull GostBlockungKurs kurs = this.kursGet(idKurs);
        @NotNull List<@NotNull GostBlockungKursLehrer> listOfLehrer = kurs.lehrer;
        for (int i = 0; i < listOfLehrer.size(); ++i) {
            if (listOfLehrer.get((int)i).id != idAlteLehrkraft) continue;
            listOfLehrer.remove(listOfLehrer.get(i));
            return;
        }
        throw new DeveloperNotificationException("patchOfKursRemoveLehrkraft: Kurs (" + idKurs + ") hat keine Lehrkraft (" + idAlteLehrkraft + ")!");
    }

    public boolean kursGetLehrkraftMitNummerExists(long idKurs, int reihenfolgeNr) {
        for (GostBlockungKursLehrer lehrkraft : this.kursGetLehrkraefteSortiert(idKurs)) {
            if (lehrkraft.reihenfolge != reihenfolgeNr) continue;
            return true;
        }
        return false;
    }

    public boolean kursGetLehrkraftMitIDExists(long idKurs, int idLehrkraft) {
        for (GostBlockungKursLehrer lehrkraft : this.kursGetLehrkraefteSortiert(idKurs)) {
            if (lehrkraft.id != (long)idLehrkraft) continue;
            return true;
        }
        return false;
    }

    public void kursSetSuffix(long idKurs, @NotNull String suffix) throws DeveloperNotificationException {
        this.kursGet((long)idKurs).suffix = suffix;
    }

    private void schieneAddOhneSortierung(@NotNull GostBlockungSchiene schiene) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("GostBlockungSchiene.id", schiene.id);
        DeveloperNotificationException.ifTrue("GostBlockungSchiene.bezeichnung darf nicht leer sein!", "".equals(schiene.bezeichnung));
        DeveloperNotificationException.ifSmaller("GostBlockungSchiene.nummer", schiene.nummer, 1L);
        DeveloperNotificationException.ifSmaller("GostBlockungSchiene.wochenstunden", schiene.wochenstunden, 1L);
        DeveloperNotificationException.ifMapContains("mapSchienen", this._map_idSchiene_schiene, schiene.id);
        this._map_idSchiene_schiene.put(schiene.id, schiene);
        this._daten.schienen.add(schiene);
    }

    public void schieneAdd(@NotNull GostBlockungSchiene schiene) throws DeveloperNotificationException {
        this.schieneAddOhneSortierung(schiene);
        this._daten.schienen.sort(_compSchiene);
    }

    public void schieneAddListe(@NotNull @NotNull List<@NotNull GostBlockungSchiene> schienenmenge) throws DeveloperNotificationException {
        for (GostBlockungSchiene schiene : schienenmenge) {
            this.schieneAddOhneSortierung(schiene);
        }
        this._daten.schienen.sort(_compSchiene);
    }

    @NotNull
    public GostBlockungSchiene schieneGet(long idSchiene) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifNull("_mapSchienen.get(" + idSchiene + ")", this._map_idSchiene_schiene.get(idSchiene));
    }

    public boolean schieneGetExistiert(long idSchiene) {
        return this._map_idSchiene_schiene.get(idSchiene) != null;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungSchiene> schieneGetListe() {
        return this._daten.schienen;
    }

    public boolean schieneGetIsRemoveAllowed(long idSchiene) throws DeveloperNotificationException {
        return this.schieneGet(idSchiene) != null && this.getIstBlockungsVorlage();
    }

    public void schieneRemoveByID(long idSchiene) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Ein L\u00f6schen einer Schiene ist nur bei einer Blockungsvorlage erlaubt!", !this.getIstBlockungsVorlage());
        @NotNull GostBlockungSchiene schieneR = this.schieneGet(idSchiene);
        this._map_idSchiene_schiene.remove(idSchiene);
        this._daten.schienen.remove(schieneR);
        for (GostBlockungSchiene schiene : this._daten.schienen) {
            if (schiene.nummer <= schieneR.nummer) continue;
            --schiene.nummer;
        }
        for (int index = 0; index < this._daten.schienen.size(); ++index) {
            DeveloperNotificationException.ifTrue("Schiene am Index " + index + " hat nicht Nr. " + (index + 1) + "!", this._daten.schienen.get((int)index).nummer != index + 1);
        }
        Iterator<@NotNull GostBlockungRegel> iRegel = this._daten.regeln.iterator();
        if (iRegel == null) {
            return;
        }
        while (iRegel.hasNext()) {
            @NotNull GostBlockungRegel r = iRegel.next();
            long[] a = GostKursblockungRegelTyp.getNeueParameterBeiSchienenLoeschung(r, schieneR.nummer);
            if (a == null) {
                iRegel.remove();
                continue;
            }
            for (int i = 0; i < a.length; ++i) {
                r.parameter.set(i, a[i]);
            }
        }
    }

    public void schieneRemove(@NotNull GostBlockungSchiene schiene) throws DeveloperNotificationException {
        this.schieneRemoveByID(schiene.id);
    }

    public int schieneGetAnzahl() {
        return this._map_idSchiene_schiene.size();
    }

    public static int schieneGetDefaultAnzahl(@NotNull GostHalbjahr halbjahr) {
        return halbjahr.id < 2 ? 13 : 11;
    }

    private void regelAddOhneSortierung(@NotNull GostBlockungRegel regel) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("Regel.id", regel.id);
        @NotNull GostKursblockungRegelTyp typ = GostKursblockungRegelTyp.fromTyp(regel.typ);
        DeveloperNotificationException.ifTrue("Der Typ(" + regel.typ + ") der Regel(" + regel.id + ") ist unbekannt!", typ == GostKursblockungRegelTyp.UNDEFINIERT);
        @NotNull LongArrayKey multikey = GostBlockungsdatenManager.regelToMultikey(regel);
        DeveloperNotificationException.ifMapPutOverwrites(this._map_idRegel_regel, regel.id, regel);
        MapUtils.getOrCreateArrayList(this._map_regeltyp_regeln, typ).add(regel);
        this._map_multikey_regeln.put(multikey, regel);
        this._daten.regeln.add(regel);
    }

    public void regelAdd(@NotNull GostBlockungRegel regel) throws DeveloperNotificationException {
        this.regelAddOhneSortierung(regel);
        this._daten.regeln.sort(_compRegel);
    }

    public void regelAddListe(@NotNull @NotNull List<@NotNull GostBlockungRegel> regelmenge) throws DeveloperNotificationException {
        for (GostBlockungRegel regel : regelmenge) {
            this.regelAddOhneSortierung(regel);
        }
        this._daten.regeln.sort(_compRegel);
    }

    public int regelGetAnzahl() {
        return this._map_idRegel_regel.size();
    }

    @NotNull
    public GostBlockungRegel regelGet(long idRegel) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifNull("_mapRegeln.get(" + idRegel + ")", this._map_idRegel_regel.get(idRegel));
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetListe() {
        return this._daten.regeln;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetListeOfTyp(@NotNull GostKursblockungRegelTyp typ) {
        return MapUtils.getOrCreateArrayList(this._map_regeltyp_regeln, typ);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetListeToggleSperrung(@NotNull @NotNull List<@NotNull GostBlockungKurs> list, @NotNull GostBlockungKurs kursA, @NotNull GostBlockungKurs kursB, @NotNull GostBlockungSchiene schieneA, @NotNull GostBlockungSchiene schieneB) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> regeln = new ArrayList<GostBlockungRegel>();
        boolean aktiv = false;
        int min = Math.min(schieneA.nummer, schieneB.nummer);
        int max = Math.max(schieneA.nummer, schieneB.nummer);
        for (GostBlockungKurs kurs : list) {
            if (kurs == kursA || kurs == kursB) {
                boolean bl = aktiv = !aktiv;
            }
            if (!aktiv) continue;
            for (int nr = min; nr <= max; ++nr) {
                regeln.add(this.regelGetRegelOrDummyKursGesperrtInSchiene(kurs.id, nr));
            }
        }
        return regeln;
    }

    @NotNull
    public GostBlockungRegel regelGetRegelOrDummyKursGesperrtInSchiene(long idKurs, int nrSchiene) {
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE.typ, idKurs, nrSchiene});
        GostBlockungRegel regel = this._map_multikey_regeln.get(key);
        if (regel != null) {
            return regel;
        }
        @NotNull GostBlockungRegel regelDummy = new GostBlockungRegel();
        regelDummy.id = -1L;
        regelDummy.typ = GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE.typ;
        regelDummy.parameter.add(idKurs);
        regelDummy.parameter.add(Long.valueOf(nrSchiene));
        return regelDummy;
    }

    public boolean regelGetExistiert(long idRegel) {
        return this._map_idRegel_regel.get(idRegel) != null;
    }

    public boolean regelGetIsRemoveAllowed(long idRegel) throws DeveloperNotificationException {
        return this._map_idRegel_regel.containsKey(idRegel) && this.getIstBlockungsVorlage();
    }

    public void regelRemoveByID(long idRegel) throws DeveloperNotificationException, UserNotificationException {
        UserNotificationException.ifTrue("Ein L\u00f6schen einer Regel ist nur bei einer Blockungsvorlage erlaubt!", !this.getIstBlockungsVorlage());
        @NotNull GostBlockungRegel regel = this.regelGet(idRegel);
        @NotNull GostKursblockungRegelTyp typ = GostKursblockungRegelTyp.fromTyp(regel.typ);
        @NotNull LongArrayKey multikey = GostBlockungsdatenManager.regelToMultikey(regel);
        this._map_idRegel_regel.remove(idRegel);
        MapUtils.getOrCreateArrayList(this._map_regeltyp_regeln, typ).remove(regel);
        this._map_multikey_regeln.remove(multikey);
        this._daten.regeln.remove(regel);
    }

    public void regelRemoveListe(@NotNull @NotNull List<@NotNull GostBlockungRegel> regelmenge) throws DeveloperNotificationException {
        for (GostBlockungRegel regel : regelmenge) {
            this.regelRemoveByID(regel.id);
        }
    }

    @NotNull
    private static LongArrayKey regelToMultikey(@NotNull GostBlockungRegel regel) {
        int size = regel.parameter.size();
        long[] keys = new long[size + 1];
        keys[0] = regel.typ;
        for (int i = 1; i <= size; ++i) {
            keys[i] = regel.parameter.get(i - 1);
        }
        return new LongArrayKey(keys);
    }

    public void regelRemove(@NotNull GostBlockungRegel regel) throws DeveloperNotificationException, UserNotificationException {
        this.regelRemoveByID(regel.id);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursart> fachGetMengeKursarten(long idFach) {
        @NotNull HashSet<@NotNull Integer> idKursarten = new HashSet<Integer>();
        if (this._map2d_idFach_idKursart_kurse.containsKey1(idFach)) {
            idKursarten.addAll(this._map2d_idFach_idKursart_kurse.getKeySetOf(idFach));
        }
        if (this._map2d_idFach_idKursart_fachwahlen.containsKey1(idFach)) {
            idKursarten.addAll(this._map2d_idFach_idKursart_fachwahlen.getKeySetOf(idFach));
        }
        @NotNull ArrayList<@NotNull GostKursart> list = new ArrayList<GostKursart>();
        for (GostKursart kursart : GostKursart.values()) {
            if (!idKursarten.contains(kursart.id)) continue;
            list.add(kursart);
        }
        return list;
    }

    public void fachwahlAdd(@NotNull GostFachwahl fachwahl) throws DeveloperNotificationException {
        DeveloperNotificationException.ifMap2DPutOverwrites(this._map2d_idSchueler_idFach_fachwahl, fachwahl.schuelerID, fachwahl.fachID, fachwahl);
        @NotNull List<@NotNull GostFachwahl> fachwahlenDesSchuelers = MapUtils.getOrCreateArrayList(this._map_idSchueler_fachwahlen, fachwahl.schuelerID);
        fachwahlenDesSchuelers.add(fachwahl);
        fachwahlenDesSchuelers.sort(this._compFachwahlen);
        long fachartID = GostKursart.getFachartIDByFachwahl(fachwahl);
        this.fachwahlGetListeOfFachart(fachartID).add(fachwahl);
        Map2DUtils.getOrCreateArrayList(this._map2d_idFach_idKursart_fachwahlen, fachwahl.fachID, fachwahl.kursartID).add(fachwahl);
        this._daten.fachwahlen.add(fachwahl);
    }

    public void fachwahlAddListe(@NotNull @NotNull List<@NotNull GostFachwahl> fachwahlmenge) throws DeveloperNotificationException {
        for (GostFachwahl gFachwahl : fachwahlmenge) {
            this.fachwahlAdd(gFachwahl);
        }
    }

    public int fachwahlGetAnzahl() {
        return this._daten.fachwahlen.size();
    }

    @NotNull
    public String fachwahlGetName(@NotNull GostFachwahl fachwahl) throws DeveloperNotificationException {
        @NotNull GostFach gFach = this._faecherManager.getOrException(fachwahl.fachID);
        @NotNull GostKursart gKursart = GostKursart.fromID(fachwahl.kursartID);
        return gFach.kuerzelAnzeige + "-" + gKursart.kuerzel;
    }

    @NotNull
    public @NotNull List<@NotNull GostFachwahl> fachwahlGetListeOfFachart(long idFachart) {
        return MapUtils.getOrCreateArrayList(this._map_idFachart_fachwahlen, idFachart);
    }

    public int fachwahlGetAnzahlVerwendeterKursarten() {
        @NotNull HashSet<@NotNull Integer> setKursartenIDs = new HashSet<Integer>();
        for (GostFachwahl fachwahl : this._daten.fachwahlen) {
            setKursartenIDs.add(fachwahl.kursartID);
        }
        return setKursartenIDs.size();
    }

    private void schuelerAddOhneSortierung(@NotNull Schueler schueler) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("pSchueler.id", schueler.id);
        DeveloperNotificationException.ifSmaller("pSchueler.geschlecht", schueler.geschlecht, 0L);
        DeveloperNotificationException.ifMapPutOverwrites(this._map_idSchueler_schueler, schueler.id, schueler);
        if (!this._map_idSchueler_fachwahlen.containsKey(schueler.id)) {
            this._map_idSchueler_fachwahlen.put(schueler.id, new ArrayList());
        }
        this._daten.schueler.add(schueler);
    }

    public void schuelerAdd(@NotNull Schueler schueler) throws DeveloperNotificationException {
        this.schuelerAddOhneSortierung(schueler);
        this._daten.schueler.sort(_compSchueler);
    }

    public void schuelerAddListe(@NotNull @NotNull List<@NotNull Schueler> schuelermenge) throws DeveloperNotificationException {
        for (Schueler schueler : schuelermenge) {
            this.schuelerAddOhneSortierung(schueler);
        }
        this._daten.schueler.sort(_compSchueler);
    }

    public int schuelerGetAnzahlMitMindestensEinerFachwahl() {
        HashSet<@NotNull Long> setSchuelerIDs = new HashSet<Long>();
        for (GostFachwahl fachwahl : this._daten.fachwahlen) {
            setSchuelerIDs.add(fachwahl.schuelerID);
        }
        return setSchuelerIDs.size();
    }

    public int schuelerGetAnzahl() {
        return this._daten.schueler.size();
    }

    @NotNull
    public Schueler schuelerGet(long idSchueler) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifNull("_map_id_schueler.get(" + idSchueler + ")", this._map_idSchueler_schueler.get(idSchueler));
    }

    @NotNull
    public @NotNull List<@NotNull Schueler> schuelerGetListe() {
        return this._daten.schueler;
    }

    @NotNull
    public GostKursart schuelerGetOfFachKursart(long idSchueler, long idFach) throws DeveloperNotificationException {
        @NotNull GostFachwahl fachwahl = this.schuelerGetOfFachFachwahl(idSchueler, idFach);
        return GostKursart.fromID(fachwahl.kursartID);
    }

    @NotNull
    public GostFachwahl schuelerGetOfFachFachwahl(long idSchueler, long idFach) throws DeveloperNotificationException {
        return this._map2d_idSchueler_idFach_fachwahl.getNonNullOrException(idSchueler, idFach);
    }

    public boolean schuelerGetHatFach(long idSchueler, long idFach) throws DeveloperNotificationException {
        return this._map2d_idSchueler_idFach_fachwahl.contains(idSchueler, idFach);
    }

    public boolean schuelerGetHatFachart(long idSchueler, long idFach, int idKursart) throws DeveloperNotificationException {
        if (!this._map2d_idSchueler_idFach_fachwahl.contains(idSchueler, idFach)) {
            return false;
        }
        return this._map2d_idSchueler_idFach_fachwahl.getNonNullOrException((Long)Long.valueOf((long)idSchueler), (Long)Long.valueOf((long)idFach)).kursartID == idKursart;
    }

    @NotNull
    public @NotNull List<@NotNull GostFachwahl> schuelerGetListeOfFachwahlen(long pSchuelerID) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifNull("_map_schuelerID_fachwahlen.get(" + pSchuelerID + ")", this._map_idSchueler_fachwahlen.get(pSchuelerID));
    }

    public boolean schuelerGetIstVerbotenInKurs(long idSchueler, long idKurs) throws DeveloperNotificationException {
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.SCHUELER_VERBIETEN_IN_KURS.typ, idSchueler, idKurs});
        return this._map_multikey_regeln.containsKey(key);
    }

    @NotNull
    public GostBlockungRegel schuelerGetRegelVerbotenInKurs(long idSchueler, long idKurs) throws DeveloperNotificationException {
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.SCHUELER_VERBIETEN_IN_KURS.typ, idSchueler, idKurs});
        return DeveloperNotificationException.ifNull("Sch\u00fcler " + idSchueler + " ist nicht verboten in Kurs " + idKurs + "!", this._map_multikey_regeln.get(key));
    }

    public boolean schuelerGetIstFixiertInKurs(long idSchueler, long idKurs) throws DeveloperNotificationException {
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ, idSchueler, idKurs});
        return this._map_multikey_regeln.containsKey(key);
    }

    @NotNull
    public GostBlockungRegel schuelerGetRegelFixiertInKurs(long idSchueler, long idKurs) throws DeveloperNotificationException {
        @NotNull LongArrayKey key = new LongArrayKey(new long[]{GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ, idSchueler, idKurs});
        return DeveloperNotificationException.ifNull("Sch\u00fcler " + idSchueler + " ist nicht fixiert in Kurs " + idKurs + "!", this._map_multikey_regeln.get(key));
    }

    public long getID() {
        return this._daten.id;
    }

    public void setID(long pBlockungsID) throws DeveloperNotificationException {
        DeveloperNotificationException.ifInvalidID("pBlockungsID", pBlockungsID);
        this._daten.id = pBlockungsID;
    }

    public long getMaxTimeMillis() {
        return this._maxTimeMillis;
    }

    public void setMaxTimeMillis(long pZeit) {
        this._maxTimeMillis = pZeit;
    }

    @NotNull
    public String getName() {
        return this._daten.name;
    }

    public void setName(@NotNull String pName) throws UserNotificationException {
        UserNotificationException.ifTrue("Ein leerer Name ist f\u00fcr die Blockung nicht zul\u00e4ssig.", "".equals(pName));
        this._daten.name = pName;
    }

    @NotNull
    public GostHalbjahr getHalbjahr() {
        return GostHalbjahr.fromIDorException(this._daten.gostHalbjahr);
    }

    public void setHalbjahr(@NotNull GostHalbjahr pHalbjahr) {
        this._daten.gostHalbjahr = pHalbjahr.id;
    }

    public boolean getIstBlockungsVorlage() {
        return this._daten.ergebnisse.size() == 1;
    }

    public int getFaecherAnzahl() {
        return this._faecherManager.faecher().size();
    }

    @NotNull
    public GostFaecherManager faecherManager() {
        return this._faecherManager;
    }

    @NotNull
    public GostBlockungsdaten daten() {
        return this._daten;
    }

    @NotNull
    public @NotNull Comparator<@NotNull GostBlockungKurs> getComparatorKurs_kursart_fach_kursnummer() {
        return this._compKurs_kursart_fach_kursnummer;
    }

    @NotNull
    public @NotNull Comparator<@NotNull GostBlockungKurs> getComparatorKurs_fach_kursart_kursnummer() {
        return this._compKurs_fach_kursart_kursnummer;
    }
}

