/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostBlockungKurs;
import de.svws_nrw.core.data.gost.GostBlockungKursLehrer;
import de.svws_nrw.core.data.gost.GostBlockungRegel;
import de.svws_nrw.core.data.gost.GostBlockungSchiene;
import de.svws_nrw.core.data.gost.GostBlockungsergebnis;
import de.svws_nrw.core.data.gost.GostBlockungsergebnisKurs;
import de.svws_nrw.core.data.gost.GostBlockungsergebnisSchiene;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungInput;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungInputKurs;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungOutput;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungOutputFachwahlZuKurs;
import de.svws_nrw.core.data.schueler.Schueler;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.kursblockung.SchuelerblockungAlgorithmus;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.types.Geschlecht;
import de.svws_nrw.core.types.SchuelerStatus;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.gost.GostSchriftlichkeit;
import de.svws_nrw.core.types.kursblockung.GostKursblockungRegelTyp;
import de.svws_nrw.core.utils.CollectionUtils;
import de.svws_nrw.core.utils.ListUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.gost.GostBlockungsdatenManager;
import de.svws_nrw.core.utils.gost.GostFaecherManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GostBlockungsergebnisManager {
    @NotNull
    private final GostBlockungsdatenManager _parent;
    @NotNull
    private GostBlockungsergebnis _ergebnis = new GostBlockungsergebnis();
    @NotNull
    private final @NotNull Map<@NotNull Integer, @NotNull GostBlockungsergebnisSchiene> _map_schienenNr_schiene = new HashMap<Integer, GostBlockungsergebnisSchiene>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostBlockungsergebnisSchiene> _map_schienenID_schiene = new HashMap<Long, GostBlockungsergebnisSchiene>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Integer> _map_schienenID_schuelerAnzahl = new HashMap<Long, Integer>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Integer> _map_schienenID_kollisionen = new HashMap<Long, Integer>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull GostBlockungsergebnisKurs>> _map2D_schienenID_fachartID_kurse = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisKurs>> _map_schuelerID_kurse = new HashMap<Long, Set<GostBlockungsergebnisKurs>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisKurs>> _map_schuelerID_ungueltige_kurse = new HashMap<Long, Set<GostBlockungsergebnisKurs>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Integer> _map_schuelerID_kollisionen = new HashMap<Long, Integer>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, GostBlockungsergebnisKurs> _map2D_schuelerID_fachID_kurs = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisKurs>> _map2D_schuelerID_schienenID_kurse = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisSchiene>> _map_kursID_schienen = new HashMap<Long, Set<GostBlockungsergebnisSchiene>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostBlockungsergebnisKurs> _map_kursID_kurs = new HashMap<Long, GostBlockungsergebnisKurs>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Integer> _map_kursID_dummySuS = new HashMap<Long, Integer>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Set<@NotNull Long>> _map_kursID_schuelerIDs = new HashMap<Long, Set<Long>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostBlockungsergebnisKurs>> _map_fachID_kurse = new HashMap<Long, List<GostBlockungsergebnisKurs>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull Integer> _map_fachartID_kursdifferenz = new HashMap<Long, Integer>();
    @NotNull
    private final @NotNull List<@NotNull Long> _fachartmenge_sortiert = new ArrayList<Long>();
    private int _fachartmenge_sortierung = 1;
    @NotNull
    private final @NotNull Comparator<@NotNull Long> _fachartComparator_kursart_fach;
    @NotNull
    private final @NotNull Comparator<@NotNull Long> _fachartComparator_fach_kursart;
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostBlockungsergebnisKurs>> _map_fachartID_kurse = new HashMap<Long, List<GostBlockungsergebnisKurs>>();
    @NotNull
    private final @NotNull Comparator<@NotNull GostBlockungsergebnisKurs> _kursComparator_kursart_fach_kursnummer;
    @NotNull
    private final @NotNull Comparator<@NotNull GostBlockungsergebnisKurs> _kursComparator_fach_kursart_kursnummer;

    public GostBlockungsergebnisManager(@NotNull GostBlockungsdatenManager pParent, long pGostBlockungsergebnisID) {
        this._parent = pParent;
        this._fachartComparator_kursart_fach = this.createComparatorFachartKursartFach();
        this._fachartComparator_fach_kursart = this.createComparatorFachartFachKursart();
        this._kursComparator_fach_kursart_kursnummer = this.createComparatorKursFachKursartNummer();
        this._kursComparator_kursart_fach_kursnummer = this.createComparatorKursKursartFachNummer();
        this.stateClear(new GostBlockungsergebnis(), pGostBlockungsergebnisID);
    }

    public GostBlockungsergebnisManager(@NotNull GostBlockungsdatenManager pParent, @NotNull GostBlockungsergebnis pErgebnis) {
        this._parent = pParent;
        this._fachartComparator_kursart_fach = this.createComparatorFachartKursartFach();
        this._fachartComparator_fach_kursart = this.createComparatorFachartFachKursart();
        this._kursComparator_fach_kursart_kursnummer = this.createComparatorKursFachKursartNummer();
        this._kursComparator_kursart_fach_kursnummer = this.createComparatorKursKursartFachNummer();
        this.stateClear(pErgebnis, pErgebnis.id);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull Long> createComparatorFachartKursartFach() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            long bKursartID;
            long aKursartID = GostKursart.getKursartID(a);
            if (aKursartID < (bKursartID = (long)GostKursart.getKursartID(b))) {
                return -1;
            }
            if (aKursartID > bKursartID) {
                return 1;
            }
            long aFachID = GostKursart.getFachID(a);
            long bFachID = GostKursart.getFachID(b);
            @NotNull GostFach aFach = this._parent.faecherManager().getOrException(aFachID);
            @NotNull GostFach bFach = this._parent.faecherManager().getOrException(bFachID);
            return GostFaecherManager.comp.compare(aFach, bFach);
        };
        return comp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull Long> createComparatorFachartFachKursart() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            long bKursartID;
            GostFach bFach;
            long aFachID = GostKursart.getFachID(a);
            long bFachID = GostKursart.getFachID(b);
            @NotNull GostFach aFach = this._parent.faecherManager().getOrException(aFachID);
            int cmpFach = GostFaecherManager.comp.compare(aFach, bFach = this._parent.faecherManager().getOrException(bFachID));
            if (cmpFach != 0) {
                return cmpFach;
            }
            long aKursartID = GostKursart.getKursartID(a);
            if (aKursartID < (bKursartID = (long)GostKursart.getKursartID(b))) {
                return -1;
            }
            if (aKursartID > bKursartID) {
                return 1;
            }
            return 0;
        };
        return comp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull GostBlockungsergebnisKurs> createComparatorKursFachKursartNummer() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            GostFach bFach;
            @NotNull GostFach aFach = this._parent.faecherManager().getOrException(a.fachID);
            int cmpFach = GostFaecherManager.comp.compare(aFach, bFach = this._parent.faecherManager().getOrException(b.fachID));
            if (cmpFach != 0) {
                return cmpFach;
            }
            if (a.kursart < b.kursart) {
                return -1;
            }
            if (a.kursart > b.kursart) {
                return 1;
            }
            @NotNull GostBlockungKurs aKurs = this._parent.kursGet(a.id);
            @NotNull GostBlockungKurs bKurs = this._parent.kursGet(b.id);
            return Integer.compare(aKurs.nummer, bKurs.nummer);
        };
        return comp;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private @NotNull Comparator<@NotNull GostBlockungsergebnisKurs> createComparatorKursKursartFachNummer() {
        @NotNull @NotNull Comparator comp = (a, b) -> {
            GostFach bFach;
            if (a.kursart < b.kursart) {
                return -1;
            }
            if (a.kursart > b.kursart) {
                return 1;
            }
            @NotNull GostFach aFach = this._parent.faecherManager().getOrException(a.fachID);
            int cmpFach = GostFaecherManager.comp.compare(aFach, bFach = this._parent.faecherManager().getOrException(b.fachID));
            if (cmpFach != 0) {
                return cmpFach;
            }
            @NotNull GostBlockungKurs aKurs = this._parent.kursGet(a.id);
            @NotNull GostBlockungKurs bKurs = this._parent.kursGet(b.id);
            return Integer.compare(aKurs.nummer, bKurs.nummer);
        };
        return comp;
    }

    private void stateRevalidateEverything() {
        this.stateClear(this._ergebnis, this._ergebnis.id);
    }

    private void stateClear(@NotNull GostBlockungsergebnis pOld, long pGostBlockungsergebnisID) {
        this._map_schienenNr_schiene.clear();
        this._map_schienenID_schiene.clear();
        this._map_schienenID_schuelerAnzahl.clear();
        this._map_schienenID_kollisionen.clear();
        this._map2D_schienenID_fachartID_kurse.clear();
        this._map_schuelerID_kurse.clear();
        this._map_schuelerID_ungueltige_kurse.clear();
        this._map_schuelerID_kollisionen.clear();
        this._map2D_schuelerID_fachID_kurs.clear();
        this._map2D_schuelerID_schienenID_kurse.clear();
        this._map_kursID_schienen.clear();
        this._map_kursID_kurs.clear();
        this._map_kursID_schuelerIDs.clear();
        this._map_kursID_dummySuS.clear();
        this._map_fachID_kurse.clear();
        this._map_fachartID_kurse.clear();
        this._map_fachartID_kursdifferenz.clear();
        this._ergebnis = new GostBlockungsergebnis();
        this._ergebnis.id = pGostBlockungsergebnisID;
        this._ergebnis.blockungID = this._parent.getID();
        this._ergebnis.name = pOld.name;
        this._ergebnis.gostHalbjahr = this._parent.daten().gostHalbjahr;
        this._ergebnis.istMarkiert = pOld.istMarkiert;
        this._ergebnis.istVorlage = pOld.istVorlage;
        this._ergebnis.bewertung.kursdifferenzMax = 0;
        this._ergebnis.bewertung.kursdifferenzHistogramm = new int[this._parent.schuelerGetAnzahl() + 1];
        this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet = this._parent.daten().fachwahlen.size();
        for (GostBlockungSchiene gSchiene : this._parent.daten().schienen) {
            @NotNull GostBlockungsergebnisSchiene eSchiene = new GostBlockungsergebnisSchiene();
            eSchiene.id = gSchiene.id;
            this._ergebnis.schienen.add(eSchiene);
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schienenNr_schiene, gSchiene.nummer, eSchiene);
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schienenID_schiene, gSchiene.id, eSchiene);
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schienenID_schuelerAnzahl, gSchiene.id, 0);
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schienenID_kollisionen, gSchiene.id, 0);
        }
        for (GostBlockungKurs gKurs : this._parent.daten().kurse) {
            @NotNull Iterator<GostBlockungSchiene> eKurs = new GostBlockungsergebnisKurs();
            ((GostBlockungsergebnisKurs)((Object)eKurs)).id = gKurs.id;
            ((GostBlockungsergebnisKurs)((Object)eKurs)).fachID = gKurs.fach_id;
            ((GostBlockungsergebnisKurs)((Object)eKurs)).kursart = gKurs.kursart;
            ((GostBlockungsergebnisKurs)((Object)eKurs)).anzahlSchienen = gKurs.anzahlSchienen;
            this._ergebnis.bewertung.anzahlKurseNichtZugeordnet += ((GostBlockungsergebnisKurs)((Object)eKurs)).anzahlSchienen;
            DeveloperNotificationException.ifMapPutOverwrites(this._map_kursID_kurs, ((GostBlockungsergebnisKurs)((Object)eKurs)).id, eKurs);
            DeveloperNotificationException.ifMapPutOverwrites(this._map_kursID_schienen, ((GostBlockungsergebnisKurs)((Object)eKurs)).id, new HashSet());
            DeveloperNotificationException.ifMapPutOverwrites(this._map_kursID_schuelerIDs, ((GostBlockungsergebnisKurs)((Object)eKurs)).id, new HashSet());
            MapUtils.getOrCreateArrayList(this._map_fachID_kurse, ((GostBlockungsergebnisKurs)((Object)eKurs)).fachID).add((GostBlockungsergebnisKurs)((Object)eKurs));
            long fachartID = GostKursart.getFachartID(((GostBlockungsergebnisKurs)((Object)eKurs)).fachID, ((GostBlockungsergebnisKurs)((Object)eKurs)).kursart);
            MapUtils.getOrCreateArrayList(this._map_fachartID_kurse, fachartID).add((GostBlockungsergebnisKurs)((Object)eKurs));
            if (this._map_fachartID_kursdifferenz.containsKey(fachartID)) continue;
            this._map_fachartID_kursdifferenz.put(fachartID, 0);
            this._ergebnis.bewertung.kursdifferenzHistogramm[0] = this._ergebnis.bewertung.kursdifferenzHistogramm[0] + 1;
        }
        for (GostFachwahl gFachwahl : this._parent.daten().fachwahlen) {
            MapUtils.getOrCreateArrayList(this._map_fachartID_kurse, GostKursart.getFachartIDByFachwahl(gFachwahl));
        }
        for (GostBlockungSchiene gSchiene : this._parent.daten().schienen) {
            for (Long fachartID : this._map_fachartID_kursdifferenz.keySet()) {
                DeveloperNotificationException.ifMap2DPutOverwrites(this._map2D_schienenID_fachartID_kurse, gSchiene.id, fachartID, new ArrayList());
            }
        }
        for (Schueler gSchueler : this._parent.daten().schueler) {
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schuelerID_kurse, gSchueler.id, new HashSet());
            DeveloperNotificationException.ifMapPutOverwrites(this._map_schuelerID_kollisionen, gSchueler.id, 0);
        }
        for (GostFachwahl gFachwahl : this._parent.daten().fachwahlen) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._map2D_schuelerID_fachID_kurs, gFachwahl.schuelerID, gFachwahl.fachID, null);
        }
        for (Schueler gSchueler : this._parent.daten().schueler) {
            for (GostBlockungSchiene gSchiene : this._parent.daten().schienen) {
                HashSet<@NotNull E> newSet = new HashSet();
                DeveloperNotificationException.ifMap2DPutOverwrites(this._map2D_schuelerID_schienenID_kurse, gSchueler.id, gSchiene.id, newSet);
            }
        }
        HashSet<@NotNull Long> kursBearbeitet = new HashSet<Long>();
        for (GostBlockungsergebnisSchiene schieneOld : pOld.schienen) {
            for (GostBlockungsergebnisKurs kursOld : schieneOld.kurse) {
                this.setKursSchiene(kursOld.id, schieneOld.id, true);
                if (!kursBearbeitet.add(kursOld.id)) continue;
                for (Long schuelerID : kursOld.schueler) {
                    this.setSchuelerKurs(schuelerID, kursOld.id, true);
                }
            }
        }
        this._fachartmenge_sortiert.addAll(this._map_fachartID_kurse.keySet());
        this.stateRegelvalidierung();
    }

    private void stateRegelvalidierung() {
        @NotNull List<@NotNull Long> regelVerletzungen = this._ergebnis.bewertung.regelVerletzungen;
        regelVerletzungen.clear();
        this._map_kursID_dummySuS.clear();
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURSART_SPERRE_SCHIENEN_VON_BIS)) {
            this.stateRegelvalidierung1_kursart_sperren_in_schiene_von_bis(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE)) {
            this.stateRegelvalidierung2_kurs_fixieren_in_schiene(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE)) {
            this.stateRegelvalidierung3_kurs_sperren_in_schiene(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS)) {
            this.stateRegelvalidierung4_schueler_fixieren_in_kurs(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_VERBIETEN_IN_KURS)) {
            this.stateRegelvalidierung5_schueler_verbieten_in_kurs(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURSART_ALLEIN_IN_SCHIENEN_VON_BIS)) {
            this.stateRegelvalidierung6_kursart_allein_in_schiene_von_bis(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_VERBIETEN_MIT_KURS)) {
            this.stateRegelvalidierung7_kurs_verbieten_mit_kurs(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_ZUSAMMEN_MIT_KURS)) {
            this.stateRegelvalidierung8_kurs_zusammen_mit_kurs(r, regelVerletzungen);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_MIT_DUMMY_SUS_AUFFUELLEN)) {
            this.stateRegelvalidierung9_kurs_mit_dummy_sus_auffuellen(r);
        }
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.LEHRKRAEFTE_BEACHTEN)) {
            this.stateRegelvalidierung10_lehrkraefte_beachten(r, regelVerletzungen);
        }
        this._parent.ergebnisUpdateBewertung(this._ergebnis);
        this.updateAll();
    }

    private void stateRegelvalidierung1_kursart_sperren_in_schiene_von_bis(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        for (int schienenNr = r.parameter.get(1).intValue(); schienenNr <= r.parameter.get(2).intValue(); ++schienenNr) {
            for (GostBlockungsergebnisKurs eKurs : this.getSchieneEmitNr((int)schienenNr).kurse) {
                if (eKurs.kursart != r.parameter.get(0).intValue()) continue;
                regelVerletzungen.add(r.id);
            }
        }
    }

    private void stateRegelvalidierung2_kurs_fixieren_in_schiene(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        if (!this.getOfKursSchienenmenge(r.parameter.get(0)).contains(this.getSchieneEmitNr(r.parameter.get(1).intValue()))) {
            regelVerletzungen.add(r.id);
        }
    }

    private void stateRegelvalidierung3_kurs_sperren_in_schiene(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        if (this.getOfKursSchienenmenge(r.parameter.get(0)).contains(this.getSchieneEmitNr(r.parameter.get(1).intValue()))) {
            regelVerletzungen.add(r.id);
        }
    }

    private void stateRegelvalidierung4_schueler_fixieren_in_kurs(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        if (!this.getOfSchuelerOfKursIstZugeordnet(r.parameter.get(0), r.parameter.get(1))) {
            regelVerletzungen.add(r.id);
        }
    }

    private void stateRegelvalidierung5_schueler_verbieten_in_kurs(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        if (this.getOfSchuelerOfKursIstZugeordnet(r.parameter.get(0), r.parameter.get(1))) {
            regelVerletzungen.add(r.id);
        }
    }

    private void stateRegelvalidierung6_kursart_allein_in_schiene_von_bis(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        for (GostBlockungsergebnisKurs eKurs : this._map_kursID_kurs.values()) {
            for (Long eSchieneID : eKurs.schienen) {
                boolean b2;
                int nr = this.getSchieneG((long)eSchieneID.longValue()).nummer;
                boolean b1 = eKurs.kursart == r.parameter.get(0).intValue();
                if (b1 == (b2 = r.parameter.get(1).intValue() <= nr && nr <= r.parameter.get(2).intValue())) continue;
                regelVerletzungen.add(r.id);
            }
        }
    }

    private void stateRegelvalidierung7_kurs_verbieten_mit_kurs(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        long idKurs1 = r.parameter.get(0);
        long idKurs2 = r.parameter.get(1);
        for (GostBlockungsergebnisSchiene schiene1 : this.getOfKursSchienenmenge(idKurs1)) {
            for (GostBlockungsergebnisSchiene schiene2 : this.getOfKursSchienenmenge(idKurs2)) {
                if (schiene1 != schiene2) continue;
                regelVerletzungen.add(r.id);
            }
        }
    }

    private void stateRegelvalidierung8_kurs_zusammen_mit_kurs(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        long idKurs1 = r.parameter.get(0);
        long idKurs2 = r.parameter.get(1);
        @NotNull Set<@NotNull GostBlockungsergebnisSchiene> set1 = this.getOfKursSchienenmenge(idKurs1);
        @NotNull Set<@NotNull GostBlockungsergebnisSchiene> set2 = this.getOfKursSchienenmenge(idKurs2);
        if (set1.size() < set2.size()) {
            for (GostBlockungsergebnisSchiene schiene1 : set1) {
                if (set2.contains(schiene1)) continue;
                regelVerletzungen.add(r.id);
            }
        } else {
            for (GostBlockungsergebnisSchiene schiene2 : set2) {
                if (set1.contains(schiene2)) continue;
                regelVerletzungen.add(r.id);
            }
        }
    }

    private void stateRegelvalidierung9_kurs_mit_dummy_sus_auffuellen(@NotNull GostBlockungRegel r) {
        long idKurs = r.parameter.get(0);
        int anzahl = r.parameter.get(1).intValue();
        DeveloperNotificationException.ifTrue("Regel 9 DummySuS Wert = " + anzahl + " ist ung\u00fcltig!", anzahl < 1 || anzahl > 99);
        DeveloperNotificationException.ifMapPutOverwrites(this._map_kursID_dummySuS, idKurs, anzahl);
    }

    private void stateRegelvalidierung10_lehrkraefte_beachten(@NotNull GostBlockungRegel r, @NotNull @NotNull List<@NotNull Long> regelVerletzungen) {
        for (GostBlockungsergebnisSchiene eSchiene : this._map_schienenID_schiene.values()) {
            for (GostBlockungsergebnisKurs eKurs1 : eSchiene.kurse) {
                for (GostBlockungsergebnisKurs eKurs2 : eSchiene.kurse) {
                    if (eKurs1.id >= eKurs2.id) continue;
                    for (GostBlockungKursLehrer gLehr1 : this.getKursG((long)eKurs1.id).lehrer) {
                        for (GostBlockungKursLehrer gLehr2 : this.getKursG((long)eKurs2.id).lehrer) {
                            if (gLehr1.id != gLehr2.id) continue;
                            regelVerletzungen.add(r.id);
                        }
                    }
                }
            }
        }
    }

    private void stateSchuelerKursHinzufuegen(long idSchueler, long idKurs) {
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        long fachID = kurs.fachID;
        if (!this.getOfSchuelerHatFachwahl(idSchueler, fachID, kurs.kursart)) {
            this.stateSchuelerKursUngueltigeWahlHinzufuegen(idSchueler, kurs);
            return;
        }
        if (this.getOfSchuelerOfFachZugeordneterKurs(idSchueler, fachID) != null) {
            return;
        }
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> kurseOfSchueler = this.getOfSchuelerKursmenge(idSchueler);
        @NotNull Set<@NotNull Long> schuelerIDsOfKurs = this.getOfKursSchuelerIDmenge(idKurs);
        long fachartID = GostKursart.getFachartID(fachID, kurs.kursart);
        kurs.schueler.add(idSchueler);
        kurseOfSchueler.add(kurs);
        schuelerIDsOfKurs.add(idSchueler);
        --this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet;
        this._map2D_schuelerID_fachID_kurs.put(idSchueler, fachID, kurs);
        this.stateKursdifferenzUpdate(fachartID);
        for (Long schieneID : kurs.schienen) {
            this.stateSchuelerSchieneHinzufuegen(idSchueler, schieneID, kurs);
        }
        this.stateRegelvalidierung();
    }

    private void stateSchuelerKursEntfernen(long idSchueler, long idKurs) {
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        long fachID = kurs.fachID;
        if (!this.getOfSchuelerHatFachwahl(idSchueler, fachID, kurs.kursart)) {
            this.stateSchuelerKursUngueltigeWahlEntfernen(idSchueler, kurs);
            return;
        }
        if (this.getOfSchuelerOfFachZugeordneterKurs(idSchueler, fachID) != kurs) {
            return;
        }
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> kurseOfSchueler = this.getOfSchuelerKursmenge(idSchueler);
        @NotNull Set<@NotNull Long> schuelerIDsOfKurs = this.getOfKursSchuelerIDmenge(idKurs);
        long fachartID = GostKursart.getFachartID(fachID, kurs.kursart);
        kurs.schueler.remove(idSchueler);
        kurseOfSchueler.remove(kurs);
        schuelerIDsOfKurs.remove(idSchueler);
        ++this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet;
        this._map2D_schuelerID_fachID_kurs.put(idSchueler, fachID, null);
        this.stateKursdifferenzUpdate(fachartID);
        for (Long schieneID : kurs.schienen) {
            this.stateSchuelerSchieneEntfernen(idSchueler, schieneID, kurs);
        }
        this.stateRegelvalidierung();
    }

    private void stateSchuelerKursUngueltigeWahlHinzufuegen(long idSchueler, @NotNull GostBlockungsergebnisKurs idKurs) {
        MapUtils.getOrCreateHashSet(this._map_schuelerID_ungueltige_kurse, idSchueler).add(idKurs);
    }

    private void stateSchuelerKursUngueltigeWahlEntfernen(long idSchueler, @NotNull GostBlockungsergebnisKurs idKurs) {
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> set = DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_ungueltige_kurse, idSchueler);
        set.remove(idKurs);
        if (set.isEmpty()) {
            this._map_schuelerID_ungueltige_kurse.remove(idSchueler);
        }
    }

    private void stateKursSchieneHinzufuegen(long idKurs, long idSchiene) {
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        @NotNull GostBlockungsergebnisSchiene schiene = this.getSchieneE(idSchiene);
        @NotNull Set<@NotNull GostBlockungsergebnisSchiene> setSchienenOfKurs = this.getOfKursSchienenmenge(idKurs);
        long idFach = kurs.fachID;
        long idFachart = GostKursart.getFachartID(idFach, kurs.kursart);
        @NotNull List<@NotNull GostBlockungsergebnisKurs> kursGruppe = this._map2D_schienenID_fachartID_kurse.getNonNullOrException(idSchiene, idFachart);
        this._ergebnis.bewertung.anzahlKurseNichtZugeordnet -= Math.abs(kurs.anzahlSchienen - setSchienenOfKurs.size());
        DeveloperNotificationException.ifListAddsDuplicate("kurs.schienen", kurs.schienen, schiene.id);
        DeveloperNotificationException.ifListAddsDuplicate("schiene.kurse", schiene.kurse, kurs);
        DeveloperNotificationException.ifSetAddsDuplicate("setSchienenOfKurs", setSchienenOfKurs, schiene);
        for (Long schuelerID : kurs.schueler) {
            this.stateSchuelerSchieneHinzufuegen(schuelerID, schiene.id, kurs);
        }
        this._ergebnis.bewertung.anzahlKurseNichtZugeordnet += Math.abs(kurs.anzahlSchienen - setSchienenOfKurs.size());
        this._ergebnis.bewertung.anzahlKurseMitGleicherFachartProSchiene = this._ergebnis.bewertung.anzahlKurseMitGleicherFachartProSchiene + (kursGruppe.isEmpty() ? 0 : 1);
        DeveloperNotificationException.ifListAddsDuplicate("kursGruppe", kursGruppe, kurs);
        this.stateRegelvalidierung();
    }

    private void stateKursSchieneEntfernen(long idKurs, long idSchiene) {
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        @NotNull GostBlockungsergebnisSchiene schiene = this.getSchieneE(idSchiene);
        @NotNull Set<@NotNull GostBlockungsergebnisSchiene> setSchienenOfKurs = this.getOfKursSchienenmenge(idKurs);
        long idFach = kurs.fachID;
        long idFachart = GostKursart.getFachartID(idFach, kurs.kursart);
        @NotNull List<@NotNull GostBlockungsergebnisKurs> kursGruppe = this._map2D_schienenID_fachartID_kurse.getNonNullOrException(idSchiene, idFachart);
        this._ergebnis.bewertung.anzahlKurseNichtZugeordnet -= Math.abs(kurs.anzahlSchienen - setSchienenOfKurs.size());
        DeveloperNotificationException.ifListRemoveFailes("kurs.schienen", kurs.schienen, schiene.id);
        DeveloperNotificationException.ifListRemoveFailes("schiene.kurse", schiene.kurse, kurs);
        DeveloperNotificationException.ifSetRemoveFailes("setSchienenOfKurs", setSchienenOfKurs, schiene);
        for (Long schuelerID : kurs.schueler) {
            this.stateSchuelerSchieneEntfernen(schuelerID, schiene.id, kurs);
        }
        this._ergebnis.bewertung.anzahlKurseNichtZugeordnet += Math.abs(kurs.anzahlSchienen - setSchienenOfKurs.size());
        DeveloperNotificationException.ifListRemoveFailes("kursGruppe", kursGruppe, kurs);
        this._ergebnis.bewertung.anzahlKurseMitGleicherFachartProSchiene = this._ergebnis.bewertung.anzahlKurseMitGleicherFachartProSchiene - (kursGruppe.isEmpty() ? 0 : 1);
        this.stateRegelvalidierung();
    }

    private void stateSchuelerSchieneHinzufuegen(long idSchueler, long idSchiene, @NotNull GostBlockungsergebnisKurs kurs) {
        int schieneSchuelerzahl = this.getOfSchieneAnzahlSchueler(idSchiene);
        this._map_schienenID_schuelerAnzahl.put(idSchiene, schieneSchuelerzahl + 1);
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> kursmenge = this._map2D_schuelerID_schienenID_kurse.getNonNullOrException(idSchueler, idSchiene);
        kursmenge.add(kurs);
        if (kursmenge.size() > 1) {
            int schieneKollisionen = this.getOfSchieneAnzahlSchuelerMitKollisionen(idSchiene);
            this._map_schienenID_kollisionen.put(idSchiene, schieneKollisionen + 1);
            int schuelerKollisionen = this.getOfSchuelerAnzahlKollisionen(idSchueler);
            this._map_schuelerID_kollisionen.put(idSchueler, schuelerKollisionen + 1);
            ++this._ergebnis.bewertung.anzahlSchuelerKollisionen;
        }
    }

    private void stateSchuelerSchieneEntfernen(long idSchueler, long idSchiene, @NotNull GostBlockungsergebnisKurs kurs) {
        int schieneSchuelerzahl = this.getOfSchieneAnzahlSchueler(idSchiene);
        DeveloperNotificationException.ifTrue("schieneSchuelerzahl == 0 --> Entfernen unm\u00f6glich!", schieneSchuelerzahl == 0);
        this._map_schienenID_schuelerAnzahl.put(idSchiene, schieneSchuelerzahl - 1);
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> kursmenge = this._map2D_schuelerID_schienenID_kurse.getNonNullOrException(idSchueler, idSchiene);
        kursmenge.remove(kurs);
        if (!kursmenge.isEmpty()) {
            int schieneKollisionen = this.getOfSchieneAnzahlSchuelerMitKollisionen(idSchiene);
            DeveloperNotificationException.ifTrue("schieneKollisionen == 0 --> Entfernen unm\u00f6glich!", schieneKollisionen == 0);
            this._map_schienenID_kollisionen.put(idSchiene, schieneKollisionen - 1);
            int schuelerKollisionen = this.getOfSchuelerAnzahlKollisionen(idSchueler);
            DeveloperNotificationException.ifTrue("schuelerKollisionen == 0 --> Entfernen unm\u00f6glich!", schuelerKollisionen == 0);
            this._map_schuelerID_kollisionen.put(idSchueler, schuelerKollisionen - 1);
            DeveloperNotificationException.ifTrue("Gesamtkollisionen == 0 --> Entfernen unm\u00f6glich!", this._ergebnis.bewertung.anzahlSchuelerKollisionen == 0);
            --this._ergebnis.bewertung.anzahlSchuelerKollisionen;
        }
    }

    private void stateKursdifferenzUpdate(long idFachart) {
        int min;
        @NotNull List<@NotNull GostBlockungsergebnisKurs> kursmenge = this.getOfFachartKursmenge(idFachart);
        @NotNull GostBlockungsergebnisKurs kurs1 = DeveloperNotificationException.ifListGetFirstFailes("getOfFachartKursmenge", kursmenge);
        int max = min = kurs1.schueler.size() + this.getOfKursAnzahlSchuelerDummy(kurs1.id);
        for (GostBlockungsergebnisKurs kurs : kursmenge) {
            int size = kurs.schueler.size() + this.getOfKursAnzahlSchuelerDummy(kurs.id);
            min = Math.min(min, size);
            max = Math.max(max, size);
        }
        int newKD = max - min;
        int oldKD = this.getOfFachartKursdifferenz(idFachart);
        if (newKD == oldKD) {
            return;
        }
        this._map_fachartID_kursdifferenz.put(idFachart, newKD);
        int[] kursdifferenzen = this._ergebnis.bewertung.kursdifferenzHistogramm;
        int n = oldKD;
        kursdifferenzen[n] = kursdifferenzen[n] - 1;
        int n2 = newKD;
        kursdifferenzen[n2] = kursdifferenzen[n2] + 1;
        if (oldKD == this._ergebnis.bewertung.kursdifferenzMax) {
            if (newKD > oldKD) {
                this._ergebnis.bewertung.kursdifferenzMax = newKD;
            } else if (kursdifferenzen[oldKD] == 0) {
                this._ergebnis.bewertung.kursdifferenzMax = newKD;
            }
        }
    }

    private void updateAll() {
        List<GostBlockungsergebnisKurs> kursmenge;
        if (this._fachartmenge_sortierung == 1) {
            this._fachartmenge_sortiert.sort(this._fachartComparator_kursart_fach);
        } else {
            this._fachartmenge_sortiert.sort(this._fachartComparator_fach_kursart);
        }
        for (Long idFachart : this._map_fachartID_kurse.keySet()) {
            kursmenge = DeveloperNotificationException.ifMapGetIsNull(this._map_fachartID_kurse, idFachart);
            if (this._fachartmenge_sortierung == 1) {
                kursmenge.sort(this._kursComparator_kursart_fach_kursnummer);
                continue;
            }
            kursmenge.sort(this._kursComparator_fach_kursart_kursnummer);
        }
        for (GostBlockungsergebnisSchiene schiene : this._ergebnis.schienen) {
            kursmenge = schiene.kurse;
            if (this._fachartmenge_sortierung == 1) {
                kursmenge.sort(this._kursComparator_kursart_fach_kursnummer);
                continue;
            }
            kursmenge.sort(this._kursComparator_fach_kursart_kursnummer);
        }
    }

    public int getAnzahlSchuelerExterne() {
        return ListUtils.getCountFiltered(this._parent.daten().schueler, schueler -> this.getOfSchuelerHatStatusExtern(schueler.id));
    }

    public int getAnzahlSchuelerDummy() {
        int summe = 0;
        for (long idKurs : this._map_kursID_dummySuS.keySet()) {
            summe += this.getOfKursAnzahlSchuelerDummy(idKurs);
        }
        return summe;
    }

    public GostBlockungsdatenManager getParent() {
        return this._parent;
    }

    public long getBlockungsdatenID() {
        return this._ergebnis.blockungID;
    }

    @NotNull
    public GostBlockungsergebnis getErgebnis() {
        return this._ergebnis;
    }

    public int getOfBewertung1Wert() {
        int summe = 0;
        summe += this._ergebnis.bewertung.anzahlKurseNichtZugeordnet;
        return summe += this._ergebnis.bewertung.regelVerletzungen.size();
    }

    public double getOfBewertung1Farbcode() {
        double summe = this.getOfBewertung1Wert();
        return 1.0 - 1.0 / (0.25 * summe + 1.0);
    }

    public int getOfBewertung2Wert() {
        int summe = 0;
        summe += this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet;
        return summe += this._ergebnis.bewertung.anzahlSchuelerKollisionen;
    }

    public double getOfBewertung2Farbcode() {
        double summe = this.getOfBewertung2Wert();
        return 1.0 - 1.0 / (0.25 * summe + 1.0);
    }

    public int getOfBewertung3Wert() {
        return this._ergebnis.bewertung.kursdifferenzMax;
    }

    public double getOfBewertung3Farbcode() {
        int wert = this.getOfBewertung3Wert();
        if (wert > 0) {
            --wert;
        }
        return 1.0 - 1.0 / (0.25 * (double)wert + 1.0);
    }

    public int getOfBewertung4Wert() {
        return this._ergebnis.bewertung.anzahlKurseMitGleicherFachartProSchiene;
    }

    public double getOfBewertung4Farbcode() {
        int wert = this.getOfBewertung4Wert();
        return 1.0 - 1.0 / (0.25 * (double)wert + 1.0);
    }

    public int getOfBewertungAnzahlKollisionen() {
        return this._ergebnis.bewertung.anzahlSchuelerKollisionen;
    }

    public int getOfBewertungAnzahlNichtZugeordneterKurse() {
        return this._ergebnis.bewertung.anzahlKurseNichtZugeordnet;
    }

    public int getOfBewertungAnzahlNichtzugeordneterFachwahlen() {
        return this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet;
    }

    @NotNull
    public GostFach getFach(long idFach) throws DeveloperNotificationException {
        return this._parent.faecherManager().getOrException(idFach);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisKurs> getOfFachKursmenge(long idFach) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_fachID_kurse, idFach);
    }

    public int getOfFachAnzahlSchuelerMaennlich(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", Geschlecht.M, null);
    }

    public int getOfFachAnzahlSchuelerWeiblich(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", Geschlecht.W, null);
    }

    public int getOfFachAnzahlSchuelerDivers(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", Geschlecht.D, null);
    }

    public int getOfFachAnzahlSchuelerOhneAngabe(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", Geschlecht.X, null);
    }

    public int getOfFachAnzahlSchuelerSchriftlich(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", null, GostSchriftlichkeit.SCHRIFTLICH);
    }

    public int getOfFachAnzahlSchuelerMuendlich(long idFach) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, 0, 0, "", null, GostSchriftlichkeit.MUENDLICH);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisKurs> getOfFachartKursmenge(long idFachart) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_fachartID_kurse, idFachart);
    }

    public int getOfFachartKursdifferenz(long idFachart) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_fachartID_kursdifferenz, idFachart);
    }

    public int getOfFachartAnzahlSchuelerMaennlich(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", Geschlecht.M, null);
    }

    public int getOfFachartAnzahlSchuelerWeiblich(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", Geschlecht.W, null);
    }

    public int getOfFachartAnzahlSchuelerDivers(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", Geschlecht.D, null);
    }

    public int getOfFachartAnzahlSchuelerOhneAngabe(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", Geschlecht.X, null);
    }

    public int getOfFachartAnzahlSchuelerSchriftlich(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", null, GostSchriftlichkeit.SCHRIFTLICH);
    }

    public int getOfFachartAnzahlSchuelerMuendlich(long idFach, int idKursart) {
        return this.getOfSchuelerAnzahlGefiltert(-1L, idFach, idKursart, 0, "", null, GostSchriftlichkeit.MUENDLICH);
    }

    @NotNull
    public @NotNull List<@NotNull Long> getOfFachartMengeSortiert() {
        return this._fachartmenge_sortiert;
    }

    public void kursSetSortierungKursartFachNummer() {
        this._fachartmenge_sortierung = 1;
        this.updateAll();
    }

    public void kursSetSortierungFachKursartNummer() {
        this._fachartmenge_sortierung = 2;
        this.updateAll();
    }

    @NotNull
    public Schueler getSchuelerG(long idSchueler) throws DeveloperNotificationException {
        return this._parent.schuelerGet(idSchueler);
    }

    @NotNull
    public String getOfSchuelerNameVorname(long idSchueler) {
        @NotNull Schueler schueler = this._parent.schuelerGet(idSchueler);
        return schueler.nachname + ", " + schueler.vorname;
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisKurs> getOfSchuelerKursmenge(long idSchueler) {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_kurse, idSchueler);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisKurs> getOfSchuelerKursmengeSortiert(long idSchueler) {
        ArrayList<@NotNull GostBlockungsergebnisKurs> list = new ArrayList<GostBlockungsergebnisKurs>();
        list.addAll((Collection)DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_kurse, idSchueler));
        if (this._fachartmenge_sortierung == 1) {
            list.sort(this._kursComparator_kursart_fach_kursnummer);
        } else {
            list.sort(this._kursComparator_fach_kursart_kursnummer);
        }
        return list;
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisKurs> getOfSchuelerKursmengeMitKollisionen(long idSchueler) {
        @NotNull HashSet<@NotNull GostBlockungsergebnisKurs> set = new HashSet<GostBlockungsergebnisKurs>();
        for (GostBlockungSchiene schiene : this._parent.schieneGetListe()) {
            @NotNull Set<@NotNull GostBlockungsergebnisKurs> kurseDerSchiene = this._map2D_schuelerID_schienenID_kurse.getNonNullOrException(idSchueler, schiene.id);
            if (kurseDerSchiene.size() <= 1) continue;
            set.addAll(kurseDerSchiene);
        }
        return set;
    }

    public boolean getOfSchuelerHatNichtwahl(long idSchueler) {
        int nSoll;
        int nIst = DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_kurse, idSchueler).size();
        return nIst < (nSoll = this._map2D_schuelerID_fachID_kurs.getSubMapSizeOrZero(idSchueler));
    }

    public boolean getOfSchuelerHatFachwahl(long idSchueler, long idFach, int idKursart) {
        return this._parent.schuelerGetHatFachart(idSchueler, idFach, idKursart);
    }

    public boolean getOfSchuelerHatFach(long idSchueler, long idFach) {
        return this._parent.schuelerGetHatFach(idSchueler, idFach);
    }

    public boolean getOfSchuelerHatKollision(long idSchueler) {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_kollisionen, idSchueler) > 0;
    }

    public int getOfSchuelerAnzahlKollisionen(long idSchueler) {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schuelerID_kollisionen, idSchueler);
    }

    public int getOfSchuelerAnzahlMitKollisionenOderNichtwahlen() {
        return this.getOfSchuelerAnzahlGefiltert(-1L, -1L, -1, 3, "", null, null);
    }

    public int getOfSchuelerAnzahlMaennlich() {
        return this.getOfSchuelerAnzahlGefiltert(-1L, -1L, -1, 0, "", Geschlecht.M, null);
    }

    public int getOfSchuelerAnzahlWeiblich() {
        return this.getOfSchuelerAnzahlGefiltert(-1L, -1L, -1, 0, "", Geschlecht.W, null);
    }

    public int getOfSchuelerAnzahlDivers() {
        return this.getOfSchuelerAnzahlGefiltert(-1L, -1L, -1, 0, "", Geschlecht.D, null);
    }

    public int getOfSchuelerAnzahlOhneAngabe() {
        return this.getOfSchuelerAnzahlGefiltert(-1L, -1L, -1, 0, "", Geschlecht.X, null);
    }

    public int getOfSchuelerAnzahlGefiltert(long idKurs, long idFach, int idKursart, int konfliktTyp, @NotNull String subString, Geschlecht geschlecht, GostSchriftlichkeit schriftlichkeit) {
        int summe = 0;
        for (Schueler schueler : this._parent.schuelerGetListe()) {
            if (!this.getOfSchuelerErfuelltKriterien(schueler.id, idKurs, idFach, idKursart, konfliktTyp, subString, geschlecht, schriftlichkeit)) continue;
            ++summe;
        }
        return summe;
    }

    public boolean getOfSchuelerAlleFachwahlenNichtZugeordnet() {
        return this._ergebnis.bewertung.anzahlSchuelerNichtZugeordnet == this._parent.daten().fachwahlen.size();
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisKurs> getOfSchuelerOfSchieneKursmenge(long idSchueler, long idSchiene) {
        return this._map2D_schuelerID_schienenID_kurse.getNonNullOrException(idSchueler, idSchiene);
    }

    public boolean getOfSchuelerOfSchieneHatKollision(long idSchueler, long idSchiene) {
        return this._map2D_schuelerID_schienenID_kurse.getNonNullOrException(idSchueler, idSchiene).size() > 1;
    }

    @NotNull
    public GostKursart getOfSchuelerOfFachKursart(long idSchueler, long idFach) {
        return this._parent.schuelerGetOfFachKursart(idSchueler, idFach);
    }

    public GostBlockungsergebnisKurs getOfSchuelerOfFachZugeordneterKurs(long idSchueler, long idFach) {
        return this._map2D_schuelerID_fachID_kurs.getOrNull(idSchueler, idFach);
    }

    public boolean getOfSchuelerOfKursIstZugeordnet(long idSchueler, long idKurs) {
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        @NotNull Set<@NotNull GostBlockungsergebnisKurs> kurseOfSchueler = this.getOfSchuelerKursmenge(idSchueler);
        return kurseOfSchueler.contains(kurs);
    }

    @NotNull
    public SchuelerblockungOutput getOfSchuelerNeuzuordnungMitFixierung(long idSchueler, boolean fixiereBelegteKurse) {
        @NotNull SchuelerblockungInput input = new SchuelerblockungInput();
        input.schienen = this._parent.schieneGetAnzahl();
        for (GostFachwahl fachwahl : this._parent.schuelerGetListeOfFachwahlen(idSchueler)) {
            input.fachwahlen.add(fachwahl);
            input.fachwahlenText.add(this._parent.fachwahlGetName(fachwahl));
            long fachartID = GostKursart.getFachartIDByFachwahl(fachwahl);
            for (GostBlockungsergebnisKurs kursE : this.getOfFachartKursmenge(fachartID)) {
                long idKurs;
                @NotNull SchuelerblockungInputKurs kursS = new SchuelerblockungInputKurs();
                kursS.id = idKurs = kursE.id;
                kursS.fach = kursE.fachID;
                kursS.kursart = kursE.kursart;
                kursS.istGesperrt = this.getOfSchuelerOfKursIstGesperrt(idSchueler, idKurs);
                kursS.istFixiert = this.getOfSchuelerOfKursIstFixiert(idSchueler, idKurs) || fixiereBelegteKurse && this.getOfSchuelerOfKursIstZugeordnet(idSchueler, idKurs);
                DeveloperNotificationException.ifTrue("kursS.istGesperrt && kursS.istFixiert", kursS.istGesperrt && kursS.istFixiert);
                kursS.anzahlSuS = this.getOfKursAnzahlSchueler(idKurs);
                kursS.schienen = this.getOfKursSchienenNummern(idKurs);
                input.kurse.add(kursS);
            }
        }
        if (input.kurse.isEmpty()) {
            return new SchuelerblockungOutput();
        }
        return new SchuelerblockungAlgorithmus().handle(input);
    }

    public boolean getOfSchuelerOfKursIstFixiert(long idSchueler, long idKurs) {
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS)) {
            long schuelerID = r.parameter.get(0);
            long kursID = r.parameter.get(1);
            if (schuelerID != idSchueler || kursID != idKurs) continue;
            return true;
        }
        return false;
    }

    public boolean getOfSchuelerOfKursIstAbiturfach(long idSchueler, long idKurs) {
        @NotNull GostFachwahl fachwahl = this.getOfSchuelerOfKursFachwahl(idSchueler, idKurs);
        if (fachwahl.abiturfach == null) {
            return false;
        }
        return fachwahl.abiturfach >= 1;
    }

    public boolean getOfSchuelerOfKursIstGesperrt(long idSchueler, long idKurs) {
        for (GostBlockungRegel r : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_VERBIETEN_IN_KURS)) {
            long schuelerID = r.parameter.get(0);
            long kursID = r.parameter.get(1);
            if (schuelerID != idSchueler || kursID != idKurs) continue;
            return true;
        }
        return false;
    }

    public boolean getOfSchuelerHatImNamenSubstring(long idSchueler, @NotNull String subString) {
        @NotNull Schueler schueler = this.getSchuelerG(idSchueler);
        @NotNull String text = subString.toLowerCase();
        return schueler.nachname.toLowerCase().contains(text) || schueler.vorname.toLowerCase().contains(text);
    }

    @NotNull
    public Geschlecht getOfSchuelerGeschlechtOrException(long idSchueler) throws DeveloperNotificationException {
        @NotNull Schueler schueler = this.getSchuelerG(idSchueler);
        Geschlecht geschlecht = Geschlecht.fromValue(schueler.geschlecht);
        return DeveloperNotificationException.ifNull("Das Geschlecht des Sch\u00fclers " + idSchueler + " ist nicht definiert!", geschlecht);
    }

    public boolean getOfSchuelerHatStatusExtern(@NotNull Long idSchueler) {
        return this.getSchuelerG((long)idSchueler.longValue()).status == SchuelerStatus.EXTERN.id;
    }

    @NotNull
    public GostFachwahl getOfSchuelerOfKursFachwahl(long idSchueler, long idKurs) {
        long idFach = this.getKursE((long)idKurs).fachID;
        return this._parent.schuelerGetOfFachFachwahl(idSchueler, idFach);
    }

    @NotNull
    public GostFachwahl getOfSchuelerOfFachFachwahl(long idSchueler, long idFach) {
        return this._parent.schuelerGetOfFachFachwahl(idSchueler, idFach);
    }

    @NotNull
    public @NotNull List<@NotNull Schueler> getOfSchuelerMengeGefiltert(long idKurs, long idFach, int idKursart, int konfliktTyp, @NotNull String subString) {
        @NotNull ArrayList<@NotNull Schueler> menge = new ArrayList<Schueler>();
        for (Schueler schueler : this._parent.schuelerGetListe()) {
            if (!this.getOfSchuelerErfuelltKriterien(schueler.id, idKurs, idFach, idKursart, konfliktTyp, subString, null, null)) continue;
            menge.add(schueler);
        }
        return menge;
    }

    public boolean getOfSchuelerErfuelltKriterien(long idSchueler, long idKurs, long idFach, int idKursart, int konfliktTyp, @NotNull String subString, Geschlecht geschlecht, GostSchriftlichkeit schriftlichkeit) {
        if (konfliktTyp == 1 && !this.getOfSchuelerHatKollision(idSchueler)) {
            return false;
        }
        if (konfliktTyp == 2 && !this.getOfSchuelerHatNichtwahl(idSchueler)) {
            return false;
        }
        if (konfliktTyp == 3 && !this.getOfSchuelerHatKollision(idSchueler) && !this.getOfSchuelerHatNichtwahl(idSchueler)) {
            return false;
        }
        if (subString.length() > 0 && !this.getOfSchuelerHatImNamenSubstring(idSchueler, subString)) {
            return false;
        }
        if (geschlecht != null && this.getOfSchuelerGeschlechtOrException((long)idSchueler).id != geschlecht.id) {
            return false;
        }
        if (idKurs >= 0L) {
            if (!this.getOfSchuelerOfKursIstZugeordnet(idSchueler, idKurs)) {
                return false;
            }
            if (schriftlichkeit != null && schriftlichkeit.getIstSchriftlichOrException() != this.getOfSchuelerOfKursFachwahl((long)idSchueler, (long)idKurs).istSchriftlich) {
                return false;
            }
        }
        if (idFach >= 0L) {
            if (idKursart >= 0 ? !this.getOfSchuelerHatFachwahl(idSchueler, idFach, idKursart) : !this.getOfSchuelerHatFach(idSchueler, idFach)) {
                return false;
            }
            if (schriftlichkeit != null && schriftlichkeit.getIstSchriftlichOrException() != this.getOfSchuelerOfFachFachwahl((long)idSchueler, (long)idFach).istSchriftlich) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisKurs>> getOfSchuelerMapIDzuUngueltigeKurse() {
        return this._map_schuelerID_ungueltige_kurse;
    }

    public boolean getOfSchuelerOfKursHatKollision(long idSchueler, long idKurs) {
        if (!this.getOfSchuelerHatKollision(idSchueler)) {
            return false;
        }
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        for (Long idSchiene : kurs.schienen) {
            if (this.getOfSchuelerOfSchieneKursmenge(idSchueler, idSchiene).size() <= 1) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public GostBlockungKurs getKursG(long idKurs) throws DeveloperNotificationException {
        return this._parent.kursGet(idKurs);
    }

    @NotNull
    public GostBlockungsergebnisKurs getKursE(long idKurs) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_kursID_kurs, idKurs);
    }

    @NotNull
    public String getOfKursName(long idKurs) {
        return this._parent.kursGetName(idKurs);
    }

    public boolean getOfKursOfSchieneIstZugeordnet(long idKurs, long idSchiene) {
        @NotNull GostBlockungsergebnisSchiene schiene = this.getSchieneE(idSchiene);
        @NotNull Set<@NotNull GostBlockungsergebnisSchiene> schienenOfKurs = this.getOfKursSchienenmenge(idKurs);
        return schienenOfKurs.contains(schiene);
    }

    public boolean getOfKursOfSchieneIstFixiert(long idKurs, long idSchiene) {
        int nummer = this.getSchieneG((long)idSchiene).nummer;
        for (GostBlockungRegel regel : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE)) {
            if (regel.parameter.get(0) != idKurs || regel.parameter.get(1) != (long)nummer) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public @NotNull Set<@NotNull Long> getOfKursSchuelerIDmenge(long idKurs) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_kursID_schuelerIDs, idKurs);
    }

    @NotNull
    public @NotNull List<@NotNull Schueler> getOfKursSchuelermenge(long idKursID) {
        @NotNull ArrayList<@NotNull Schueler> list = new ArrayList<Schueler>();
        for (Long idSchueler : this.getKursE((long)idKursID).schueler) {
            list.add(this.getSchuelerG(idSchueler));
        }
        return list;
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisSchiene> getOfKursSchienenmenge(long idKurs) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_kursID_schienen, idKurs);
    }

    @NotNull
    public int[] getOfKursSchienenNummern(long idKurs) {
        @NotNull List<@NotNull Long> schienenIDs = this.getKursE((long)idKurs).schienen;
        int[] a = new int[schienenIDs.size()];
        for (int i = 0; i < a.length; ++i) {
            long schienenID = schienenIDs.get(i);
            a[i] = this._parent.schieneGet((long)schienenID).nummer;
        }
        return a;
    }

    public boolean getOfKursHatKollision(long idKurs) {
        return this.getOfKursAnzahlKollisionen(idKurs) > 0;
    }

    public int getOfKursAnzahlKollisionen(long idKurs) {
        return this.getOfKursSchuelermengeMitKollisionen(idKurs).size();
    }

    @NotNull
    public @NotNull Set<@NotNull Long> getOfKursSchuelermengeMitKollisionen(long idKursID) {
        @NotNull HashSet<@NotNull Long> set = new HashSet<Long>();
        for (GostBlockungsergebnisSchiene schiene : this.getOfKursSchienenmenge(idKursID)) {
            for (Long idSchueler : this.getKursE((long)idKursID).schueler) {
                if (this.getOfSchuelerOfSchieneKursmenge(idSchueler, schiene.id).size() <= 1) continue;
                set.add(idSchueler);
            }
        }
        return set;
    }

    public int getOfKursAnzahlSchueler(long idKurs) {
        return this.getKursE((long)idKurs).schueler.size();
    }

    public int getOfKursAnzahlSchuelerExterne(long idKurs) {
        @NotNull GostBlockungsergebnisKurs kursE = this.getKursE(idKurs);
        return ListUtils.getCountFiltered(kursE.schueler, idSchueler -> this.getOfSchuelerHatStatusExtern((Long)idSchueler));
    }

    public int getOfKursAnzahlSchuelerNichtExtern(long idKurs) {
        @NotNull GostBlockungsergebnisKurs kursE = this.getKursE(idKurs);
        return ListUtils.getCountFiltered(kursE.schueler, idSchueler -> !this.getOfSchuelerHatStatusExtern((Long)idSchueler));
    }

    public int getOfKursAnzahlSchuelerDummy(long idKurs) {
        return MapUtils.getOrDefault(this._map_kursID_dummySuS, idKurs, 0);
    }

    public int getOfKursAnzahlSchuelerMaennlich(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", Geschlecht.M, null);
    }

    public int getOfKursAnzahlSchuelerWeiblich(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", Geschlecht.W, null);
    }

    public int getOfKursAnzahlSchuelerDivers(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", Geschlecht.D, null);
    }

    public int getOfKursAnzahlSchuelerOhneAngabe(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", Geschlecht.X, null);
    }

    public int getOfKursAnzahlSchuelerSchriftlich(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", null, GostSchriftlichkeit.SCHRIFTLICH);
    }

    public int getOfKursAnzahlSchuelerMuendlich(long idKurs) {
        return this.getOfSchuelerAnzahlGefiltert(idKurs, -1L, -1, 0, "", null, GostSchriftlichkeit.MUENDLICH);
    }

    public int getOfKursAnzahlSchienenIst(long idKurs) {
        return this.getOfKursSchienenmenge(idKurs).size();
    }

    public int getOfKursAnzahlSchienenSoll(long idKurs) {
        return this.getKursE((long)idKurs).anzahlSchienen;
    }

    public int getOfKursAnzahlSchuelerAbiturLK(long idKurs) {
        int summe = 0;
        for (Long idSchueler : this.getKursE((long)idKurs).schueler) {
            @NotNull GostFachwahl fachwahl = this.getOfSchuelerOfKursFachwahl(idSchueler, idKurs);
            if (fachwahl.abiturfach == null || fachwahl.abiturfach != 1 && fachwahl.abiturfach != 2) continue;
            ++summe;
        }
        return summe;
    }

    public int getOfKursAnzahlSchuelerAbitur3(long idKurs) {
        int summe = 0;
        for (Long idSchueler : this.getKursE((long)idKurs).schueler) {
            @NotNull GostFachwahl fachwahl = this.getOfSchuelerOfKursFachwahl(idSchueler, idKurs);
            if (fachwahl.abiturfach == null || fachwahl.abiturfach != 3) continue;
            ++summe;
        }
        return summe;
    }

    public int getOfKursAnzahlSchuelerAbitur4(long idKurs) {
        int summe = 0;
        for (Long idSchueler : this.getKursE((long)idKurs).schueler) {
            @NotNull GostFachwahl fachwahl = this.getOfSchuelerOfKursFachwahl(idSchueler, idKurs);
            if (fachwahl.abiturfach == null || fachwahl.abiturfach != 4) continue;
            ++summe;
        }
        return summe;
    }

    public boolean getOfKursRemoveAllowed(long idKurs) throws DeveloperNotificationException {
        return this.getOfKursAnzahlSchueler(idKurs) == 0;
    }

    @NotNull
    public @NotNull List<@NotNull Schueler> getOfKursMengeAllerNichtFixiertenSchueler(long idKurs) {
        @NotNull ArrayList<@NotNull Schueler> list = new ArrayList<Schueler>();
        for (Schueler schueler : this.getOfKursSchuelermenge(idKurs)) {
            if (this.getOfSchuelerOfKursIstFixiert(schueler.id, idKurs)) continue;
            list.add(schueler);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull Schueler> getOfKursMengeAllerNichtFixiertenAbiturSchueler(long idKurs) {
        @NotNull ArrayList<@NotNull Schueler> list = new ArrayList<Schueler>();
        for (Schueler schueler : this.getOfKursSchuelermenge(idKurs)) {
            if (this.getOfSchuelerOfKursIstFixiert(schueler.id, idKurs) || !this.getOfSchuelerOfKursIstAbiturfach(schueler.id, idKurs)) continue;
            list.add(schueler);
        }
        return list;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull Set<@NotNull Long>> getMappingKursIDSchuelerIDs() {
        return this._map_kursID_schuelerIDs;
    }

    @NotNull
    public @NotNull Map<@NotNull Long, @NotNull Set<@NotNull GostBlockungsergebnisSchiene>> getMappingKursIDSchienenmenge() {
        return this._map_kursID_schienen;
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisKurs> getMengeDerKurseMitKollisionen() {
        @NotNull HashSet<@NotNull GostBlockungsergebnisKurs> set = new HashSet<GostBlockungsergebnisKurs>();
        for (GostBlockungsergebnisKurs kurs : this._map_kursID_kurs.values()) {
            if (!this.getOfKursHatKollision(kurs.id)) continue;
            set.add(kurs);
        }
        return set;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAllerKursSchienenFixierungen() {
        return new ArrayList<GostBlockungRegel>(this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE));
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAnKursSchienenFixierungenDesKurses(long idKurs) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungRegel regel : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE)) {
            if (regel.parameter.get(0) != idKurs) continue;
            list.add(regel);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAnKursSchienenFixierungenDerKurse(@NotNull @NotNull List<@NotNull Long> listeDerKursIDs) {
        @NotNull HashSet<@NotNull Long> setKursIDs = new HashSet<Long>(listeDerKursIDs);
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungRegel regel : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE)) {
            if (!setKursIDs.contains(regel.parameter.get(0))) continue;
            list.add(regel);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAllerSchuelerKursFixierungen() {
        return new ArrayList<GostBlockungRegel>(this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS));
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAllerSchuelerKursFixierungenDesKurses(long idKurs) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungRegel regel : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS)) {
            if (regel.parameter.get(1) != idKurs) continue;
            list.add(regel);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetMengeAllerSchuelerKursFixierungenDerKurse(@NotNull @NotNull List<@NotNull Long> listeDerKursIDs) {
        @NotNull HashSet<@NotNull Long> setKursIDs = new HashSet<Long>(listeDerKursIDs);
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungRegel regel : this._parent.regelGetListeOfTyp(GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS)) {
            if (!setKursIDs.contains(regel.parameter.get(1))) continue;
            list.add(regel);
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAllerKursSchienenFixierungen() {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungsergebnisKurs kurs : this._map_kursID_kurs.values()) {
            for (GostBlockungsergebnisSchiene schiene : this.getOfKursSchienenmenge(kurs.id)) {
                if (this.getOfKursOfSchieneIstFixiert(kurs.id, schiene.id)) continue;
                long schienenNr = this._parent.schieneGet((long)schiene.id).nummer;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ;
                regel.parameter.add(kurs.id);
                regel.parameter.add(schienenNr);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAnKursSchienenFixierungen(@NotNull @NotNull List<@NotNull Long> listeDerKursIDs) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (Long idKurs : listeDerKursIDs) {
            for (GostBlockungsergebnisSchiene schiene : this.getOfKursSchienenmenge(idKurs)) {
                if (this.getOfKursOfSchieneIstFixiert(idKurs, schiene.id)) continue;
                long schienenNr = this._parent.schieneGet((long)schiene.id).nummer;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE.typ;
                regel.parameter.add(idKurs);
                regel.parameter.add(schienenNr);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAllerSchuelerKursFixierungen() {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungsergebnisKurs kurs : this._map_kursID_kurs.values()) {
            for (Schueler schueler : this.getOfKursSchuelermenge(kurs.id)) {
                if (this.getOfSchuelerOfKursIstFixiert(schueler.id, kurs.id)) continue;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ;
                regel.parameter.add(schueler.id);
                regel.parameter.add(kurs.id);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAllerSchuelerAbiturKursFixierungen() {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (GostBlockungsergebnisKurs kurs : this._map_kursID_kurs.values()) {
            for (Schueler schueler : this.getOfKursSchuelermenge(kurs.id)) {
                if (!this.getOfSchuelerOfKursIstAbiturfach(schueler.id, kurs.id) || this.getOfSchuelerOfKursIstFixiert(schueler.id, kurs.id)) continue;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ;
                regel.parameter.add(schueler.id);
                regel.parameter.add(kurs.id);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAnKursSchuelerFixierungen(@NotNull @NotNull List<@NotNull Long> listeDerKursIDs) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (Long idKurs : listeDerKursIDs) {
            for (Schueler schueler : this.getOfKursSchuelermenge(idKurs)) {
                if (this.getOfSchuelerOfKursIstFixiert(schueler.id, idKurs)) continue;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ;
                regel.parameter.add(schueler.id);
                regel.parameter.add(idKurs);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungRegel> regelGetDummyMengeAnAbiturKursSchuelerFixierungen(@NotNull @NotNull List<@NotNull Long> listeDerKursIDs) {
        @NotNull ArrayList<@NotNull GostBlockungRegel> list = new ArrayList<GostBlockungRegel>();
        for (Long idKurs : listeDerKursIDs) {
            for (Schueler schueler : this.getOfKursSchuelermenge(idKurs)) {
                if (!this.getOfSchuelerOfKursIstAbiturfach(schueler.id, idKurs) || this.getOfSchuelerOfKursIstFixiert(schueler.id, idKurs)) continue;
                @NotNull GostBlockungRegel regel = new GostBlockungRegel();
                regel.id = -1L;
                regel.typ = GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ;
                regel.parameter.add(schueler.id);
                regel.parameter.add(idKurs);
                list.add(regel);
            }
        }
        return list;
    }

    @NotNull
    public GostBlockungSchiene getSchieneG(long idSchiene) throws DeveloperNotificationException {
        return this._parent.schieneGet(idSchiene);
    }

    @NotNull
    public GostBlockungsergebnisSchiene getSchieneE(long idSchiene) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schienenID_schiene, idSchiene);
    }

    @NotNull
    public GostBlockungsergebnisSchiene getSchieneEmitNr(int nrSchiene) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schienenNr_schiene, nrSchiene);
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisSchiene> getMengeAllerSchienen() {
        return this._ergebnis.schienen;
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisSchiene> getMengeDerSchienenMitKollisionen() {
        return CollectionUtils.toFilteredHashSet(this._map_schienenID_schiene.values(), s -> this.getOfSchieneHatKollision(s.id));
    }

    public int getOfSchieneAnzahlSchueler(long idSchiene) {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schienenID_schuelerAnzahl, idSchiene);
    }

    public int getOfSchieneAnzahl() {
        return this._map_schienenID_schiene.size();
    }

    public boolean getOfSchieneHatKollision(long idSchiene) {
        return this.getOfSchieneAnzahlSchuelerMitKollisionen(idSchiene) > 0;
    }

    public int getOfSchieneAnzahlSchuelerMitKollisionen(long idSchiene) {
        return DeveloperNotificationException.ifMapGetIsNull(this._map_schienenID_kollisionen, idSchiene);
    }

    @NotNull
    public @NotNull Set<@NotNull Long> getOfSchieneSchuelermengeMitKollisionen(long idSchiene) {
        @NotNull HashSet<@NotNull Long> set = new HashSet<Long>();
        for (Long schuelerID : this._map_schuelerID_kollisionen.keySet()) {
            if (this.getOfSchuelerOfSchieneKursmenge(schuelerID, idSchiene).size() <= 1) continue;
            set.add(schuelerID);
        }
        return set;
    }

    public int getOfSchieneAnzahlKursmengeMitKollisionen(long idSchiene) {
        return this.getOfSchieneKursmengeMitKollisionen(idSchiene).size();
    }

    @NotNull
    public @NotNull Set<@NotNull GostBlockungsergebnisKurs> getOfSchieneKursmengeMitKollisionen(long idSchiene) {
        @NotNull HashSet<@NotNull GostBlockungsergebnisKurs> set = new HashSet<GostBlockungsergebnisKurs>();
        for (GostBlockungsergebnisKurs kurs : this.getSchieneE((long)idSchiene).kurse) {
            if (!this.getOfKursHatKollision(kurs.id)) continue;
            set.add(kurs);
        }
        return set;
    }

    @NotNull
    public @NotNull List<@NotNull GostBlockungsergebnisKurs> getOfSchieneKursmengeSortiert(long idSchiene) {
        return this.getSchieneE((long)idSchiene).kurse;
    }

    public boolean getOfSchieneRemoveAllowed(long idSchiene) throws DeveloperNotificationException {
        return this.getSchieneE((long)idSchiene).kurse.isEmpty();
    }

    public int getOfSchieneMaxKursanzahl() {
        int max = 0;
        for (GostBlockungsergebnisSchiene schiene : this._ergebnis.schienen) {
            max = Math.max(max, schiene.kurse.size());
        }
        return max;
    }

    public int getOfSchieneAnzahlSchuelerExterne(long idSchiene) {
        int summe = 0;
        for (GostBlockungsergebnisKurs kurs : this.getSchieneE((long)idSchiene).kurse) {
            for (long idSchueler : kurs.schueler) {
                if (!this.getOfSchuelerHatStatusExtern(idSchueler)) continue;
                ++summe;
            }
        }
        return summe;
    }

    public int getOfSchieneAnzahlSchuelerDummy(long idSchiene) {
        int summe = 0;
        for (GostBlockungsergebnisKurs kurs : this.getSchieneE((long)idSchiene).kurse) {
            summe += this.getOfKursAnzahlSchuelerDummy(kurs.id);
        }
        return summe;
    }

    public void setKursSchienenNr(long kursID, int schienenNr) throws DeveloperNotificationException {
        @NotNull GostBlockungsergebnisSchiene eSchiene = DeveloperNotificationException.ifMapGetIsNull(this._map_schienenNr_schiene, schienenNr);
        this.stateKursSchieneHinzufuegen(kursID, eSchiene.id);
    }

    public void setKursSchiene(long idKurs, long idSchiene, boolean hinzufuegenOderEntfernen) throws DeveloperNotificationException {
        if (hinzufuegenOderEntfernen) {
            this.stateKursSchieneHinzufuegen(idKurs, idSchiene);
        } else {
            this.stateKursSchieneEntfernen(idKurs, idSchiene);
        }
    }

    public void setSchuelerKurs(long idSchueler, long idKurs, boolean hinzufuegenOderEntfernen) throws DeveloperNotificationException {
        if (hinzufuegenOderEntfernen) {
            this.stateSchuelerKursHinzufuegen(idSchueler, idKurs);
        } else {
            this.stateSchuelerKursEntfernen(idSchueler, idKurs);
        }
    }

    public void setSchuelerNeuzuordnung(long idSchueler, @NotNull SchuelerblockungOutput zuordnung) {
        for (SchuelerblockungOutputFachwahlZuKurs z : zuordnung.fachwahlenZuKurs) {
            GostBlockungsergebnisKurs kursN;
            GostBlockungsergebnisKurs kursV = this.getOfSchuelerOfFachZugeordneterKurs(idSchueler, z.fachID);
            if (kursV == (kursN = z.kursID < 0L ? null : this.getKursE(z.kursID))) continue;
            if (kursV != null) {
                this.setSchuelerKurs(idSchueler, kursV.id, false);
            }
            if (kursN == null) continue;
            this.setSchuelerKurs(idSchueler, kursN.id, true);
        }
    }

    public void setAddSchieneByID(long idSchiene) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Schiene " + idSchiene + " muss erst beim Datenmanager hinzugef\u00fcgt werden!", !this._parent.schieneGetExistiert(idSchiene));
        this.stateRevalidateEverything();
    }

    public void setRemoveSchieneByID(long idSchiene) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Schiene " + idSchiene + " muss erst beim Datenmanager entfernt werden!", this._parent.schieneGetExistiert(idSchiene));
        int nKurse = this.getSchieneE((long)idSchiene).kurse.size();
        DeveloperNotificationException.ifTrue("Entfernen unm\u00f6glich: Schiene " + idSchiene + " hat noch " + nKurse + " Kurse!", nKurse > 0);
        this.stateRevalidateEverything();
    }

    public void setAddRegelByID(long idRegel) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Regel " + idRegel + " muss erst beim Datenmanager hinzugef\u00fcgt werden!", !this._parent.regelGetExistiert(idRegel));
        this.stateRevalidateEverything();
    }

    public void setAddRegelmenge(@NotNull @NotNull List<@NotNull GostBlockungRegel> regelmenge) throws DeveloperNotificationException {
        for (GostBlockungRegel regel : regelmenge) {
            DeveloperNotificationException.ifTrue("Die Regel " + regel.id + " muss erst beim Datenmanager hinzugef\u00fcgt werden!", !this._parent.regelGetExistiert(regel.id));
        }
        this.stateRevalidateEverything();
    }

    public void setRemoveRegelByID(long idRegel) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Die Regel " + idRegel + " muss erst beim Datenmanager entfernt werden!", this._parent.regelGetExistiert(idRegel));
        this.stateRevalidateEverything();
    }

    public void setRemoveRegelmenge(@NotNull @NotNull List<@NotNull GostBlockungRegel> regelmenge) throws DeveloperNotificationException {
        for (GostBlockungRegel regel : regelmenge) {
            DeveloperNotificationException.ifTrue("Die Regel " + regel.id + " muss erst beim Datenmanager entfernt werden!", this._parent.regelGetExistiert(regel.id));
        }
        this.stateRevalidateEverything();
    }

    public void setAddKursByID(long idKurs) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Der Kurs " + idKurs + " muss erst beim Datenmanager hinzugef\u00fcgt werden!", !this._parent.kursGetExistiert(idKurs));
        @NotNull GostBlockungKurs kurs = this._parent.kursGet(idKurs);
        int nSchienen = this._parent.schieneGetAnzahl();
        DeveloperNotificationException.ifTrue("Es gibt " + nSchienen + " Schienen, da passt ein Kurs mit " + kurs.anzahlSchienen + " nicht hinein!", nSchienen < kurs.anzahlSchienen);
        this.stateRevalidateEverything();
        for (int nr = 1; nr <= kurs.anzahlSchienen; ++nr) {
            this.setKursSchienenNr(idKurs, nr);
        }
    }

    public void setRemoveKursByID(long idKurs) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Der Kurs " + idKurs + " muss erst beim Datenmanager entfernt werden!", this._parent.kursGetExistiert(idKurs));
        @NotNull GostBlockungsergebnisKurs kurs = this.getKursE(idKurs);
        for (Long schienenID : kurs.schienen) {
            this.getSchieneE((long)schienenID.longValue()).kurse.remove(kurs);
        }
        this.stateRevalidateEverything();
    }

    public void setMergeKurseByID(long idKursID1keep, long idKursID2delete) {
        @NotNull GostBlockungsergebnisKurs kursDelete = this.getKursE(idKursID2delete);
        @NotNull GostBlockungsergebnisKurs kursKeep = this.getKursE(idKursID1keep);
        kursKeep.schueler.addAll(kursDelete.schueler);
        for (Long schienenID : kursDelete.schienen) {
            this.getSchieneE((long)schienenID.longValue()).kurse.remove(kursDelete);
        }
        this._parent.kursRemoveByID(idKursID2delete);
        this.stateRevalidateEverything();
    }

    public void setSplitKurs(@NotNull GostBlockungKurs kurs1alt, @NotNull GostBlockungKurs kurs2neu, @NotNull long[] susVon1nach2) {
        this._parent.kursAdd(kurs2neu);
        this.setAddKursByID(kurs2neu.id);
        for (long schuelerID : susVon1nach2) {
            this.stateSchuelerKursEntfernen(schuelerID, kurs1alt.id);
            this.stateSchuelerKursHinzufuegen(schuelerID, kurs2neu.id);
        }
    }

    public void patchOfKursSchienenAnzahl(long idKurs, int anzahlSchienenNeu) throws DeveloperNotificationException {
        GostBlockungsergebnisSchiene schiene;
        int nr;
        @NotNull GostBlockungKurs kursG = this.getKursG(idKurs);
        @NotNull GostBlockungsergebnisKurs kursE = this.getKursE(idKurs);
        int nSchienen = this._parent.schieneGetAnzahl();
        DeveloperNotificationException.ifTrue("Die Schienenanzahl eines Kurses darf nur bei der Blockungsvorlage ver\u00e4ndert werden!", !this._parent.getIstBlockungsVorlage());
        DeveloperNotificationException.ifTrue("Der GostBlockungKurs hat " + kursG.anzahlSchienen + " Schienen, der GostBlockungsergebnisKurs hat hingegen " + kursE.anzahlSchienen + " Schienen!", kursE.anzahlSchienen != kursG.anzahlSchienen);
        DeveloperNotificationException.ifTrue("Die Blockung hat 0 Schienen. Das darf nicht passieren!", nSchienen == 0);
        DeveloperNotificationException.ifTrue("Ein Kurs muss mindestens einer Schiene zugeordnet sein, statt " + anzahlSchienenNeu + " Schienen!", anzahlSchienenNeu <= 0);
        DeveloperNotificationException.ifTrue("Es gibt nur " + nSchienen + " Schienen, der Kurs kann nicht " + anzahlSchienenNeu + " Schienen zugeordnet werden!", anzahlSchienenNeu > nSchienen);
        while (anzahlSchienenNeu > kursG.anzahlSchienen) {
            boolean hinzugefuegt = false;
            for (nr = 1; nr <= this._map_schienenNr_schiene.size() && !hinzugefuegt; ++nr) {
                schiene = this.getSchieneEmitNr(nr);
                if (kursE.schienen.contains(schiene.id)) continue;
                hinzugefuegt = true;
                ++kursG.anzahlSchienen;
                ++kursE.anzahlSchienen;
                this.setKursSchiene(idKurs, schiene.id, true);
            }
            DeveloperNotificationException.ifTrue("Es wurde keine freie Schiene f\u00fcr den Kurs " + idKurs + " gefunden!", !hinzugefuegt);
        }
        while (anzahlSchienenNeu < kursG.anzahlSchienen) {
            boolean entfernt = false;
            for (nr = this._map_schienenNr_schiene.size(); nr >= 1 && !entfernt; --nr) {
                schiene = this.getSchieneEmitNr(nr);
                if (!kursE.schienen.contains(schiene.id)) continue;
                entfernt = true;
                --kursG.anzahlSchienen;
                --kursE.anzahlSchienen;
                this.setKursSchiene(idKurs, schiene.id, false);
            }
            DeveloperNotificationException.ifTrue("Es wurde keine belegte Schiene von Kurs " + idKurs + " gefunden!", !entfernt);
        }
    }

    public void patchOfKursLehrkaefteChanged() {
        this.stateRevalidateEverything();
    }

    public void debug(@NotNull Logger logger) {
        logger.modifyIndent(4);
        logger.logLn("----- Kurse sortiert nach Fachart -----");
        for (Long fachartID : this._map_fachartID_kurse.keySet()) {
            logger.logLn("FachartID = " + fachartID + " (KD = " + this.getOfFachartKursdifferenz(fachartID) + ")");
            for (GostBlockungsergebnisKurs kurs : this.getOfFachartKursmenge(fachartID)) {
                logger.logLn("    " + this.getOfKursName(kurs.id) + " : " + kurs.schueler.size() + " SuS");
            }
        }
        logger.logLn("KursdifferenzMax = " + this._ergebnis.bewertung.kursdifferenzMax);
        logger.logLn("KursdifferenzHistogramm = " + Arrays.toString(this._ergebnis.bewertung.kursdifferenzHistogramm));
        logger.modifyIndent(-4);
    }
}

