/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import jakarta.validation.constraints.NotNull;

public final class GostFachUtils {
    private GostFachUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static boolean istProjektkurs(@NotNull GostFach fach) {
        return "PX".equals(fach.kuerzel);
    }

    public static boolean istVertiefungskurs(@NotNull GostFach fach) {
        return "VX".equals(fach.kuerzel);
    }

    public static boolean istDurchgehendBelegbarBisQ22(GostFach fach) {
        if (fach == null) {
            return false;
        }
        return fach.istMoeglichEF1 && fach.istMoeglichEF2 && fach.istMoeglichQ11 && fach.istMoeglichQ12 && fach.istMoeglichQ21 && fach.istMoeglichQ22;
    }

    public static boolean istBelegbarBisEF2(@NotNull GostFach fach) {
        return fach.istMoeglichEF1 && fach.istMoeglichEF2;
    }

    public static boolean istFremdsprachenfach(GostFach fach, String sprache) {
        if (fach == null || fach.kuerzel == null || "".equals(fach.kuerzel) || !GostFachbereich.FREMDSPRACHE.hat(fach) || sprache == null) {
            return false;
        }
        return sprache.compareToIgnoreCase(fach.kuerzel.substring(0, 1)) == 0;
    }

    public static String getFremdsprache(@NotNull GostFach fach) {
        if (fach.kuerzel == null || "".equals(fach.kuerzel) || !GostFachbereich.FREMDSPRACHE.hat(fach)) {
            return null;
        }
        return fach.kuerzel.substring(0, 1).toUpperCase();
    }

    public static boolean istBilingual(@NotNull GostFach fach) {
        return fach.biliSprache != null && !"".equals(fach.biliSprache) && !"D".equals(fach.biliSprache);
    }

    public static boolean istWaehlbar(GostFach fach, @NotNull GostHalbjahr halbjahr) {
        if (fach == null) {
            return false;
        }
        if (halbjahr == GostHalbjahr.EF1) {
            return fach.istMoeglichEF1;
        }
        if (halbjahr == GostHalbjahr.EF2) {
            return fach.istMoeglichEF2;
        }
        if (halbjahr == GostHalbjahr.Q11) {
            return fach.istMoeglichQ11;
        }
        if (halbjahr == GostHalbjahr.Q12) {
            return fach.istMoeglichQ12;
        }
        if (halbjahr == GostHalbjahr.Q21) {
            return fach.istMoeglichQ21;
        }
        if (halbjahr == GostHalbjahr.Q22) {
            return fach.istMoeglichQ22;
        }
        return false;
    }

    public static boolean istWaehlbarLeistungskurs1(GostFach fach) {
        return fach != null && fach.istMoeglichAbiLK && fach.istMoeglichQ11 && fach.istMoeglichQ12 && fach.istMoeglichQ21 && fach.istMoeglichQ22 && (GostFachbereich.FREMDSPRACHE.hat(fach) && !fach.istFremdSpracheNeuEinsetzend || GostFachbereich.MATHEMATIK.hat(fach) || GostFachbereich.NATURWISSENSCHAFTLICH.hat(fach) || GostFachbereich.DEUTSCH.hat(fach));
    }
}

