/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.gost.GostJahrgangFachwahlenHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GostFachwahlManager {
    @NotNull
    private final @NotNull ArrayList<@NotNull GostFachwahl> fachwahlen = new ArrayList();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ArrayMap<@NotNull GostKursart, @NotNull HashSet<@NotNull Long>>> mapFachKursart = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ArrayList<@NotNull GostFachwahl>> mapFach = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull ArrayList<@NotNull GostFachwahl>> mapSchueler = new HashMap();

    public GostFachwahlManager() {
    }

    public GostFachwahlManager(GostJahrgangFachwahlenHalbjahr fachwahlen) {
        for (GostFachwahl fw : fachwahlen.fachwahlen) {
            this.add(fw);
        }
    }

    public void add(GostFachwahl fachwahl) {
        GostKursart kursart;
        HashSet<Long> schueler;
        if (fachwahl == null) {
            return;
        }
        this.fachwahlen.add(fachwahl);
        ArrayList<@NotNull GostFachwahl> fwFach = this.mapFach.get(fachwahl.fachID);
        if (fwFach == null) {
            fwFach = new ArrayList();
            this.mapFach.put(fachwahl.fachID, fwFach);
        }
        fwFach.add(fachwahl);
        ArrayList<@NotNull GostFachwahl> fwSchueler = this.mapSchueler.get(fachwahl.schuelerID);
        if (fwSchueler == null) {
            fwSchueler = new ArrayList();
            this.mapSchueler.put(fachwahl.schuelerID, fwSchueler);
        }
        fwSchueler.add(fachwahl);
        ArrayMap<@NotNull GostKursart, @NotNull HashSet<@NotNull Long>> mapKursart = this.mapFachKursart.get(fachwahl.fachID);
        if (mapKursart == null) {
            mapKursart = new ArrayMap(GostKursart.values());
            this.mapFachKursart.put(fachwahl.fachID, mapKursart);
        }
        if ((schueler = mapKursart.get((Object)(kursart = GostKursart.fromFachwahlOrException(fachwahl)))) == null) {
            schueler = new HashSet();
            mapKursart.put(kursart, schueler);
        }
        schueler.add(fachwahl.schuelerID);
    }

    @NotNull
    public @NotNull List<@NotNull GostFachwahl> getFachwahlen(long idFach) {
        ArrayList<@NotNull E> fwFach = this.mapSchueler.get(idFach);
        return fwFach == null ? new ArrayList() : fwFach;
    }

    @NotNull
    public @NotNull List<@NotNull GostFachwahl> getSchuelerFachwahlen(long idSchueler) {
        ArrayList<@NotNull E> fwSchueler = this.mapSchueler.get(idSchueler);
        return fwSchueler == null ? new ArrayList() : fwSchueler;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean hatFachwahl(long idSchueler, long idFach, @NotNull GostKursart kursart) {
        @NotNull @NotNull @NotNull Map mapKursart = this.mapFachKursart.get(idFach);
        if (mapKursart == null) {
            return false;
        }
        @NotNull HashSet schueler = (HashSet)mapKursart.get((Object)kursart);
        if (schueler == null) {
            return false;
        }
        return schueler.contains(idSchueler);
    }
}

