/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostJahrgangFachkombination;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.fach.Fachgruppe;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.gost.GostFachbereich;
import de.svws_nrw.core.types.gost.GostLaufbahnplanungFachkombinationTyp;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class GostFaecherManager {
    @NotNull
    public static final @NotNull Comparator<@NotNull GostFach> comp = (a, b) -> {
        int va = a == null ? Integer.MIN_VALUE : a.sortierung;
        int vb = b == null ? Integer.MIN_VALUE : b.sortierung;
        return Integer.compare(va, vb);
    };
    @NotNull
    private final @NotNull List<@NotNull GostFach> _faecher = new ArrayList<GostFach>();
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull GostFach> _map = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull List<@NotNull GostFach>> _mapByKuerzel = new HashMap();
    @NotNull
    private final @NotNull HashMap<@NotNull String, @NotNull List<@NotNull GostFach>> _mapBySprachkuerzel = new HashMap();
    @NotNull
    private final @NotNull List<@NotNull GostFach> _leitfaecher = new ArrayList<GostFach>();
    @NotNull
    private final @NotNull List<@NotNull GostJahrgangFachkombination> _fachkombis = new ArrayList<GostJahrgangFachkombination>();
    @NotNull
    private final @NotNull List<@NotNull GostJahrgangFachkombination> _fachkombisErforderlich = new ArrayList<GostJahrgangFachkombination>();
    @NotNull
    private final @NotNull List<@NotNull GostJahrgangFachkombination> _fachkombisVerboten = new ArrayList<GostJahrgangFachkombination>();

    public GostFaecherManager() {
    }

    public GostFaecherManager(@NotNull @NotNull List<@NotNull GostFach> faecher) {
        this.addAll(faecher);
    }

    public GostFaecherManager(@NotNull @NotNull List<@NotNull GostFach> faecher, @NotNull @NotNull List<@NotNull GostJahrgangFachkombination> fachkombis) {
        this.addAll(faecher);
        this.addFachkombinationenAll(fachkombis);
    }

    private boolean addFachInternal(@NotNull GostFach fach) throws DeveloperNotificationException {
        Fachgruppe fg;
        DeveloperNotificationException.ifSmaller("fach.id", fach.id, 0L);
        if (this._map.containsKey(fach.id)) {
            return false;
        }
        this._map.put(fach.id, fach);
        @NotNull ZulaessigesFach zf = ZulaessigesFach.getByKuerzelASD(fach.kuerzel);
        List<@NotNull GostFach> listForKuerzel = this._mapByKuerzel.get(fach.kuerzel);
        if (listForKuerzel == null) {
            listForKuerzel = new ArrayList<GostFach>();
            this._mapByKuerzel.put(fach.kuerzel, listForKuerzel);
        }
        listForKuerzel.add(fach);
        if (fach.istFremdsprache && zf.daten.istFremdsprache) {
            List<@NotNull GostFach> listForSprachkuerzel = this._mapBySprachkuerzel.get(zf.daten.kuerzel);
            if (listForSprachkuerzel == null) {
                listForSprachkuerzel = new ArrayList<GostFach>();
                this._mapBySprachkuerzel.put(zf.daten.kuerzel, listForSprachkuerzel);
            }
            listForSprachkuerzel.add(fach);
        }
        boolean added = this._faecher.add(fach);
        if (!GostFachbereich.LITERARISCH_KUENSTLERISCH_ERSATZ.hat(fach) && (fg = ZulaessigesFach.getByKuerzelASD(fach.kuerzel).getFachgruppe()) != Fachgruppe.FG_VX && fg != Fachgruppe.FG_PX) {
            this._leitfaecher.add(fach);
        }
        return added;
    }

    private void sort() {
        this._faecher.sort(comp);
        this._leitfaecher.sort(comp);
    }

    private boolean addFachkombinationInternal(@NotNull GostJahrgangFachkombination fachkombi) throws DeveloperNotificationException {
        DeveloperNotificationException.ifSmaller("fachkombi.fachID1", fachkombi.fachID1, 0L);
        DeveloperNotificationException.ifSmaller("fachkombi.fachID2", fachkombi.fachID2, 0L);
        DeveloperNotificationException.ifMapNotContains("_map", this._map, fachkombi.fachID1);
        DeveloperNotificationException.ifMapNotContains("_map", this._map, fachkombi.fachID2);
        DeveloperNotificationException.ifNotInRange("fachkombi.typ", fachkombi.typ, 0L, 1L);
        @NotNull GostLaufbahnplanungFachkombinationTyp typ = GostLaufbahnplanungFachkombinationTyp.fromValue(fachkombi.typ);
        if (fachkombi.hinweistext.isBlank()) {
            @NotNull GostFach fach1 = this.getOrException(fachkombi.fachID1);
            @NotNull GostFach fach2 = this.getOrException(fachkombi.fachID2);
            @NotNull String kursart1 = fachkombi.kursart1 == null || fachkombi.kursart1.isBlank() ? "" : " als " + fachkombi.kursart1;
            @NotNull String kursart2 = fachkombi.kursart2 == null || fachkombi.kursart2.isBlank() ? "" : " als " + fachkombi.kursart2;
            fachkombi.hinweistext = fach1.kuerzelAnzeige + kursart1 + (typ == GostLaufbahnplanungFachkombinationTyp.ERFORDERLICH ? " erfordert " : " erlaubt kein ") + fach2.kuerzelAnzeige + kursart2;
        }
        if (typ == GostLaufbahnplanungFachkombinationTyp.ERFORDERLICH) {
            this._fachkombisErforderlich.add(fachkombi);
        } else if (typ == GostLaufbahnplanungFachkombinationTyp.VERBOTEN) {
            this._fachkombisVerboten.add(fachkombi);
        }
        return this._fachkombis.add(fachkombi);
    }

    public boolean add(@NotNull GostFach fach) {
        boolean result = this.addFachInternal(fach);
        this.sort();
        return result;
    }

    public boolean addAll(@NotNull @NotNull Collection<@NotNull GostFach> faecher) {
        boolean result = true;
        for (GostFach fach : faecher) {
            if (this.addFachInternal(fach)) continue;
            result = false;
        }
        this.sort();
        return result;
    }

    public boolean add(@NotNull GostJahrgangFachkombination fachkombi) {
        return this.addFachkombinationInternal(fachkombi);
    }

    public boolean addFachkombinationenAll(@NotNull @NotNull List<@NotNull GostJahrgangFachkombination> fachkombis) {
        boolean result = true;
        for (GostJahrgangFachkombination fachkombi : fachkombis) {
            if (this.addFachkombinationInternal(fachkombi)) continue;
            result = false;
        }
        return result;
    }

    public GostFach get(long id) {
        return this._map.get(id);
    }

    @NotNull
    public GostFach getOrException(long idFach) throws DeveloperNotificationException {
        return DeveloperNotificationException.ifMapGetIsNull(this._map, idFach);
    }

    @NotNull
    public @NotNull List<@NotNull GostFach> getByKuerzel(@NotNull String kuerzel) {
        ArrayList<@NotNull E> faecher = this._mapByKuerzel.get(kuerzel);
        return faecher == null ? new ArrayList() : faecher;
    }

    @NotNull
    public @NotNull List<@NotNull GostFach> getBySprachkuerzel(@NotNull String sprache) {
        ArrayList<@NotNull E> faecher = this._mapBySprachkuerzel.get(sprache);
        return faecher == null ? new ArrayList() : faecher;
    }

    public boolean isEmpty() {
        return this._faecher.isEmpty();
    }

    @NotNull
    public @NotNull List<@NotNull GostFach> faecher() {
        return this._faecher;
    }

    @NotNull
    public @NotNull List<@NotNull GostFach> getFaecherSchriftlichMoeglich() {
        @NotNull ArrayList<@NotNull GostFach> faecherSchriftlichMoeglich = new ArrayList<GostFach>();
        for (GostFach f : this._faecher) {
            ZulaessigesFach zf = ZulaessigesFach.getByKuerzelASD(f.kuerzel);
            if (zf == ZulaessigesFach.PX || zf == ZulaessigesFach.VX || zf == ZulaessigesFach.VO || zf == ZulaessigesFach.IN) continue;
            faecherSchriftlichMoeglich.add(f);
        }
        return faecherSchriftlichMoeglich;
    }

    @NotNull
    public @NotNull List<@NotNull GostFach> getLeitfaecher() {
        return this._leitfaecher;
    }

    @NotNull
    public @NotNull List<@NotNull String> getFremdsprachenkuerzel() {
        @NotNull ArrayList<@NotNull String> result = new ArrayList<String>();
        result.addAll(this._mapBySprachkuerzel.keySet());
        result.sort((a, b) -> a.compareToIgnoreCase((String)b));
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull GostJahrgangFachkombination> getFachkombinationen() {
        return this._fachkombis;
    }

    @NotNull
    public @NotNull List<@NotNull GostJahrgangFachkombination> getFachkombinationenErforderlich() {
        return this._fachkombisErforderlich;
    }

    @NotNull
    public @NotNull List<@NotNull GostJahrgangFachkombination> getFachkombinationenVerboten() {
        return this._fachkombisVerboten;
    }

    public boolean fachIstProjektkurs(long id) {
        GostFach fach = this._map.get(id);
        if (fach == null) {
            return false;
        }
        return "PX".equals(fach.kuerzel);
    }

    public boolean fachIstVertiefungskurs(long id) {
        GostFach fach = this._map.get(id);
        if (fach == null) {
            return false;
        }
        return "VX".equals(fach.kuerzel);
    }
}

