/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.gost;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.gost.GostJahrgangFachwahlen;
import de.svws_nrw.core.data.gost.GostJahrgangFachwahlenHalbjahr;
import de.svws_nrw.core.types.gost.GostAbiturFach;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

public class GostJahrgangsFachwahlenManager {
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_fachID_abifachID_schuelerID = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_lk_fachID_halbjahrID_schuelerID = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_gk_fachID_halbjahrID_schuelerID = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_gk_schriftlich_fachID_halbjahrID_schuelerID = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_gk_muendlich_fachID_halbjahrID_schuelerID = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull List<@NotNull Long>> _map2D_zk_fachID_halbjahrID_schuelerID = new HashMap2D();

    public GostJahrgangsFachwahlenManager(@NotNull GostJahrgangFachwahlen jgFachwahlen) {
        this.init(jgFachwahlen);
    }

    private void init(@NotNull GostJahrgangFachwahlen jgFachwahlen) {
        for (GostHalbjahr halbjahr : GostHalbjahr.values()) {
            GostJahrgangFachwahlenHalbjahr fwHalbjahr = jgFachwahlen.halbjahr[halbjahr.id];
            if (fwHalbjahr == null) continue;
            for (GostFachwahl fw : fwHalbjahr.fachwahlen) {
                List<Long> schuelerListe;
                GostKursart kursart = GostKursart.fromID(fw.kursartID);
                if (kursart == GostKursart.LK) {
                    schuelerListe = this._map2D_lk_fachID_halbjahrID_schuelerID.getOrNull(fw.fachID, halbjahr.id);
                    if (schuelerListe == null) {
                        schuelerListe = new ArrayList<Long>();
                        this._map2D_lk_fachID_halbjahrID_schuelerID.put(fw.fachID, halbjahr.id, schuelerListe);
                    }
                    schuelerListe.add(fw.schuelerID);
                    continue;
                }
                if (kursart == GostKursart.GK || kursart == GostKursart.PJK || kursart == GostKursart.VTF) {
                    schuelerListe = this._map2D_gk_fachID_halbjahrID_schuelerID.getOrNull(fw.fachID, halbjahr.id);
                    if (schuelerListe == null) {
                        schuelerListe = new ArrayList<Long>();
                        this._map2D_gk_fachID_halbjahrID_schuelerID.put(fw.fachID, halbjahr.id, schuelerListe);
                    }
                    schuelerListe.add(fw.schuelerID);
                    if (fw.istSchriftlich) {
                        schuelerListe = this._map2D_gk_schriftlich_fachID_halbjahrID_schuelerID.getOrNull(fw.fachID, halbjahr.id);
                        if (schuelerListe == null) {
                            schuelerListe = new ArrayList<Long>();
                            this._map2D_gk_schriftlich_fachID_halbjahrID_schuelerID.put(fw.fachID, halbjahr.id, schuelerListe);
                        }
                        schuelerListe.add(fw.schuelerID);
                        continue;
                    }
                    schuelerListe = this._map2D_gk_muendlich_fachID_halbjahrID_schuelerID.getOrNull(fw.fachID, halbjahr.id);
                    if (schuelerListe == null) {
                        schuelerListe = new ArrayList<Long>();
                        this._map2D_gk_muendlich_fachID_halbjahrID_schuelerID.put(fw.fachID, halbjahr.id, schuelerListe);
                    }
                    schuelerListe.add(fw.schuelerID);
                    continue;
                }
                if (kursart != GostKursart.ZK) continue;
                schuelerListe = this._map2D_zk_fachID_halbjahrID_schuelerID.getOrNull(fw.fachID, halbjahr.id);
                if (schuelerListe == null) {
                    schuelerListe = new ArrayList<Long>();
                    this._map2D_zk_fachID_halbjahrID_schuelerID.put(fw.fachID, halbjahr.id, schuelerListe);
                }
                schuelerListe.add(fw.schuelerID);
            }
        }
        for (GostFachwahl fw : jgFachwahlen.abitur.fachwahlen) {
            List<Long> schuelerListe;
            GostKursart kursart = GostKursart.fromID(fw.kursartID);
            GostAbiturFach abiFach = GostAbiturFach.LK1;
            if (kursart == GostKursart.GK) {
                GostAbiturFach gostAbiturFach = abiFach = fw.istSchriftlich ? GostAbiturFach.AB3 : GostAbiturFach.AB4;
            }
            if ((schuelerListe = this._map2D_fachID_abifachID_schuelerID.getOrNull(fw.fachID, abiFach.id)) == null) {
                schuelerListe = new ArrayList<Long>();
                this._map2D_fachID_abifachID_schuelerID.put(fw.fachID, abiFach.id, schuelerListe);
            }
            schuelerListe.add(fw.schuelerID);
        }
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeByFachAndAbifachAsListOrException(long idFach, @NotNull GostAbiturFach abifach) {
        List<Long> schuelerListe;
        int idAbifach = abifach.id;
        if (idAbifach == 2) {
            idAbifach = 1;
        }
        if ((schuelerListe = this._map2D_fachID_abifachID_schuelerID.getOrNull(idFach, idAbifach)) != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeLKByFachAndHalbjahrAsListOrException(long idFach, @NotNull GostHalbjahr halbjahr) {
        List<@NotNull Long> schuelerListe = this._map2D_lk_fachID_halbjahrID_schuelerID.getOrNull(idFach, halbjahr.id);
        if (schuelerListe != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeGKByFachAndHalbjahrAsListOrException(long idFach, @NotNull GostHalbjahr halbjahr) {
        List<@NotNull Long> schuelerListe = this._map2D_gk_fachID_halbjahrID_schuelerID.getOrNull(idFach, halbjahr.id);
        if (schuelerListe != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeGKSchriftlichByFachAndHalbjahrAsListOrException(long idFach, @NotNull GostHalbjahr halbjahr) {
        List<@NotNull Long> schuelerListe = this._map2D_gk_schriftlich_fachID_halbjahrID_schuelerID.getOrNull(idFach, halbjahr.id);
        if (schuelerListe != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeGKMuendlichByFachAndHalbjahrAsListOrException(long idFach, @NotNull GostHalbjahr halbjahr) {
        List<@NotNull Long> schuelerListe = this._map2D_gk_muendlich_fachID_halbjahrID_schuelerID.getOrNull(idFach, halbjahr.id);
        if (schuelerListe != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }

    @NotNull
    public @NotNull List<@NotNull Long> schuelerGetMengeZKByFachAndHalbjahrAsListOrException(long idFach, @NotNull GostHalbjahr halbjahr) {
        List<@NotNull Long> schuelerListe = this._map2D_zk_fachID_halbjahrID_schuelerID.getOrNull(idFach, halbjahr.id);
        if (schuelerListe != null) {
            return schuelerListe;
        }
        return new ArrayList<Long>();
    }
}

