/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.jahrgang;

import de.svws_nrw.core.data.jahrgang.JahrgangsListeEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.util.Comparator;

public final class JahrgangsUtils {
    @NotNull
    public static final @NotNull Comparator<@NotNull JahrgangsListeEintrag> comparator = (a, b) -> {
        int cmp = a.sortierung - b.sortierung;
        if (cmp != 0) {
            return cmp;
        }
        if (a.kuerzel == null || b.kuerzel == null) {
            return Long.compare(a.id, b.id);
        }
        cmp = a.kuerzel.compareTo(b.kuerzel);
        return cmp == 0 ? Long.compare(a.id, b.id) : cmp;
    };

    private JahrgangsUtils() {
        throw new IllegalStateException("Instantiation not allowed");
    }

    public static Integer getRestlicheJahre(@NotNull Schulform schulform, @NotNull Schulgliederung gliederung, @NotNull String jahrgang) {
        if (gliederung == null) {
            return null;
        }
        if (schulform == Schulform.FW || schulform == Schulform.WB || schulform == Schulform.BK || schulform == Schulform.SB) {
            return null;
        }
        if (jahrgang == null) {
            return null;
        }
        if (schulform == Schulform.GY) {
            switch (jahrgang) {
                case "05": {
                    return gliederung.istG8() || gliederung == Schulgliederung.DEFAULT ? 8 : 9;
                }
                case "06": {
                    return gliederung.istG8() || gliederung == Schulgliederung.DEFAULT ? 7 : 8;
                }
                case "07": {
                    return gliederung.istG8() || gliederung == Schulgliederung.DEFAULT ? 6 : 7;
                }
                case "08": {
                    return gliederung.istG8() || gliederung == Schulgliederung.DEFAULT ? 5 : 6;
                }
                case "09": {
                    return gliederung.istG8() || gliederung == Schulgliederung.DEFAULT ? 4 : 5;
                }
                case "10": {
                    return gliederung.istG8() ? null : Integer.valueOf(4);
                }
                case "EF": {
                    return 3;
                }
                case "Q1": {
                    return 2;
                }
                case "Q2": {
                    return 1;
                }
                case "11": {
                    return 3;
                }
                case "12": {
                    return 2;
                }
                case "13": {
                    return 1;
                }
            }
            return null;
        }
        switch (jahrgang) {
            case "E1": {
                return 4;
            }
            case "E2": {
                return 3;
            }
            case "E3": {
                return 3;
            }
            case "03": {
                return 2;
            }
            case "04": {
                return 1;
            }
            case "05": {
                return 6;
            }
            case "06": {
                return 5;
            }
            case "07": {
                return 4;
            }
            case "08": {
                return 3;
            }
            case "09": {
                return 2;
            }
            case "10": {
                return 1;
            }
            case "EF": {
                return 3;
            }
            case "Q1": {
                return 2;
            }
            case "Q2": {
                return 1;
            }
            case "11": {
                return 3;
            }
            case "12": {
                return 2;
            }
            case "13": {
                return 1;
            }
        }
        return null;
    }
}

