/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klassen;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.jahrgang.JahrgangsListeEintrag;
import de.svws_nrw.core.data.klassen.KlassenDaten;
import de.svws_nrw.core.data.klassen.KlassenListeEintrag;
import de.svws_nrw.core.data.lehrer.LehrerListeEintrag;
import de.svws_nrw.core.data.schueler.Schueler;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import de.svws_nrw.core.utils.AttributMitAuswahl;
import de.svws_nrw.core.utils.AuswahlManager;
import de.svws_nrw.core.utils.jahrgang.JahrgangsUtils;
import de.svws_nrw.core.utils.klassen.KlassenUtils;
import de.svws_nrw.core.utils.lehrer.LehrerUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class KlassenListeManager
extends AuswahlManager<Long, KlassenListeEintrag, KlassenDaten> {
    @NotNull
    private static final @NotNull Function<@NotNull KlassenListeEintrag, @NotNull Long> _klasseToId = k -> k.id;
    @NotNull
    private static final @NotNull Function<@NotNull KlassenDaten, @NotNull Long> _klassenDatenToId = k -> k.id;
    @NotNull
    private final @NotNull HashMap2D<@NotNull Boolean, @NotNull Long, @NotNull KlassenListeEintrag> _mapKlasseIstSichtbar = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull KlassenListeEintrag> _mapKlasseInJahrgang = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull KlassenListeEintrag> _mapKlasseHatSchueler = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull KlassenListeEintrag> _mapKlassenlehrerInKlasse = new HashMap2D();
    @NotNull
    private final @NotNull HashMap2D<@NotNull String, @NotNull Long, @NotNull KlassenListeEintrag> _mapKlasseInSchulgliederung = new HashMap2D();
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull JahrgangsListeEintrag> jahrgaenge;
    @NotNull
    private static final @NotNull Function<@NotNull JahrgangsListeEintrag, @NotNull Long> _jahrgangToId = jg -> jg.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull Long, @NotNull LehrerListeEintrag> lehrer;
    @NotNull
    private static final @NotNull Function<@NotNull LehrerListeEintrag, @NotNull Long> _lehrerToId = l -> l.id;
    @NotNull
    public final @NotNull AttributMitAuswahl<@NotNull String, @NotNull Schulgliederung> schulgliederungen;
    @NotNull
    private static final @NotNull Function<@NotNull Schulgliederung, @NotNull String> _schulgliederungToId = sg -> sg.daten.kuerzel;
    @NotNull
    private static final @NotNull Comparator<@NotNull Schulgliederung> _comparatorSchulgliederung = (a, b) -> a.ordinal() - b.ordinal();
    private boolean _filterNurSichtbar = true;

    public KlassenListeManager(Schulform schulform, @NotNull @NotNull List<@NotNull KlassenListeEintrag> klassen, @NotNull @NotNull List<@NotNull JahrgangsListeEintrag> jahrgaenge, @NotNull @NotNull List<@NotNull LehrerListeEintrag> lehrer) {
        super(schulform, klassen, KlassenUtils.comparator, _klasseToId, _klassenDatenToId, Arrays.asList(new Pair<String, Boolean>("klassen", true), new Pair<String, Boolean>("schueleranzahl", true)));
        this.jahrgaenge = new AttributMitAuswahl<Long, JahrgangsListeEintrag>(jahrgaenge, _jahrgangToId, JahrgangsUtils.comparator, this._eventHandlerFilterChanged);
        this.lehrer = new AttributMitAuswahl<Long, LehrerListeEintrag>(lehrer, _lehrerToId, LehrerUtils.comparator, this._eventHandlerFilterChanged);
        @NotNull List<@NotNull Schulgliederung> gliederungen = schulform == null ? Arrays.asList(Schulgliederung.values()) : Schulgliederung.get(schulform);
        this.schulgliederungen = new AttributMitAuswahl<String, Schulgliederung>(gliederungen, _schulgliederungToId, _comparatorSchulgliederung, this._eventHandlerFilterChanged);
        this.initKlassen();
    }

    private void initKlassen() {
        for (KlassenListeEintrag k : this.liste.list()) {
            this._mapKlasseIstSichtbar.put(k.istSichtbar, k.id, k);
            if (k.idJahrgang != null) {
                Schulgliederung gliederung;
                this._mapKlasseInJahrgang.put(k.idJahrgang, k.id, k);
                JahrgangsListeEintrag j = this.jahrgaenge.getOrException(k.idJahrgang);
                if (j.kuerzelSchulgliederung != null && (gliederung = this.schulgliederungen.get(j.kuerzelSchulgliederung)) != null) {
                    this._mapKlasseInSchulgliederung.put(j.kuerzelSchulgliederung, k.id, k);
                }
            }
            for (Schueler s : k.schueler) {
                this._mapKlasseHatSchueler.put(s.id, k.id, k);
            }
            for (Long l : k.klassenLehrer) {
                this._mapKlassenlehrerInKlasse.put(l, k.id, k);
            }
        }
    }

    @Override
    protected boolean onSetDaten(@NotNull KlassenListeEintrag eintrag, @NotNull KlassenDaten daten) {
        boolean updateEintrag = false;
        if (!daten.kuerzel.equals(eintrag.kuerzel)) {
            eintrag.kuerzel = daten.kuerzel;
            updateEintrag = true;
        }
        return updateEintrag;
    }

    public Schulgliederung datenGetSchulgliederung() {
        if (this._daten == null || ((KlassenDaten)this._daten).idJahrgang == null) {
            return null;
        }
        JahrgangsListeEintrag j = this.jahrgaenge.getOrException(((KlassenDaten)this._daten).idJahrgang);
        return j.kuerzelSchulgliederung == null ? null : this.schulgliederungen.get(j.kuerzelSchulgliederung);
    }

    public boolean filterNurSichtbar() {
        return this._filterNurSichtbar;
    }

    public void setFilterNurSichtbar(boolean value) {
        this._filterNurSichtbar = value;
        this._eventHandlerFilterChanged.run();
    }

    protected int compare(@NotNull KlassenListeEintrag a, @NotNull KlassenListeEintrag b) {
        for (Pair criteria : this._order) {
            String field = (String)criteria.a;
            boolean asc = criteria.b == null || (Boolean)criteria.b != false;
            int cmp = 0;
            if ("klassen".equals(field)) {
                cmp = KlassenUtils.comparator.compare(a, b);
            } else if ("schueleranzahl".equals(field)) {
                cmp = Integer.compare(a.schueler.size(), b.schueler.size());
            } else {
                throw new DeveloperNotificationException("Fehler bei der Sortierung. Das Sortierkriterium wird vom Manager nicht unterst\u00fctzt.");
            }
            if (cmp == 0) continue;
            return asc ? cmp : -cmp;
        }
        return Long.compare(a.id, b.id);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @NotNull
    protected @NotNull List<@NotNull KlassenListeEintrag> onFilter() {
        @NotNull ArrayList<@NotNull KlassenListeEintrag> tmpList = new ArrayList<KlassenListeEintrag>();
        for (KlassenListeEintrag eintrag : this.liste.list()) {
            if (this._filterNurSichtbar && !eintrag.istSichtbar || this.jahrgaenge.auswahlExists() && (eintrag.idJahrgang == null || !this.jahrgaenge.auswahlHasKey(eintrag.idJahrgang))) continue;
            if (this.lehrer.auswahlExists()) {
                boolean hatEinenLehrer = false;
                for (long idLehrer : eintrag.klassenLehrer) {
                    if (!this.lehrer.auswahlHasKey(idLehrer)) continue;
                    hatEinenLehrer = true;
                }
                if (!hatEinenLehrer) continue;
            }
            if (this.schulgliederungen.auswahlExists()) {
                if (eintrag.idJahrgang == null) continue;
                JahrgangsListeEintrag j = this.jahrgaenge.getOrException(eintrag.idJahrgang);
                if (j.kuerzelSchulgliederung == null || j.kuerzelSchulgliederung != null && !this.schulgliederungen.auswahlHasKey(j.kuerzelSchulgliederung)) continue;
            }
            tmpList.add(eintrag);
        }
        @NotNull @NotNull Comparator comparator = (a, b) -> this.compare((KlassenListeEintrag)a, (KlassenListeEintrag)b);
        tmpList.sort(comparator);
        return tmpList;
    }
}

