/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurenCollectionSkrsKrs;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurraum;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurraumstunde;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurtermin;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurvorgabe;
import de.svws_nrw.core.data.gost.klausurplanung.GostKursklausur;
import de.svws_nrw.core.data.gost.klausurplanung.GostSchuelerklausur;
import de.svws_nrw.core.data.gost.klausurplanung.GostSchuelerklausurraumstunde;
import de.svws_nrw.core.data.stundenplan.StundenplanRaum;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.utils.Map2DUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.klausurplanung.GostKursklausurManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GostKlausurraumManager {
    @NotNull
    private final GostKursklausurManager _kursklausurManager;
    @NotNull
    private final GostKlausurtermin _termin;
    @NotNull
    private static final @NotNull Comparator<@NotNull GostKlausurraum> _compRaum = (a, b) -> Long.compare(a.id, b.id);
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurraum> _raum_by_id = new HashMap<Long, GostKlausurraum>();
    @NotNull
    private final @NotNull List<@NotNull GostKlausurraum> _raummenge = new ArrayList<GostKlausurraum>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurraum> _klausurraum_by_idStundenplanraum = new HashMap<Long, GostKlausurraum>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurraum> _klausurraum_by_idSchuelerklausur = new HashMap<Long, GostKlausurraum>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurraumstunde> _raumstunde_by_id = new HashMap<Long, GostKlausurraumstunde>();
    @NotNull
    private final @NotNull List<@NotNull GostKlausurraumstunde> _raumstundenmenge = new ArrayList<GostKlausurraumstunde>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKlausurraumstunde>> _raumstundenmenge_by_idRaum = new HashMap<Long, List<GostKlausurraumstunde>>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull GostKlausurraumstunde> _raumstunde_by_idRaum_and_idZeitraster = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostKlausurraumstunde>> _raumstundenmenge_by_idSchuelerklausur = new HashMap<Long, List<GostKlausurraumstunde>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostSchuelerklausur> _schuelerklausur_by_id = new HashMap<Long, GostSchuelerklausur>();
    @NotNull
    private final @NotNull List<@NotNull GostSchuelerklausur> _schuelerklausurmenge = new ArrayList<GostSchuelerklausur>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostSchuelerklausur>> _schuelerklausurmenge_by_idRaum = new HashMap<Long, List<GostSchuelerklausur>>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull List<@NotNull GostSchuelerklausur>> _schuelerklausurmenge_by_idRaum_and_idKursklausur = new HashMap2D();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostSchuelerklausur>> _schuelerklausurmenge_by_idKursklausur = new HashMap<Long, List<GostSchuelerklausur>>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Long, @NotNull GostSchuelerklausurraumstunde> _schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde = new HashMap2D();
    @NotNull
    private final @NotNull List<@NotNull GostSchuelerklausurraumstunde> _schuelerklausurraumstundenmenge = new ArrayList<GostSchuelerklausurraumstunde>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostSchuelerklausurraumstunde>> _schuelerklausurraumstundenmenge_by_idRaumstunde = new HashMap<Long, List<GostSchuelerklausurraumstunde>>();
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull List<@NotNull GostSchuelerklausurraumstunde>> _schuelerklausurraumstundenmenge_by_idSchuelerklausur = new HashMap<Long, List<GostSchuelerklausurraumstunde>>();

    public GostKlausurraumManager(@NotNull GostKlausurraum raum, @NotNull @NotNull List<@NotNull GostKlausurraumstunde> stunden, @NotNull @NotNull List<@NotNull GostSchuelerklausur> schuelerklausuren, @NotNull GostKursklausurManager kursklausurmanager, @NotNull GostKlausurtermin termin) {
        this._kursklausurManager = kursklausurmanager;
        this._termin = termin;
        ArrayList<@NotNull GostKlausurraum> raeume = new ArrayList<GostKlausurraum>();
        raeume.add(raum);
        this.initAll(raeume, stunden, new ArrayList<GostSchuelerklausurraumstunde>(), schuelerklausuren);
    }

    public GostKlausurraumManager(@NotNull @NotNull List<@NotNull GostKlausurraum> raeume, @NotNull @NotNull List<@NotNull GostKlausurraumstunde> listRs, @NotNull @NotNull List<@NotNull GostSchuelerklausurraumstunde> listSkrs, @NotNull @NotNull List<@NotNull GostSchuelerklausur> schuelerklausuren, @NotNull GostKursklausurManager kursklausurmanager, @NotNull GostKlausurtermin termin) {
        this._kursklausurManager = kursklausurmanager;
        this._termin = termin;
        this.initAll(raeume, listRs, listSkrs, schuelerklausuren);
    }

    private void initAll(@NotNull @NotNull List<@NotNull GostKlausurraum> listRaum, @NotNull @NotNull List<@NotNull GostKlausurraumstunde> listRaumstunde, @NotNull @NotNull List<@NotNull GostSchuelerklausurraumstunde> listSchuelerklausurraumstunde, @NotNull @NotNull List<@NotNull GostSchuelerklausur> listSchuelerklausur) {
        this.raumAddAll(listRaum);
        this.raumstundeAddAll(listRaumstunde);
        this.schuelerklausurAddAll(listSchuelerklausur);
        this.schuelerklausurraumstundeAddAll(listSchuelerklausurraumstunde);
        this.update_all();
    }

    private void update_all() {
        this.update_raummenge();
        this.update_raumstundenmenge();
        this.update_schuelerklausurmenge();
        this.update_schuelerklausurraumstundenmenge();
        this.update_klausurraum_by_idStundenplanraum();
        this.update_raumstundenmenge_by_idRaum();
        this.update_raumstunde_by_idRaum_and_idZeitraster();
        this.update_raumstundenmenge_by_idSchuelerklausur();
        this.update_schuelerklausurmenge_by_idRaum();
        this.update_schuelerklausurmenge_by_idRaum_and_idKursklausur();
        this.update_schuelerklausurmenge_by_idKursklausur();
        this.update_schuelerklausurraumstundenmenge_by_idRaumstunde();
        this.update_schuelerklausurraumstundenmenge_by_idSchuelerklausur();
        this.update_klausurraum_by_idSchuelerklausur();
    }

    private void update_klausurraum_by_idStundenplanraum() {
        this._klausurraum_by_idStundenplanraum.clear();
        for (GostKlausurraum raum : this._raummenge) {
            if (raum.idStundenplanRaum == null) continue;
            DeveloperNotificationException.ifMapPutOverwrites(this._klausurraum_by_idStundenplanraum, raum.idStundenplanRaum, raum);
        }
    }

    private void update_raumstundenmenge_by_idRaum() {
        this._raumstundenmenge_by_idRaum.clear();
        for (GostKlausurraumstunde krs : this._raumstundenmenge) {
            MapUtils.getOrCreateArrayList(this._raumstundenmenge_by_idRaum, krs.idRaum).add(krs);
        }
    }

    private void update_raumstunde_by_idRaum_and_idZeitraster() {
        this._raumstunde_by_idRaum_and_idZeitraster.clear();
        for (GostKlausurraumstunde rs : this._raumstundenmenge) {
            DeveloperNotificationException.ifMap2DPutOverwrites(this._raumstunde_by_idRaum_and_idZeitraster, rs.idRaum, rs.idZeitraster, rs);
        }
    }

    private void update_raumstundenmenge_by_idSchuelerklausur() {
        this._raumstundenmenge_by_idSchuelerklausur.clear();
        for (GostSchuelerklausurraumstunde skrs : this._schuelerklausurraumstundenmenge) {
            MapUtils.getOrCreateArrayList(this._raumstundenmenge_by_idSchuelerklausur, skrs.idSchuelerklausur).add(DeveloperNotificationException.ifMapGetIsNull(this._raumstunde_by_id, skrs.idRaumstunde));
        }
    }

    private void update_schuelerklausurmenge_by_idRaum() {
        this._schuelerklausurmenge_by_idRaum.clear();
        for (GostSchuelerklausur k : this._schuelerklausurmenge) {
            List<@NotNull GostKlausurraumstunde> raumstunden = this._raumstundenmenge_by_idSchuelerklausur.get(k.idSchuelerklausur);
            MapUtils.getOrCreateArrayList(this._schuelerklausurmenge_by_idRaum, raumstunden == null || raumstunden.isEmpty() ? -1L : raumstunden.get((int)0).idRaum).add(k);
        }
    }

    private void update_schuelerklausurmenge_by_idRaum_and_idKursklausur() {
        this._schuelerklausurmenge_by_idRaum_and_idKursklausur.clear();
        for (GostSchuelerklausur k : this._schuelerklausurmenge) {
            List<@NotNull GostKlausurraumstunde> raumstunden = this._raumstundenmenge_by_idSchuelerklausur.get(k.idSchuelerklausur);
            Map2DUtils.getOrCreateArrayList(this._schuelerklausurmenge_by_idRaum_and_idKursklausur, raumstunden == null || raumstunden.isEmpty() ? -1L : raumstunden.get((int)0).idRaum, k.idKursklausur).add(k);
        }
    }

    private void update_schuelerklausurmenge_by_idKursklausur() {
        this._schuelerklausurmenge_by_idKursklausur.clear();
        for (GostSchuelerklausur k : this._schuelerklausurmenge) {
            MapUtils.getOrCreateArrayList(this._schuelerklausurmenge_by_idKursklausur, k.idKursklausur).add(k);
        }
    }

    private void update_schuelerklausurraumstundenmenge_by_idRaumstunde() {
        this._schuelerklausurraumstundenmenge_by_idRaumstunde.clear();
        for (GostSchuelerklausurraumstunde skrs : this._schuelerklausurraumstundenmenge) {
            MapUtils.getOrCreateArrayList(this._schuelerklausurraumstundenmenge_by_idRaumstunde, skrs.idRaumstunde).add(skrs);
        }
    }

    private void update_schuelerklausurraumstundenmenge_by_idSchuelerklausur() {
        this._schuelerklausurraumstundenmenge_by_idSchuelerklausur.clear();
        for (GostSchuelerklausurraumstunde skrs : this._schuelerklausurraumstundenmenge) {
            MapUtils.getOrCreateArrayList(this._schuelerklausurraumstundenmenge_by_idSchuelerklausur, skrs.idSchuelerklausur).add(skrs);
        }
    }

    private void update_klausurraum_by_idSchuelerklausur() {
        this._klausurraum_by_idSchuelerklausur.clear();
        for (GostSchuelerklausurraumstunde skrs : this._schuelerklausurraumstundenmenge) {
            @NotNull List<@NotNull GostKlausurraumstunde> krsList = DeveloperNotificationException.ifMapGetIsNull(this._raumstundenmenge_by_idSchuelerklausur, skrs.idSchuelerklausur);
            for (GostKlausurraumstunde krs : krsList) {
                @NotNull GostKlausurraum kr = DeveloperNotificationException.ifMapGetIsNull(this._raum_by_id, krs.idRaum);
                GostKlausurraum krAlt = this._klausurraum_by_idSchuelerklausur.put(skrs.idSchuelerklausur, kr);
                if (krAlt == null || krAlt == kr) continue;
                throw new DeveloperNotificationException("Sch\u00fclerklausur " + skrs.idSchuelerklausur + " ist zwei Klausurr\u00e4umen zugeordnet.");
            }
        }
    }

    private void update_raummenge() {
        this._raummenge.clear();
        this._raummenge.addAll(this._raum_by_id.values());
        this._raummenge.sort(_compRaum);
    }

    private void raumAddOhneUpdate(@NotNull GostKlausurraum raum) {
        GostKlausurraumManager.raumCheck(raum);
        DeveloperNotificationException.ifMapPutOverwrites(this._raum_by_id, raum.id, raum);
    }

    public void raumAdd(@NotNull GostKlausurraum raum) {
        this.raumAddOhneUpdate(raum);
        this.update_all();
    }

    private void raumAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostKlausurraum> listRaum) {
        for (GostKlausurraum raum : listRaum) {
            this.raumAddOhneUpdate(raum);
        }
    }

    public void raumAddAll(@NotNull @NotNull List<@NotNull GostKlausurraum> listRaum) {
        this.raumAddAllOhneUpdate(listRaum);
        this.update_all();
    }

    private static void raumCheck(@NotNull GostKlausurraum raum) {
        DeveloperNotificationException.ifInvalidID("raum.id", raum.id);
    }

    @NotNull
    public GostKlausurraum raumGetByIdOrException(long idRaum) {
        return DeveloperNotificationException.ifMapGetIsNull(this._raum_by_id, idRaum);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurraum> raumGetMengeAsList() {
        return this._raummenge;
    }

    public void raumPatchAttributes(@NotNull GostKlausurraum raum) {
        GostKlausurraumManager.raumCheck(raum);
        DeveloperNotificationException.ifMapRemoveFailes(this._raum_by_id, raum.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._raum_by_id, raum.id, raum);
        this.update_all();
    }

    private void raumRemoveOhneUpdateById(long idRaum) {
        DeveloperNotificationException.ifMapRemoveFailes(this._raum_by_id, idRaum);
        List<@NotNull GostKlausurraumstunde> rsList = this._raumstundenmenge_by_idRaum.get(idRaum);
        if (rsList != null) {
            for (GostKlausurraumstunde rs : rsList) {
                this.raumstundeRemoveOhneUpdateById(rs.id);
            }
        }
    }

    public void raumRemoveById(long idRaum) {
        this.raumRemoveOhneUpdateById(idRaum);
        this.update_all();
    }

    public void raumRemoveAll(@NotNull @NotNull List<@NotNull GostKlausurraum> listRaum) {
        for (GostKlausurraum raum : listRaum) {
            this.raumRemoveOhneUpdateById(raum.id);
        }
        this.update_all();
    }

    private void update_raumstundenmenge() {
        this._raumstundenmenge.clear();
        this._raumstundenmenge.addAll(this._raumstunde_by_id.values());
    }

    private void raumstundeAddOhneUpdate(@NotNull GostKlausurraumstunde raumstunde) {
        GostKlausurraumManager.raumstundeCheck(raumstunde);
        DeveloperNotificationException.ifMapPutOverwrites(this._raumstunde_by_id, raumstunde.id, raumstunde);
    }

    public void raumstundeAdd(@NotNull GostKlausurraumstunde raumstunde) {
        this.raumstundeAddOhneUpdate(raumstunde);
        this.update_all();
    }

    private void raumstundeAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostKlausurraumstunde> listRaumstunde) {
        for (GostKlausurraumstunde raumstunde : listRaumstunde) {
            this.raumstundeAddOhneUpdate(raumstunde);
        }
    }

    public void raumstundeAddAll(@NotNull @NotNull List<@NotNull GostKlausurraumstunde> listRaumstunde) {
        this.raumstundeAddAllOhneUpdate(listRaumstunde);
        this.update_all();
    }

    private static void raumstundeCheck(@NotNull GostKlausurraumstunde raumstunde) {
        DeveloperNotificationException.ifInvalidID("raumstunde.id", raumstunde.id);
    }

    @NotNull
    public GostKlausurraumstunde raumstundeGetByIdOrException(long idRaumstunde) {
        return DeveloperNotificationException.ifMapGetIsNull(this._raumstunde_by_id, idRaumstunde);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurraumstunde> raumstundeGetMengeAsList() {
        return this._raumstundenmenge;
    }

    public void raumstundePatchAttributes(@NotNull GostKlausurraumstunde raumstunde) {
        GostKlausurraumManager.raumstundeCheck(raumstunde);
        DeveloperNotificationException.ifMapRemoveFailes(this._raumstunde_by_id, raumstunde.id);
        DeveloperNotificationException.ifMapPutOverwrites(this._raumstunde_by_id, raumstunde.id, raumstunde);
        this.update_all();
    }

    private void raumstundeRemoveOhneUpdateById(long idRaumstunde) {
        DeveloperNotificationException.ifMapRemoveFailes(this._raumstunde_by_id, idRaumstunde);
        List<@NotNull GostSchuelerklausurraumstunde> skrsList = this._schuelerklausurraumstundenmenge_by_idRaumstunde.get(idRaumstunde);
        if (skrsList != null) {
            for (GostSchuelerklausurraumstunde skrs : skrsList) {
                this.schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausurAndIdRaumstunde(skrs.idSchuelerklausur, skrs.idRaumstunde);
            }
        }
    }

    public void raumstundeRemoveById(long idRaumstunde) {
        this.raumstundeRemoveOhneUpdateById(idRaumstunde);
        this.update_all();
    }

    public void raumstundeRemoveAll(@NotNull @NotNull List<@NotNull GostKlausurraumstunde> listRaumstunde) {
        for (GostKlausurraumstunde raumstunde : listRaumstunde) {
            this.raumstundeRemoveOhneUpdateById(raumstunde.id);
        }
        this.update_all();
    }

    private void update_schuelerklausurmenge() {
        this._schuelerklausurmenge.clear();
        this._schuelerklausurmenge.addAll(this._schuelerklausur_by_id.values());
    }

    private void schuelerklausurAddOhneUpdate(@NotNull GostSchuelerklausur schuelerklausur) {
        GostKlausurraumManager.schuelerklausurCheck(schuelerklausur);
        DeveloperNotificationException.ifMapPutOverwrites(this._schuelerklausur_by_id, schuelerklausur.idSchuelerklausur, schuelerklausur);
    }

    public void schuelerklausurAdd(@NotNull GostSchuelerklausur schuelerklausur) {
        this.schuelerklausurAddOhneUpdate(schuelerklausur);
        this.update_all();
    }

    private void schuelerklausurAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostSchuelerklausur> listSchuelerklausur) {
        for (GostSchuelerklausur schuelerklausur : listSchuelerklausur) {
            this.schuelerklausurAddOhneUpdate(schuelerklausur);
        }
    }

    public void schuelerklausurAddAll(@NotNull @NotNull List<@NotNull GostSchuelerklausur> listSchuelerklausur) {
        this.schuelerklausurAddAllOhneUpdate(listSchuelerklausur);
        this.update_all();
    }

    private static void schuelerklausurCheck(@NotNull GostSchuelerklausur schuelerklausur) {
        DeveloperNotificationException.ifInvalidID("schuelerklausur.idSchuelerklausur", schuelerklausur.idSchuelerklausur);
    }

    @NotNull
    public GostSchuelerklausur schuelerklausurGetByIdOrException(long idSchuelerklausur) {
        return DeveloperNotificationException.ifMapGetIsNull(this._schuelerklausur_by_id, idSchuelerklausur);
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausur> schuelerklausurGetMengeAsList() {
        return this._schuelerklausurmenge;
    }

    public void schuelerklausurPatchAttributes(@NotNull GostSchuelerklausur schuelerklausur) {
        GostKlausurraumManager.schuelerklausurCheck(schuelerklausur);
        DeveloperNotificationException.ifMapRemoveFailes(this._schuelerklausur_by_id, schuelerklausur.idSchuelerklausur);
        DeveloperNotificationException.ifMapPutOverwrites(this._schuelerklausur_by_id, schuelerklausur.idSchuelerklausur, schuelerklausur);
        this.update_all();
    }

    private void schuelerklausurRemoveOhneUpdateById(long idSchuelerklausur) {
        DeveloperNotificationException.ifMapRemoveFailes(this._schuelerklausur_by_id, idSchuelerklausur);
        this.schuelerklausurraumstundenmengeRemoveOhneUpdateByIdSchuelerklausur(idSchuelerklausur);
    }

    public void schuelerklausurRemoveById(long idSchuelerklausur) {
        this.schuelerklausurRemoveOhneUpdateById(idSchuelerklausur);
        this.update_all();
    }

    public void schuelerklausurRemoveAll(@NotNull @NotNull List<@NotNull GostSchuelerklausur> listSchuelerklausur) {
        for (GostSchuelerklausur schuelerklausur : listSchuelerklausur) {
            this.schuelerklausurRemoveOhneUpdateById(schuelerklausur.idSchuelerklausur);
        }
        this.update_all();
    }

    private void update_schuelerklausurraumstundenmenge() {
        this._schuelerklausurraumstundenmenge.clear();
        this._schuelerklausurraumstundenmenge.addAll(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde.getNonNullValuesAsList());
    }

    private void schuelerklausurraumstundeAddOhneUpdate(@NotNull GostSchuelerklausurraumstunde schuelerklausurraumstunde) {
        GostKlausurraumManager.schuelerklausurraumstundeCheck(schuelerklausurraumstunde);
        DeveloperNotificationException.ifMap2DPutOverwrites(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, schuelerklausurraumstunde.idSchuelerklausur, schuelerklausurraumstunde.idRaumstunde, schuelerklausurraumstunde);
    }

    public void schuelerklausurraumstundeAdd(@NotNull GostSchuelerklausurraumstunde schuelerklausurraumstunde) {
        this.schuelerklausurraumstundeAddOhneUpdate(schuelerklausurraumstunde);
        this.update_all();
    }

    private void schuelerklausurraumstundeAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostSchuelerklausurraumstunde> listSchuelerklausurraumstunde) {
        for (GostSchuelerklausurraumstunde schuelerklausurraumstunde : listSchuelerklausurraumstunde) {
            this.schuelerklausurraumstundeAddOhneUpdate(schuelerklausurraumstunde);
        }
    }

    public void schuelerklausurraumstundeAddAll(@NotNull @NotNull List<@NotNull GostSchuelerklausurraumstunde> listSchuelerklausurraumstunde) {
        this.schuelerklausurraumstundeAddAllOhneUpdate(listSchuelerklausurraumstunde);
        this.update_all();
    }

    private static void schuelerklausurraumstundeCheck(@NotNull GostSchuelerklausurraumstunde schuelerklausurraumstunde) {
        DeveloperNotificationException.ifInvalidID("schuelerklausurraumstunde.id", schuelerklausurraumstunde.idSchuelerklausur);
        DeveloperNotificationException.ifInvalidID("schuelerklausurraumstunde.id", schuelerklausurraumstunde.idRaumstunde);
    }

    @NotNull
    public GostSchuelerklausurraumstunde schuelerklausurraumstundeGetByIdSchuelerklausurAndIdRaumstundeOrException(long idSchuelerklausur, long idRaumstunde) {
        return DeveloperNotificationException.ifMap2DGetIsNull(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, idSchuelerklausur, idRaumstunde);
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausurraumstunde> schuelerklausurraumstundeGetMengeAsList() {
        return this._schuelerklausurraumstundenmenge;
    }

    public void schuelerklausurraumstundePatchAttributes(@NotNull GostSchuelerklausurraumstunde schuelerklausurraumstunde) {
        GostKlausurraumManager.schuelerklausurraumstundeCheck(schuelerklausurraumstunde);
        DeveloperNotificationException.ifMap2DRemoveFailes(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, schuelerklausurraumstunde.idSchuelerklausur, schuelerklausurraumstunde.idRaumstunde);
        DeveloperNotificationException.ifMap2DPutOverwrites(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, schuelerklausurraumstunde.idSchuelerklausur, schuelerklausurraumstunde.idRaumstunde, schuelerklausurraumstunde);
        this.update_all();
    }

    private void schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausurAndIdRaumstunde(long idSchuelerklausur, long idRaumstunde) {
        DeveloperNotificationException.ifMap2DRemoveFailes(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, idSchuelerklausur, idRaumstunde);
    }

    private void schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausur(long idSchuelerklausur) {
        this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde.removeSubMap(idSchuelerklausur);
    }

    private void schuelerklausurraumstundenmengeRemoveOhneUpdateByIdSchuelerklausur(long idSchuelerklausur) {
        List<@NotNull GostSchuelerklausurraumstunde> skrsList = this._schuelerklausurraumstundenmenge_by_idSchuelerklausur.get(idSchuelerklausur);
        if (skrsList != null) {
            for (GostSchuelerklausurraumstunde skrs : skrsList) {
                DeveloperNotificationException.ifMap2DRemoveFailes(this._schuelerklausurraumstunde_by_idSchuelerklausur_and_idRaumstunde, skrs.idSchuelerklausur, skrs.idRaumstunde);
            }
        }
    }

    public void schuelerklausurraumstundeRemoveByIdSchuelerklausurAndIdRaumstunde(long idSchuelerklausur, long idRaumstunde) {
        this.schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausurAndIdRaumstunde(idSchuelerklausur, idRaumstunde);
        this.update_all();
    }

    public void schuelerklausurraumstundeRemoveByIdSchuelerklausur(long idSchuelerklausur) {
        this.schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausur(idSchuelerklausur);
        this.update_all();
    }

    public void schuelerklausurraumstundeRemoveAllByIdSchuelerklausur(@NotNull @NotNull List<@NotNull Long> idsSchuelerklausuren) {
        for (long idSchuelerklausur : idsSchuelerklausuren) {
            this.schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausur(idSchuelerklausur);
        }
        this.update_all();
    }

    public void schuelerklausurraumstundeRemoveAll(@NotNull @NotNull List<@NotNull GostSchuelerklausurraumstunde> listSchuelerklausurRaumstunde) {
        for (GostSchuelerklausurraumstunde schuelerklausurraumstunde : listSchuelerklausurRaumstunde) {
            this.schuelerklausurraumstundeRemoveOhneUpdateByIdSchuelerklausurAndIdRaumstunde(schuelerklausurraumstunde.idSchuelerklausur, schuelerklausurraumstunde.idRaumstunde);
        }
        this.update_all();
    }

    public GostKlausurraumstunde klausurraumstundeGetByRaumidAndZeitrasterid(long idRaum, long idZeitraster) {
        return this._raumstunde_by_idRaum_and_idZeitraster.getOrNull(idRaum, idZeitraster);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurraumstunde> klausurraumstundeGetMengeByRaumid(long idRaum) {
        ArrayList<@NotNull E> stunden = this._raumstundenmenge_by_idRaum.get(idRaum);
        return stunden != null ? stunden : new ArrayList();
    }

    public void setzeRaumZuSchuelerklausuren(@NotNull GostKlausurenCollectionSkrsKrs collectionSkrsKrs) {
        this.raumstundeRemoveAll(collectionSkrsKrs.raumstundenGeloescht);
        this.raumstundeAddAll(collectionSkrsKrs.raumstunden);
        this.schuelerklausurraumstundeRemoveAllByIdSchuelerklausur(collectionSkrsKrs.idsSchuelerklausuren);
        this.schuelerklausurraumstundeAddAll(collectionSkrsKrs.skRaumstunden);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurGetMenge() {
        ArrayList<@NotNull GostKursklausur> kursklausuren = new ArrayList<GostKursklausur>();
        for (long kkId : this._schuelerklausurmenge_by_idKursklausur.keySet()) {
            kursklausuren.add(this._kursklausurManager.kursklausurGetByIdOrException(kkId));
        }
        return kursklausuren;
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausur> schuelerklausurGetMengeByKursklausurid(long idKursklausur) {
        return DeveloperNotificationException.ifMapGetIsNull(this._schuelerklausurmenge_by_idKursklausur, idKursklausur);
    }

    @NotNull
    public @NotNull List<@NotNull GostKursklausur> kursklausurGetMengeByRaumid(long idRaum) {
        ArrayList<@NotNull GostKursklausur> kursklausuren = new ArrayList<GostKursklausur>();
        if (!this._schuelerklausurmenge_by_idRaum_and_idKursklausur.containsKey1(idRaum)) {
            return kursklausuren;
        }
        for (long idKK : this._schuelerklausurmenge_by_idRaum_and_idKursklausur.getKeySetOf(idRaum)) {
            if (this._schuelerklausurmenge_by_idRaum_and_idKursklausur.getNonNullOrException(idRaum, idKK).isEmpty()) continue;
            kursklausuren.add(this._kursklausurManager.kursklausurGetByIdOrException(idKK));
        }
        return kursklausuren;
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausur> schuelerklausurGetMengeByRaumidAndKursklausurid(long idRaum, long idKursklausur) {
        return DeveloperNotificationException.ifMap2DGetIsNull(this._schuelerklausurmenge_by_idRaum_and_idKursklausur, idRaum, idKursklausur);
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausur> schuelerklausurGetMengeByRaumid(long idRaum) {
        ArrayList<@NotNull GostSchuelerklausur> schuelerklausuren = new ArrayList<GostSchuelerklausur>();
        if (!this._schuelerklausurmenge_by_idRaum_and_idKursklausur.containsKey1(idRaum)) {
            return schuelerklausuren;
        }
        for (long idKK : this._schuelerklausurmenge_by_idRaum_and_idKursklausur.getKeySetOf(idRaum)) {
            schuelerklausuren.addAll((Collection<GostSchuelerklausur>)this._schuelerklausurmenge_by_idRaum_and_idKursklausur.getNonNullOrException(idRaum, idKK));
        }
        return schuelerklausuren;
    }

    @NotNull
    public @NotNull List<@NotNull GostSchuelerklausur> schuelerklausurOhneRaumGetMenge() {
        return this.schuelerklausurGetMengeByRaumid(-1L);
    }

    @NotNull
    public @NotNull List<@NotNull StundenplanRaum> stundenplanraumVerfuegbarGetMenge(@NotNull @NotNull List<@NotNull StundenplanRaum> alleRaeume) {
        ArrayList<@NotNull StundenplanRaum> raeume = new ArrayList<StundenplanRaum>();
        for (StundenplanRaum raum : alleRaeume) {
            if (this._klausurraum_by_idStundenplanraum.containsKey(raum.id)) continue;
            raeume.add(raum);
        }
        return raeume;
    }

    public boolean isAlleSchuelerklausurenVerplant(@NotNull GostKursklausur kk) {
        for (GostSchuelerklausur sk : DeveloperNotificationException.ifMapGetIsNull(this._schuelerklausurmenge_by_idKursklausur, kk.id)) {
            if (this._raumstundenmenge_by_idSchuelerklausur.containsKey(sk.idSchuelerklausur)) continue;
            return false;
        }
        return true;
    }

    public boolean containsKlausurraumKursklausur(long idRaum, long idKursklausur) {
        return this._schuelerklausurmenge_by_idRaum_and_idKursklausur.contains(idRaum, idKursklausur);
    }

    @NotNull
    public GostKursklausurManager getKursklausurManager() {
        return this._kursklausurManager;
    }

    public Integer getGemeinsameKursklausurdauerByKlausurraum(@NotNull GostKlausurraum raum) {
        int dauer = -1;
        for (GostKursklausur klausur : this.kursklausurGetMengeByRaumid(raum.id)) {
            @NotNull GostKlausurvorgabe vorgabe = this._kursklausurManager.vorgabeByKursklausur(klausur);
            if (dauer == -1) {
                dauer = vorgabe.dauer;
            }
            if (dauer == vorgabe.dauer) continue;
            return null;
        }
        return dauer;
    }

    public Integer getGemeinsamerKursklausurstartByKlausurraum(@NotNull GostKlausurraum raum) {
        Integer start = -1;
        for (GostKursklausur klausur : this.kursklausurGetMengeByRaumid(raum.id)) {
            if (start != null && start == -1) {
                start = klausur.startzeit;
            }
            if (!this._kursklausurManager.hatAbweichendeStartzeitByKursklausur(klausur)) continue;
            return null;
        }
        return start == null ? this._termin.startzeit : start;
    }
}

