/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.utils.klausurplanung;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.adt.map.HashMap3D;
import de.svws_nrw.core.adt.map.HashMap4D;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.klausurplanung.GostKlausurvorgabe;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.gost.GostHalbjahr;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.utils.Map2DUtils;
import de.svws_nrw.core.utils.Map3DUtils;
import de.svws_nrw.core.utils.gost.GostFaecherManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GostKlausurvorgabenManager {
    private GostFaecherManager _faecherManager;
    @NotNull
    private final @NotNull Comparator<@NotNull GostKlausurvorgabe> _compVorgabe = (a, b) -> {
        if (a.kursart.compareTo(b.kursart) < 0) {
            return 1;
        }
        if (a.kursart.compareTo(b.kursart) > 0) {
            return -1;
        }
        if (this._faecherManager != null) {
            GostFach aFach = this._faecherManager.get(a.idFach);
            GostFach bFach = this._faecherManager.get(b.idFach);
            if (aFach != null && bFach != null) {
                if (aFach.sortierung > bFach.sortierung) {
                    return 1;
                }
                if (aFach.sortierung < bFach.sortierung) {
                    return -1;
                }
            }
        }
        if (a.halbjahr != b.halbjahr) {
            return Integer.compare(a.halbjahr, b.halbjahr);
        }
        return Integer.compare(a.quartal, b.quartal);
    };
    @NotNull
    private final @NotNull Map<@NotNull Long, @NotNull GostKlausurvorgabe> _vorgabe_by_id = new HashMap<Long, GostKlausurvorgabe>();
    @NotNull
    private final @NotNull List<@NotNull GostKlausurvorgabe> _vorgabenmenge = new ArrayList<GostKlausurvorgabe>();
    @NotNull
    private final @NotNull HashMap2D<@NotNull Integer, @NotNull Integer, @NotNull List<@NotNull GostKlausurvorgabe>> _vorgabenmenge_by_halbjahr_and_quartal = new HashMap2D();
    @NotNull
    private final @NotNull HashMap4D<@NotNull Integer, @NotNull Integer, @NotNull String, @NotNull Long, @NotNull GostKlausurvorgabe> _vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach = new HashMap4D();
    @NotNull
    private final @NotNull HashMap3D<@NotNull Integer, @NotNull String, @NotNull Long, @NotNull List<@NotNull GostKlausurvorgabe>> _vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach = new HashMap3D();

    public GostKlausurvorgabenManager(@NotNull @NotNull List<@NotNull GostKlausurvorgabe> listVorgaben, GostFaecherManager faecherManager) {
        this._faecherManager = faecherManager;
        this.initAll(listVorgaben);
    }

    private void initAll(@NotNull @NotNull List<@NotNull GostKlausurvorgabe> listVorgaben) {
        this.vorgabeAddAll(listVorgaben);
        this.update_all();
    }

    public GostFaecherManager getFaecherManager() {
        return this._faecherManager;
    }

    private void update_all() {
        this.update_vorgabemenge();
        this.update_vorgabenmenge_by_halbjahr_and_quartal();
        this.update_vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach();
        this.update_vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach();
    }

    private void update_vorgabenmenge_by_halbjahr_and_quartal() {
        this._vorgabenmenge_by_halbjahr_and_quartal.clear();
        for (GostKlausurvorgabe v : this._vorgabenmenge) {
            Map2DUtils.getOrCreateArrayList(this._vorgabenmenge_by_halbjahr_and_quartal, v.halbjahr, v.quartal).add(v);
        }
    }

    private void update_vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach() {
        this._vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach.clear();
        for (GostKlausurvorgabe v : this._vorgabenmenge) {
            this._vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach.put(v.halbjahr, v.quartal, v.kursart, v.idFach, v);
        }
    }

    private void update_vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach() {
        this._vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach.clear();
        for (GostKlausurvorgabe v : this._vorgabenmenge) {
            Map3DUtils.getOrCreateArrayList(this._vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach, v.halbjahr, v.kursart, v.idFach).add(v);
        }
    }

    private void update_vorgabemenge() {
        this._vorgabenmenge.clear();
        this._vorgabenmenge.addAll(this._vorgabe_by_id.values());
        this._vorgabenmenge.sort(this._compVorgabe);
    }

    private void vorgabeAddOhneUpdate(@NotNull GostKlausurvorgabe vorgabe) {
        GostKlausurvorgabenManager.vorgabeCheck(vorgabe);
        DeveloperNotificationException.ifMapPutOverwrites(this._vorgabe_by_id, vorgabe.idVorgabe, vorgabe);
    }

    public void vorgabeAdd(@NotNull GostKlausurvorgabe vorgabe) {
        this.vorgabeAddOhneUpdate(vorgabe);
        this.update_all();
    }

    private void vorgabeAddAllOhneUpdate(@NotNull @NotNull List<@NotNull GostKlausurvorgabe> listVorgaben) {
        for (GostKlausurvorgabe vorgabe : listVorgaben) {
            this.vorgabeAddOhneUpdate(vorgabe);
        }
    }

    public void vorgabeAddAll(@NotNull @NotNull List<@NotNull GostKlausurvorgabe> listVorgaben) {
        this.vorgabeAddAllOhneUpdate(listVorgaben);
        this.update_all();
    }

    private static void vorgabeCheck(@NotNull GostKlausurvorgabe vorgabe) {
        DeveloperNotificationException.ifInvalidID("kursklausur.id", vorgabe.idVorgabe);
    }

    @NotNull
    public GostKlausurvorgabe vorgabeGetByIdOrException(long idVorgabe) {
        return DeveloperNotificationException.ifMapGetIsNull(this._vorgabe_by_id, idVorgabe);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurvorgabe> vorgabeGetMengeAsList() {
        return this._vorgabenmenge;
    }

    public void vorgabePatchAttributes(@NotNull GostKlausurvorgabe vorgabe) {
        GostKlausurvorgabenManager.vorgabeCheck(vorgabe);
        DeveloperNotificationException.ifMapRemoveFailes(this._vorgabe_by_id, vorgabe.idVorgabe);
        DeveloperNotificationException.ifMapPutOverwrites(this._vorgabe_by_id, vorgabe.idVorgabe, vorgabe);
        this.update_all();
    }

    private void vorgabeRemoveOhneUpdateById(long idVorgabe) {
        DeveloperNotificationException.ifMapRemoveFailes(this._vorgabe_by_id, idVorgabe);
    }

    public void vorgabeRemoveById(long idVorgabe) {
        this.vorgabeRemoveOhneUpdateById(idVorgabe);
        this.update_all();
    }

    public void vorgabeRemoveAll(@NotNull @NotNull List<@NotNull GostKlausurvorgabe> listVorgaben) {
        for (GostKlausurvorgabe vorgabe : listVorgaben) {
            this.vorgabeRemoveOhneUpdateById(vorgabe.idVorgabe);
        }
        this.update_all();
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurvorgabe> vorgabeGetMengeByHalbjahrAndQuartal(@NotNull GostHalbjahr halbjahr, int quartal) {
        if (quartal == 0) {
            ArrayList<@NotNull GostKlausurvorgabe> vorgaben = new ArrayList<GostKlausurvorgabe>();
            if (this._vorgabenmenge_by_halbjahr_and_quartal.containsKey1(halbjahr.id)) {
                for (List<GostKlausurvorgabe> vQuartal : this._vorgabenmenge_by_halbjahr_and_quartal.getNonNullValuesOfKey1AsList(halbjahr.id)) {
                    vorgaben.addAll(vQuartal);
                }
            }
            return vorgaben;
        }
        ArrayList<@NotNull E> vorgaben = this._vorgabenmenge_by_halbjahr_and_quartal.getOrNull(halbjahr.id, quartal);
        return vorgaben != null ? vorgaben : new ArrayList();
    }

    public GostKlausurvorgabe vorgabeGetByHalbjahrAndQuartalAndKursartallgAndFachid(@NotNull GostHalbjahr halbjahr, int quartal, @NotNull GostKursart kursartAllg, long idFach) {
        return this._vorgabe_by_halbjahr_and_quartal_and_kursartAllg_and_idFach.getOrNull(halbjahr.id, quartal, kursartAllg.kuerzel, idFach);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurvorgabe> vorgabeGetMengeByHalbjahrAndQuartalAndKursartallgAndFachid(@NotNull GostHalbjahr halbjahr, int quartal, @NotNull GostKursart kursartAllg, long idFach) {
        if (quartal > 0) {
            ArrayList<@NotNull GostKlausurvorgabe> retList = new ArrayList<GostKlausurvorgabe>();
            GostKlausurvorgabe vorgabe = this.vorgabeGetByHalbjahrAndQuartalAndKursartallgAndFachid(halbjahr, quartal, kursartAllg, idFach);
            if (vorgabe != null) {
                retList.add(vorgabe);
            }
            return retList;
        }
        return this.vorgabeGetMengeByHalbjahrAndKursartallgAndFachid(halbjahr, kursartAllg, idFach);
    }

    @NotNull
    public @NotNull List<@NotNull GostKlausurvorgabe> vorgabeGetMengeByHalbjahrAndKursartallgAndFachid(@NotNull GostHalbjahr halbjahr, @NotNull GostKursart kursartAllg, long idFach) {
        ArrayList<@NotNull E> list = this._vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach.getOrNull(halbjahr.id, kursartAllg.kuerzel, idFach);
        return list != null ? list : new ArrayList();
    }

    public GostKlausurvorgabe getPrevious(@NotNull GostKlausurvorgabe vorgabe) {
        List<@NotNull GostKlausurvorgabe> vorgabenSchuljahr = this._vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach.getNonNullOrException(vorgabe.halbjahr, vorgabe.kursart, vorgabe.idFach);
        if (vorgabe.halbjahr % 2 == 1) {
            vorgabenSchuljahr.addAll((Collection<GostKlausurvorgabe>)this._vorgabenmenge_by_halbjahr_and_kursartAllg_and_idFach.getNonNullOrException(vorgabe.halbjahr - 1, vorgabe.kursart, vorgabe.idFach));
        }
        vorgabenSchuljahr.sort(this._compVorgabe);
        int listIndex = vorgabenSchuljahr.indexOf(vorgabe);
        if (listIndex == 0) {
            return null;
        }
        return vorgabenSchuljahr.get(listIndex - 1);
    }
}

